package jp.co.sra.smalltalk;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/**
 * StImageTestExamples class
 * 
 *  @author    Hoshi Takanori
 *  @created   2001/11/30 (by Hoshi Takanori)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StImageTestExamples.java,v 8.11 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StImageTestExamples extends SmalltalkTestExamples {

	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		StImage image = new StImage(128, 96);
		if (image == null) {
			return false;
		}

		image._display();
		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		StImage image = StImage._FromUser();
		if (image == null) {
			return false;
		}

		image._display();
		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Rectangle rect = SystemInterface._RectangleFromUser();
		if (rect == null) {
			return false;
		}

		System.out.println("rect = " + rect);
		StImage image = StImage._OfArea(rect);
		if (image == null) {
			return false;
		}

		image._display();
		return true;
	}

	/**
	 * Example4:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		StImage image = StImage._OfWholeScreen();
		if (image == null) {
			return false;
		}

		image._display();
		return true;
	}

	/**
	 * Example5:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		StImage image1 = StImage._FromUser();
		StImage image2 = null;
		try {
			ByteArrayOutputStream bout = new ByteArrayOutputStream();
			ObjectOutputStream oout = new ObjectOutputStream(bout);

			oout.writeObject(image1);
			oout.flush();

			ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
			image2 = (StImage) oin.readObject();

			oout.close();
			oin.close();
		} catch (java.io.IOException e) {
			System.out.println(e.getMessage());
			e.printStackTrace();
			return false;
		} catch (ClassNotFoundException e) {
			System.out.println(e.getMessage());
			e.printStackTrace();
			return false;
		}

		image1._display();
		image2._display();

		int[] pixels1 = image1.getPixels();
		int[] pixels2 = image2.getPixels();
		for (int i = 0; i < pixels1.length; i++) {
			if (pixels1[i] != pixels2[i]) {
				System.out.println("pixels[" + i + "] image1 = " + pixels1[i] + " image2 = " + pixels2[i]);
				return false;
			}
		}

		byte[] bytes1 = image1.bits();
		byte[] bytes2 = image2.bits();
		for (int i = 0; i < bytes1.length; i++) {
			if (bytes1[i] != bytes2[i]) {
				System.out.println("bits[" + i + "] image1 = " + bytes1[i] + " image2 = " + bytes2[i]);
				return false;
			}
		}

		return true;
	}

	/**
	 * Example6:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		StImage image = StImage._FromUser();
		if (image == null) {
			return false;
		}

		image.rotatedByQuadrants_(0)._display();
		image.rotatedByQuadrants_(1)._display();
		image.rotatedByQuadrants_(2)._display();
		image.rotatedByQuadrants_(3)._display();
		return true;
	}

	/**
	 * Example_CombinationRule :
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_CombinationRule() {
		int size = 32;

		StImage image = new StImage(200, 200);
		Graphics graphics = null;
		try {
			graphics = image.image().getGraphics();

			for (int rule = 0; rule < 16; rule++) {
				int x = (rule % 4) * (size + 4) + 3;
				int y = (rule / 4) * (size + 4) + 3;

				StImage srcImage = new StImage(size, size);
				Graphics srcGraphics = null;
				try {
					srcGraphics = srcImage.image().getGraphics();
					srcGraphics.setColor(Color.white);
					srcGraphics.fillRect(0, 0, srcImage.width(), srcImage.height());
					srcGraphics.setColor(Color.black);
					srcGraphics.fillRect(16, 4, 12, 24);
					srcImage.image().flush();
				} finally {
					if (srcGraphics != null) {
						srcGraphics.dispose();
						srcGraphics = null;
					}
				}

				StImage dstImage = new StImage(size, size);
				Graphics dstGraphics = null;
				try {
					dstGraphics = dstImage.image().getGraphics();
					dstGraphics.setColor(Color.white);
					dstGraphics.fillRect(0, 0, dstImage.width(), dstImage.height());
					dstGraphics.setColor(Color.black);
					dstGraphics.fillPolygon(new int[] { 4, 28, 4, 4 }, new int[] { 4, 16, 28, 4 }, 4);
					dstImage.image().flush();
				} finally {
					if (dstGraphics != null) {
						dstGraphics.dispose();
						dstGraphics = null;
					}
				}

				dstImage.copy_from_in_rule_(dstImage.bounds(), new Point(0, 0), srcImage, rule);
				dstImage.displayOn_at_(graphics, new Point(x, y));
				graphics.setColor(Color.gray);
				graphics.drawRect(x - 1, y - 1, size + 1, size + 1);
			}

			image.image().flush();
		} finally {
			if (graphics != null) {
				graphics.dispose();
				graphics = null;
			}
		}

		image._display();

		return true;
	}

	/**
	 * Sample Image1:
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Private
	 */
	protected static StImage Image1() {
		return new StImage(
				17,
				19,
				StByteArray
						.FromPackedString_("2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT@L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5@CH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MP@2MCT2MCTP$IBP$IBP$IB@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@2MCT2MCT2MCT@L#P5L#P5DIBP-[V5-[V5-[V5 @@@@@@@@@@@J6-+Z6-+Z6-+P@@@J6-+P@@@L#P5L#P5@CH4MSH4MQBP$KV5-Z-+Z6-+Z4@@@@@@@@@@@B-+Z6-+Z6-+Z4@@@B-+Z6-+Z4@@@CH4MP@2MCT2MCTP$IB5-[V+Z6-+Z6-@@@@@@@@@@@@+Z6-+Z6-+Z6-@@@@+Z6-+Z6-@@@@2MCT@L#P5L#P5DIBP-[V5*6-+Z6-+P@@@@@@@@@@@@@@@@@@@@@@@J6-+Z6-+Z6-+P@@@L#P5@CH4MSH4MQBP$KV5-Z-+Z6-+Z6-+Z6-+Z6-+Z6-+Z6-+Z6-+Z6-+Z6-+Z6-+Z4@@@CH4MP@2MCT2MCTP$IB5-[V+Z6-X6M#X6M#X6M#X6M#X6M#X6M#X6M#X6M#+Z6-+Z6-@@@@2MCT@L#P5L#P5DIBP-[V5&M#X?????????????????????????????_&+VM#X:6-+P@@@L#P5@CH4MSH4MQBP$KV5-Y#X6O????????????????????????79*7???=#X6N-+Z4@@@CH4MP@2MCT2MCTP$IB5-[VX6M#????????????????????=>Z-????=>Z-X6M#+Z6-@@@@2MCT@L#P5L#P5DIBP-[V5&M#X?????????????????_&+_????_&+__&+VM#X:6-+P@@@L#P5@CH4MSH4MQBP$KV5-Y#X6O????????????79*7????79*779*779*5#X6L@@@@@@@CH4MP@2MCT2MCTP$IB5-[VX6M#????????=>Z-????=>Z-=>Z-=>Z-=>Z-X6M#????@@@@2MCT@L#P5L#P5@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@L#P5@CH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MP@2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT@@@a"),
				new DirectColorModel(24, 255 << 0, 255 << 8, 255 << 16));
	}

	/**
	 * Sample Image2:
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Private
	 */
	protected static StImage Image2() {
		return new StImage(
				17,
				19,
				StByteArray
						.FromPackedString_("@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@P$IB@DIBP ABP$H@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@2MCT@L#P5@CH4MP@2MCT@L#P5@ABP$H@5-[V@M[V5 CV5-X@@@@@@@@@@@@@@@@@+Z6-@J6-+PB-+Z4@@@@@@J6-+P@@@@@@2MCT@L#P5@CH4MP@2MCT@DIBP CV5-X@+Z6-@J6-+P@@@@@@@@@@@@@@@@B-+Z4@+Z6-@J6-+P@@@@@@+Z6-@J6-+P@@@@@@2MCT@L#P5@CH4MP@P$IB@M[V5 B-+Z4@+Z6-@@@@@@@@@@@@@@@@@J6-+PB-+Z4@+Z6-@@@@@@B-+Z4@+Z6-@@@@@@CH4MP@2MCT@L#P5@ABP$H@5-[V@J6-+PB-+Z4@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+Z6-@J6-+PB-+Z4@@@@@@L#P5@CH4MP@2MCT@DIBP CV5-X@+Z6-@J6-+PB-+Z4@+Z6-@J6-+PB-+Z4@+Z6-@J6-+PB-+Z4@+Z6-@J6-+P@@@@@@2MCT@L#P5@CH4MP@P$IB@M[V5 B-+Z4@X6M#@FM#X0A#X6L@X6M#@FM#X0A#X6L@X6M#@FM#X0B-+Z4@+Z6-@@@@@@CH4MP@2MCT@L#P5@ABP$H@5-[V@FM#X0C???<@????@O???0C???<@????@O???0C???<@=>Z-@FM#X0B-+Z4@@@@@@L#P5@CH4MP@2MCT@DIBP CV5-X@X6M#@O???0C???<@????@O???0C???<@????@O_&+PC???<@X6M#@J6-+P@@@@@@2MCT@L#P5@CH4MP@P$IB@M[V5 A#X6L@????@O???0C???<@????@O???0C79*4@????@O_&+PA#X6L@+Z6-@@@@@@CH4MP@2MCT@L#P5@ABP$H@5-[V@FM#X0C???<@????@O???0C???<@=>Z-@O???0C79*4@=>Z-@FM#X0B-+Z4@@@@@@L#P5@CH4MP@2MCT@DIBP CV5-X@X6M#@O???0C???<@????@O_&+PC???<@=>Z-@O_&+PC79*4@X6M#@@@@@@@@@@@@2MCT@L#P5@CH4MP@P$IB@M[V5 A#X6L@????@O???0C79*4@????@O_&+PC79*4@=>Z-@O_&+PA#X6L@????@@@@@@CH4MP@2MCT@L#P5@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MPb"),
				new DirectColorModel(32, 0x000000ff, 0x0000ff00, 0x00ff0000, 0xff000000));
	}

	/**
	 * Sample Image3:
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Private
	 */
	protected static StImage Image3() {
		byte[] rgb = new byte[] { (byte) 255, (byte) 0 };

		return new StImage(16, 16, new byte[] {
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0,
				(byte) 255,
				(byte) 0 }, new IndexColorModel(1, 2, rgb, rgb, rgb));
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new StImageTestExamples();
	}

}
