package jp.co.sra.smalltalk;

/**
 * StDependencyTransformer class
 * 
 *  @author    nisinaka
 *  @created   1998/10/14 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StDependencyTransformer.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StDependencyTransformer extends StObject {
	protected StObject receiver = null;
	protected StSymbol aspect = null;
	protected String selector = null;
	protected int numArguments;

	/**
	 * Answer the number of arguments of a selector aSymbol.
	 * 
	 * @param aSymbol java.lang.String
	 * @return int
	 * @category Utilities
	 */
	public static int _NumArgs(String aSymbol) {
		int number = 0;

		for (int i = 0; i < aSymbol.length(); i++) {
			if (aSymbol.charAt(i) == '_') {
				number++;
			}
		}

		return number;
	}

	/**
	 * Answer true if the receiver matches the condition specified with the
	 * arguments.
	 * 
	 * @param anObject jp.co.sra.smalltalk.StObject
	 * @param anAspect jp.co.sra.smalltalk.StSymbol
	 * @return boolean
	 * @category testing
	 */
	public boolean matches_forAspect_(StObject anObject, StSymbol anAspect) {
		return (receiver == anObject && aspect == anAspect);
	}

	/**
	 * Initialize the StDependencyTransformer.
	 * 
	 * @param aReceiver jp.co.sra.smalltalk.StObject
	 * @param anAspect jp.co.sra.smalltalk.StSymbol
	 * @param aSymbol java.lang.String
	 * @category initialize-release
	 */
	public void setReceiver_aspect_selector_(StObject aReceiver, StSymbol anAspect, String aSymbol) {
		receiver = aReceiver;
		aspect = anAspect;
		selector = aSymbol;
		numArguments = _NumArgs(selector);

		if (numArguments > 2) {
			throw SmalltalkException.Error("selector expects too many arguments");
		}
	}

	/**
	 * Receive a change notice from an object.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @throws jp.co.sra.smalltalk.SmalltalkException
	 * @see jp.co.sra.smalltalk.StObject#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		if (aspect != evt.getAspect()) {
			return;
		}

		try {
			switch (numArguments) {
				case 0 :
					receiver.perform_(selector);
					return;
				case 1 :
					receiver.perform_with_(selector, evt.getParameter());
					return;
				case 2 :
					receiver.perform_with_with_(selector, evt.getParameter(), evt.getSource());
					return;
			}
		} catch (Exception e) {
			throw new SmalltalkException(e);
		}
	}
}
