package jp.co.sra.smalltalk;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;

/**
 * StComposedTextTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2002/11/20 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StComposedTextTestExamples.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StComposedTextTestExamples extends SmalltalkTestExamples {
	/**
	 * Example1: Create an instance of StComposedText.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		StComposedText composedText = new StComposedText("An example of the StComposedText");
		System.out.println(composedText);
		return true;
	}

	/**
	 * Example2: Convert the StComposedText to an image.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		StComposedText composedText = new StComposedText("An example of the StComposedText");
		StImage.Display_(new StImage(composedText.toImage()));
		return true;
	}

	/**
	 * Example3: StComposedText with multiple lines of text.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		String text = "";
		text += "An example of the StComposedText\n";
		text += "with multiple lines of text\n";
		StComposedText composedText = new StComposedText(text);
		StImage.Display_(new StImage(composedText.toImage()));
		return true;
	}

	/**
	 * Example4: StComposedText with multiple lines of text and an attribute of font.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		String text = "";
		text += "An example of the StComposedText\n";
		text += "with multiple lines of text\n";
		text += "and an attribute of font\n";
		StComposedText composedText = new StComposedText(text, new Font("Time", Font.BOLD, 24));
		StImage.Display_(new StImage(composedText.toImage()));
		return true;
	}

	/**
	 * Example5: StComposedText, which composition width is specified.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		String text = "An example of the StComposedText, which composition width is specified.";
		StComposedText composedText = new StComposedText(text, new Font("Times New Roman", Font.BOLD, 24), 250);

		int width = composedText.width();
		int height = composedText.height();
		StImage anImage = new StImage(width + 20, height + 20);
		Graphics2D aGraphics = null;
		try {
			aGraphics = (Graphics2D) anImage.image().getGraphics();
			aGraphics.setColor(Color.black);
			aGraphics.fillRect(10, 10, width, height);
			aGraphics.setColor(Color.pink);
			composedText.displayOn_at_(aGraphics, new Point(10, 10));
		} finally {
			if (aGraphics != null) {
				aGraphics.dispose();
				aGraphics = null;
			}
		}

		StImage.Display_(anImage);
		return true;
	}

	/**
	 * Example6: StComposedText with multiple lines of text including a blank line.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		String text = "";
		text += "An example of the StComposedText\n";
		text += "with multiple lines of text\n";
		text += "\n";
		text += "including a blank line.\n";
		StComposedText composedText = new StComposedText(text, new Font("Time", Font.BOLD, 24));
		StImage.Display_(new StImage(composedText.toImage()));
		return true;
	}

	/**
	 * Example6: StComposedText with two blank lines.  The result will be different from Smalltalk.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6_1() {
		String text = "\n";
		StComposedText composedText = new StComposedText(text, new Font("Time", Font.BOLD, 24));
		StImage.Display_(new StImage(composedText.toImage()));
		return true;
	}

	/**
	 * Example7: Check if the hyphenated word does not word wrapped.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7() {
		String text = "An example of the hyphenated-word, which composition width is specified.";
		StComposedText composedText = new StComposedText(text, new Font("Times New Roman", Font.BOLD, 24), 350);
		StImage.Display_(new StImage(composedText.toImage()));
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new StComposedTextTestExamples();
	}
}
