package jp.co.sra.smalltalk;

/**
 * StBlockValue class
 * 
 *  @author    nisinaka
 *  @created   1998/10/15 (by nisinaka)
 *  @updated   1998/11/09 (by nisinaka)
 *  @updated   2003/03/07 (by nisinaka)
 *  @updated   2006/04/18 (by nisinaka)
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StBlockValue.java,v 8.9 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StBlockValue extends StComputedValue {

	/** The block closure to evaluate. */
	protected StBlockClosure block = null;

	/** The array of StBlockValued, each of the object has a dependency. */
	protected StBlockValued[] arguments = null;

	/** The number of arguments block takes. */
	protected int numArgs;

	/**
	 * Create a new instance of StBlockValue and initialize it.
	 *
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category Instance creation
	 */
	public StBlockValue(StBlockClosure aBlock) {
		this.setBlock_(aBlock);
	}

	/**
	 * Create a new instance of StBlockValue and initialize it.
	 *
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param aValued jp.co.sra.smalltalk.StBlockValued
	 * @category Instance creation
	 */
	public StBlockValue(StBlockClosure aBlock, StBlockValued aValued) {
		this.setBlock_arguments_(aBlock, new StBlockValued[] { aValued });
	}

	/**
	 * Create a new instance of StBlockValue and initialize it.
	 *
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param anArray jp.co.sra.smalltalk.StBlockValued[]
	 * @category Instance creation
	 */
	public StBlockValue(StBlockClosure aBlock, StBlockValued[] anArray) {
		this.setBlock_arguments_(aBlock, anArray);
	}

	/**
	 * Answer a collection of objects that have the receiver as a dependent.
	 * 
	 * @return jp.co.sra.smalltalk.StBlockValued[]
	 * @see jp.co.sra.smalltalk.StComputedValue#parts()
	 * @category accessing
	 */
	public StBlockValued[] parts() {
		if (arguments == null) {
			arguments = new StBlockValued[0];
		}
		return arguments;
	}

	/**
	 * Compute a value for the receiver.
	 * 
	 * @return java.lang.Object
	 * @category private
	 */
	public Object computeValue() {
		switch (numArgs) {
			case 0:
				return block.value();
			case 1:
				return block.value_(arguments[0].value());
			case 2:
				return block.value_value_(arguments[0].value(), arguments[1].value());
			case 3:
				return block.value_value_value_(arguments[0].value(), arguments[1].value(), arguments[2].value());
		}

		Object[] anArray = new Object[Math.min(numArgs, arguments.length)];
		for (int i = 0; i < anArray.length; i++) {
			anArray[i] = arguments[i].value();
		}
		return block.valueWithArguments_(anArray);
	}

	/**
	 * Set the block for the receiver.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category private
	 */
	protected void setBlock_(StBlockClosure aBlock) {
		block = aBlock;
		numArgs = aBlock.numArgs();
		cachedValue = UnassignedValue;
		arguments = new StBlockValued[0];
	}

	/**
	 * Set the receiver's block and the arguments.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param anArray jp.co.sra.smalltalk.StBlockValued[]
	 * @category private
	 */
	protected void setBlock_arguments_(StBlockClosure aBlock, StBlockValued[] anArray) {
		this.setBlock_(aBlock);
		arguments = anArray;
		for (int i = 0; i < arguments.length; i++) {
			arguments[i].addDependentListener(this);
		}
	}

}
