package jp.co.sra.smalltalk;

import java.io.IOException;
import java.io.Writer;

/**
 * StAssociation class
 * 
 *  @author    nisinaka
 *  @created   1999/06/23 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StAssociation.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StAssociation extends StObject {
	/** The key object of the association. */
	Object key = null;

	/** The value object of the association. */
	Object value = null;

	/**
	 * Create a new instance of <code>StAssociation</code> and initialize it.
	 * 
	 * @param keyObject java.lang.Object
	 * @param valueObject java.lang.Object
	 * @category Instance creation
	 */
	public StAssociation(Object keyObject, Object valueObject) {
		key = keyObject;
		value = valueObject;
	}

	/**
	 * Answer the key object of the receiver.
	 * 
	 * @return java.lang.Object
	 * @category accessing
	 */
	public final Object key() {
		return key;
	}

	/**
	 * Print my string representation on aWriter.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws IOException DOCUMENT ME!
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write(key + "->" + value);
	}

	/**
	 * Returns a String that represents the value of this object.
	 * 
	 * @return a string representation of the receiver
	 * @see jp.co.sra.smalltalk.StObject#toString()
	 * @category printing
	 */
	public String toString() {
		// Insert code to print the receiver here.
		// This implementation forwards the message to super. You may replace or supplement this.
		return super.toString();
	}

	/**
	 * Answer the value object of the receiver.
	 * 
	 * @return java.lang.Object
	 * @category accessing
	 */
	public final Object value() {
		return value;
	}
}
