package jp.co.sra.smalltalk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Window;

import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuBarView;
import jp.co.sra.smalltalk.menu.StMenuBarViewAwt;

/**
 * StApplicationWindowAwt class
 * 
 *  @author    nisinaka
 *  @created   2005/02/22 (by nisinaka)
 *  @updated   2006/10/04 (by nisinaka)
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StApplicationWindowAwt.java,v 8.9 2008/02/20 06:33:17 nisinaka Exp $
 */
public class StApplicationWindowAwt extends Frame implements StApplicationWindow {

	protected StApplicationModel application;
	protected StView view;
	protected StMenuBarViewAwt menuBarView;

	/**
	 * Create a new instance of StApplicationWindowAwt and initialize it.
	 *
	 * @param anApplication jp.co.sra.smalltalk.StApplicationModel
	 * @category Instance creation
	 */
	public StApplicationWindowAwt(StApplicationModel anApplication, StView aView) {
		this.application_(anApplication);
		this.view_(aView);
		this.buildWindow();
	}

	/**
	 * Answer my current application.
	 * 
	 * @return jp.co.sra.smalltalk.StApplicationModel
	 * @see jp.co.sra.smalltalk.StApplicationWindow#application()
	 * @category accessing
	 */
	public StApplicationModel application() {
		return application;
	}

	/**
	 * Set my new application.
	 * 
	 * @param anApplication jp.co.sra.smalltalk.StApplication
	 * @see jp.co.sra.smalltalk.StApplicationWindow#application_(jp.co.sra.smalltalk.StApplicationModel)
	 * @category accessing
	 */
	public void application_(StApplicationModel anApplication) {
		if (application != null) {
			application.removeDependentListener(this);
		}

		application = anApplication;

		if (application != null) {
			application.addDependentListener(this);
		}
	}

	/**
	 * Answer my current view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationWindow#view()
	 * @category accessing
	 */
	public StView view() {
		return view;
	}

	/**
	 * Set my new view.
	 * 
	 * @param aView jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationWindow#view_(jp.co.sra.smalltalk.StView)
	 * @category accessing
	 */
	public void view_(StView aView) {
		view = aView;
	}

	/**
	 * Answer my current menu bar view.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenuBarView
	 * @see jp.co.sra.smalltalk.StApplicationWindow#menuBarView()
	 * @category accessing
	 */
	public StMenuBarView menuBarView() {
		return menuBarView;
	}

	/**
	 * Set my new menu bar view.
	 * 
	 * @param aMenuBarView jp.co.sra.smalltalk.menu.StMenuBarViewSwing
	 * @category accessing
	 */
	protected void menuBarView_(StMenuBarViewAwt aMenuBarView) {
		this.setMenuBar(aMenuBarView.toMenuBar());
		this.pack();

		menuBarView = aMenuBarView;
	}

	/**
	 * Convert to Window.
	 * 
	 * @return java.awt.Window
	 * @see jp.co.sra.smalltalk.StApplicationWindow#toWindow()
	 * @category converting
	 */
	public Window toWindow() {
		return (Window) this;
	}

	/**
	 * Convert to Frame.
	 * 
	 * @return java.awt.Frame
	 * @see jp.co.sra.smalltalk.StApplicationWindow#toFrame()
	 * @category converting
	 */
	public Frame toFrame() {
		return (Frame) this;
	}

	/**
	 * Receive a change notice from an object of whom the receiver is a dependent.
	 * The argument anAspectSymbol is typically a Symbol that indicates what change has occurred.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		// nothing to do
	}

	/**
	 * Update the window title.
	 * 
	 * @return boolean
	 * @see jp.co.sra.smalltalk.StApplicationWindow#updateWindowTitle()
	 * @category updating
	 */
	public boolean updateWindowTitle() {
		if (this.application() == null) {
			return false;
		}
		String windowTitle = this.application().windowTitle();
		if (windowTitle == null) {
			return false;
		}

		this.setTitle(windowTitle);
		return true;
	}

	/**
	 * Update the menu bar.
	 * 
	 * @return boolean
	 * @see jp.co.sra.smalltalk.StApplicationWindow#updateMenuBar()
	 * @category updating
	 */
	public boolean updateMenuBar() {
		if (this.application() == null) {
			return false;
		}
		StMenuBar menuBar = this.application()._menuBar();
		if (menuBar == null) {
			return false;
		}

		this.menuBarView_((StMenuBarViewAwt) this.view()._createMenuBarView(menuBar));
		return true;
	}

	/**
	 * Build the window.
	 * 
	 * @category private
	 */
	protected void buildWindow() {
		if (this.application() == null) {
			return;
		}
		if (this.view() == null) {
			return;
		}

		this.updateWindowTitle();
		this.updateMenuBar();

		// A workaround for a problem with Java2 SDK 1.3.1 & 1.4.1 on Linux.
		// If a window contains a TextField, the window is tried to doLayout() with its size (0, 0)
		// when the peer of the TextField is created and addNotify() of the TextField is called.
		// As a result, the content of the window will be resized to be fit on a window which size is (0, 0).
		/*
		 Insets insets = this.getInsets();
		 Dimension size = this.view().toComponent().getSize();
		 this.setSize(size.width + insets.left + insets.right, size.height + insets.top + insets.bottom);
		 */

		Component aComponent = this.view().toComponent();
		if (this.application()._viewOnBorderedPanel()) {
			Panel aPanel = _PanelWithBorder();
			aPanel.setLayout(new BorderLayout());
			aPanel.add(aComponent, BorderLayout.CENTER);
			aComponent = aPanel;
		}
		this.add(aComponent);
		this.pack();

		// Set the window size.
		Insets insets = this.getInsets();
		Dimension size = this.view().toComponent().getSize();
		this.setSize(size.width + insets.left + insets.right, size.height + insets.top + insets.bottom);

		if (this.application().windowResizable() == false) {
			this.setResizable(false);
		}
	}

	/**
	 * Create a panel with border.
	 * 
	 * @return java.awt.Panel
	 * @category Utilities
	 */
	public static Panel _PanelWithBorder() {
		Panel aPanel = new Panel() {
			public Insets getInsets() {
				return new Insets(2, 2, 2, 2);
			}

			public void paint(Graphics graphics) {
				super.paint(graphics);

				Dimension size = this.getSize();

				// Black lines
				graphics.setColor(Color.black);
				graphics.drawLine(1, 1, size.width - 3, 1);
				graphics.drawLine(1, 1, 1, size.height - 3);

				// Gray lines.
				graphics.setColor(Color.gray);
				graphics.drawLine(0, 0, size.width - 2, 0);
				graphics.drawLine(0, 0, 0, size.height - 2);

				// Light gray lines.
				graphics.setColor(Color.lightGray);
				graphics.drawLine(1, size.height - 2, size.width - 2, size.height - 2);
				graphics.drawLine(size.width - 2, 1, size.width - 2, size.height - 2);

				// White lines.
				graphics.setColor(Color.white);
				graphics.drawLine(0, size.height - 1, size.width - 1, size.height - 1);
				graphics.drawLine(size.width - 1, 0, size.width - 1, size.height - 1);
			}
		};

		return aPanel;
	}

}
