package jp.co.sra.smalltalk;

/**
 * SmalltalkException class
 * 
 *  @author    nisinaka
 *  @created   1998/10/01 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: SmalltalkException.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class SmalltalkException extends RuntimeException {

	/**
	 * Constructs a <code>SmalltalkException</code> with no detail message.
	 * 
	 * @category Instance creation
	 */
	public SmalltalkException() {
		super();
		this.printStackTrace();
	}

	/**
	 * Constructs a <code>SmalltalkException</code> with the specified detail
	 * message.
	 * 
	 * @param e java.lang.String
	 * @category Instance creation
	 */
	public SmalltalkException(Exception e) {
		super();
		e.printStackTrace();
	}

	/**
	 * Constructs a <code>SmalltalkException</code> with the specified detail
	 * message.
	 * 
	 * @param s java.lang.String
	 * @category Instance creation
	 */
	public SmalltalkException(String s) {
		super(s);
		this.printStackTrace();
	}

	/**
	 * Constructs a <code>SmalltalkException</code> for Error.
	 * 
	 * @param aString java.lang.String
	 * @return jp.co.sra.smalltalk.SmalltalkException
	 * @category Instance creation
	 */
	public static SmalltalkException Error(String aString) {
		return new SmalltalkException("Error: " + aString);
	}

	/**
	 * Constructs a <code>SmalltalkException</code> for Halt.
	 * 
	 * @param aString java.lang.String
	 * @return jp.co.sra.smalltalk.SmalltalkException
	 * @category Instance creation
	 */
	public static SmalltalkException Halt(String aString) {
		return new SmalltalkException("Halt: " + aString);
	}

	/**
	 * Constructs a <code>SmalltalkException</code> for MessageNotUnderstood.
	 * 
	 * @param info java.lang.String
	 * @return jp.co.sra.smalltalk.SmalltalkException
	 * @category Instance creation
	 */
	public static SmalltalkException MessageNotUnderstood(String info) {
		return new SmalltalkException("message not understood - " + info);
	}

	/**
	 * Constructs a <code>SmalltalkException</code> for ShouldNotImplement.
	 * 
	 * @return jp.co.sra.smalltalk.SmalltalkException
	 * @category Instance creation
	 */
	public static SmalltalkException ShouldNotImplement() {
		return Error("This message is not appropriate for this object");
	}

	/**
	 * Constructs a <code>SmalltalkException</code> for SubclassResponsibility.
	 * 
	 * @return jp.co.sra.smalltalk.SmalltalkException
	 * @category Instance creation
	 */
	public static SmalltalkException SubclassResponsibility() {
		return new SmalltalkException("subclass responsibility");
	}

	/**
	 * Constructs a <code>SmalltalkException</code> for SubclassResponsibility.
	 * 
	 * @param info java.lang.String
	 * @return jp.co.sra.smalltalk.SmalltalkException
	 * @category Instance creation
	 */
	public static SmalltalkException SubclassResponsibility(String info) {
		return new SmalltalkException("subclass responsibility - " + info);
	}
}
