package jp.co.sra.qt4jun;

import java.awt.Rectangle;

/**
 * JunQTNativeMovieWithMovieController class
 * 
 *  @author    Hoshi Takanori
 *  @created   2005/01/20 (by Hoshi Takanori)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunQTNativeMovieWithMovieController.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunQTNativeMovieWithMovieController extends JunQTNativeMovie {
	protected int movieController;

	/**
	 * constructor.
	 *
	 * @param movie int
	 * @category Instance creation
	 */
	public JunQTNativeMovieWithMovieController(int movie) {
		super(movie);
	}

	/**
	 * release the movie controller.
	 *
	 * @category initialize-release
	 */
	public void release() {
		if (movieController != 0) {
			this._interface().qtDisposeMovieController(movieController);
			movieController = 0;
		}

		super.release();
	}

	/**
	 * has the movie controller or not?
	 *
	 * @return boolean
	 * @category testing
	 */
	public boolean hasMovieController() {
		if (movieController == 0) {
			this.recoverMovieController();
		}

		return movieController != 0;
	}

	/**
	 * start the movie.
	 *
	 * @category playing
	 */
	public void start() {
		if (this.hasMovieController()) {
			this.movieChanged();
			this._interface().qtMCDoAction(movieController,
					this._interface().mcActionPrerollAndPlay,
					this._interface().fixed1);
		}
	}

	/**
	 * do movie task.
	 *
	 * @category playing
	 */
	public void task() {
		if (this.hasMovieController()) {
			this._interface().qtMCIdle(movieController);
		}
	}

	/**
	 * the movie has changed.
	 *
	 * @category private
	 */
	public void movieChanged() {
		if (this.hasMovieController()) {
			this._interface().qtMCMovieChanged(movieController, movie);
			this.task();
		}
	}

	/**
	 * recover the movie controller.
	 *
	 * @category private
	 */
	protected void recoverMovieController() {
		Rectangle box = this.getBox();
		movieController = this._interface().qtNewMovieController(
				movie, box.x, box.y, box.width, box.height,
				this._interface().mcTopLeftMovie + this._interface().mcNotVisible);
	}
}
