package jp.co.sra.qt4jun;

import java.awt.Component;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunQTMovieFactory class
 * 
 *  @author    Hoshi Takanori
 *  @created   2005/01/19 (by Hoshi Takanori)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunQTMovieFactory.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunQTMovieFactory {
	private static boolean UseJunQTNativeMovie = true;

	static {
		if (JunSystem.IsMacOSX()) {
			UseJunQTNativeMovie = false;
		}

		if (System.getProperty("UseJunQTNativeMovie") != null) {
			UseJunQTNativeMovie = Boolean.getBoolean("UseJunQTNativeMovie");
		}

		// initialize the movie class.
		canGetMovieFile();
	}

	/**
	 * answer true if getMovieFile() works.
	 *
	 * @return boolean
	 * @category Instance creation
	 */
	public static boolean canGetMovieFile() {
		if (UseJunQTNativeMovie) {
			return JunQTNativeMovie.canGetMovieFile();
		} else {
			try {
				Class cls = Class.forName("jp.co.sra.qt4jun.JunQTJMovie");
				Method method = cls.getDeclaredMethod("canGetMovieFile", (Class[]) null);
				return ((Boolean) method.invoke(null, (Object[]) null)).booleanValue();
			} catch (Exception e) {
				throw new Error(e.getMessage());
			}
		}
	}

	/**
	 * open the standard file preview dialog and get the movie filename.
	 *
	 * @return java.lang.String
	 * @category Instance creation
	 */
	public static String getMovieFile() {
		if (UseJunQTNativeMovie) {
			return JunQTNativeMovie.getMovieFile();
		} else {
			try {
				Class cls = Class.forName("jp.co.sra.qt4jun.JunQTJMovie");
				Method method = cls.getDeclaredMethod("getMovieFile", (Class[]) null);
				return (String) method.invoke(null, (Object[]) null);
			} catch (Exception e) {
				throw new Error(e.getMessage());
			}
		}
	}

	/**
	 * open the movie.
	 *
	 * @param filename java.io.File
	 * @return jp.co.sra.qt4jun.JunQTMovie
	 * @category Instance creation
	 */
	public static JunQTMovie openMovie(File filename) {
		return openMovie(filename.getPath());
	}

	/**
	 * open the movie.
	 *
	 * @param filename java.lang.String
	 * @return jp.co.sra.qt4jun.JunQTMovie
	 * @category Instance creation
	 */
	public static JunQTMovie openMovie(String filename) {
		if (UseJunQTNativeMovie) {
			return JunQTNativeMovie.openMovie(filename);
		} else {
			try {
				Class cls = Class.forName("jp.co.sra.qt4jun.JunQTJMovie");
				Class[] paramTypes = { String.class };
				Method method = cls.getDeclaredMethod("openMovie", paramTypes);
				Object[] params = { filename };
				return (JunQTMovie) method.invoke(null, params);
			} catch (Exception e) {
				throw new Error(e.getMessage());
			}
		}
	}

	/**
	 * create the movie port.
	 *
	 * @param mv java.awt.Component
	 * @return jp.co.sra.qt4jun.JunQTPort
	 * @category Instance creation
	 */
	public static JunQTPort createPort(Component mv) {
		if (UseJunQTNativeMovie) {
			return new JunQTNativePort(mv);
		} else {
			try {
				Class cls = Class.forName("jp.co.sra.qt4jun.JunQTJPort");
				Class[] paramTypes = { Component.class };
				Constructor ctor = cls.getConstructor(paramTypes);
				Object[] params = { mv };
				return (JunQTPort) ctor.newInstance(params);
			} catch (Exception e) {
				throw new Error(e.getMessage());
			}
		}
	}

	/**
	 * answer true if the movie port creates a component.
	 *
	 * @return boolean
	 * @category Instance creation
	 */
	public static boolean portCreatesComponent() {
		if (UseJunQTNativeMovie) {
			return false;
		} else {
			return true;
		}
	}
}
