package jp.co.sra.jun.vrml.support;

import java.util.Hashtable;

import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode;

/**
 * JunVrmlSyntaxTreeBuilder class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/24 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlSyntaxTreeBuilder.java,v 8.11 2008/02/20 06:33:17 nisinaka Exp $
 */
public abstract class JunVrmlSyntaxTreeBuilder extends JunAbstractObject {

	/**
	 * Create a new VRML node.
	 * 
	 * @param aSymbol jp.co.sra.smalltalk.StSymbol
	 * @param anObject java.lang.Object
	 * 
	 * @return jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode
	 */
	public JunVrmlNode newNode_with_(final StSymbol aSymbol, Object anObject) {
		return this.newNode_with_ifFailed_(aSymbol, anObject, new StBlockClosure() {
			public Object value() {
				throw SmalltalkException.Error("Unknown node - " + aSymbol.toString());
			}
		});
	}

	/**
	 * Create a new VRML node.
	 * 
	 * @param aSymbol jp.co.sra.smalltalk.StSymbol
	 * @param anObject java.lang.Object
	 * @param failBlock jp.co.sra.smalltalk.StBlockClosure
	 * 
	 * @return jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode
	 */
	public JunVrmlNode newNode_with_ifFailed_(StSymbol aSymbol, Object anObject, StBlockClosure failBlock) {
		Class aNodeClass = (Class) this.nodeTypeTable().get(aSymbol);

		if (aNodeClass == null) {
			return (JunVrmlNode) failBlock.value();
		}

		return (JunVrmlNode) _New(aNodeClass, anObject);
	}

	/**
	 * Answer a node type table.
	 * 
	 * @return java.util.Hashtable
	 */
	public abstract Hashtable nodeTypeTable();
}
