package jp.co.sra.jun.vrml.support;

/**
 * JunVrmlScannerTable10 class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   1999/06/22 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlScannerTable10.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlScannerTable10 extends JunVrmlScannerTable {
	/** The scanner table for VRML1.0. */
	protected static JunVrmlScannerTable scanningTable = null;

	//
	static {
		Initialize();
	}

	/**
	 * Create a new instance of JunVrmlScannerTable10.
	 * 
	 * @param nSize int
	 */
	public JunVrmlScannerTable10(int nSize) {
		super(nSize);
	}

	/**
	 * Initialize the scanner table.
	 */
	public static void Initialize() {
		JunVrmlScannerTable10 newTable = new JunVrmlScannerTable10(256);

		for (int i = 0; i < 256; i++) {
			newTable.put(i, $("xBinary"));
		}

		newTable.put(9, $("xDelimiter"));
		newTable.put(10, $("xDelimiter"));
		newTable.put(13, $("xDelimiter"));
		newTable.put(32, $("xDelimiter"));

		for (int i = '0'; i <= '9'; i++) {
			newTable.put(i, $("xDigit"));
		}

		for (int i = 'a'; i <= 'z'; i++) {
			newTable.put(i, $("xSymbol"));
		}

		for (int i = 'A'; i <= 'Z'; i++) {
			newTable.put(i, $("xSymbol"));
		}

		for (int i = 128; i < 256; i++) {
			newTable.put(i, $("xSymbol"));
		}

		newTable.put('\'', $("quote"));
		newTable.put('"', $("xDoubleQuote"));
		newTable.put('#', $("xComment"));
		newTable.put('[', $("leftBracket"));
		newTable.put(']', $("rightBracket"));
		newTable.put('{', $("leftBrace"));
		newTable.put('}', $("rightBrace"));
		newTable.put('+', $("xSign"));
		newTable.put('-', $("xSign"));
		newTable.put('<', $("xSymbol"));
		newTable.put('>', $("xSymbol"));
		newTable.put('=', $("xSymbol"));
		newTable.put('~', $("xSymbol"));
		newTable.put('*', $("xSymbol"));
		newTable.put('/', $("xSymbol"));
		newTable.put('_', $("xSymbol"));
		newTable.put(':', $("xSymbol"));
		newTable.put('%', $("xSymbol"));
		newTable.put('(', $("xSymbol"));
		newTable.put(')', $("xSymbol"));
		newTable.put('!', $("xSymbol"));
		newTable.put(',', $("comma"));
		newTable.put('.', $("period"));
		newTable.put('`', $("quote"));
		newTable.put(EndChar, $("eof"));
		scanningTable = newTable;
	}

	/**
	 * Answer the scanner table.
	 * 
	 * @return jp.co.sra.jun.vrml.support.JunVrmlScannerTable
	 */
	public static JunVrmlScannerTable ScannerTable() {
		return scanningTable;
	}
}
