package jp.co.sra.jun.vrml.support;

import jp.co.sra.smalltalk.*;

/**
 * JunVrmlScannerTable class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   1999/06/22 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlScannerTable.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlScannerTable extends StObject {
	/** The character to specify the end of the source. */
	protected static final char EndChar = 0;

	/** The scanner table. */
	protected Object[] table = null;

	/**
	 * Create a new instance of JunVrmlScannerTable.
	 */
	public JunVrmlScannerTable() {
		this(0);
	}

	/**
	 * Create a new instance of JunVrmlScannerTable.
	 * 
	 * @param nSize int
	 */
	public JunVrmlScannerTable(int nSize) {
		table = new Object[nSize];
	}

	/**
	 * Answer the scanner table.
	 * 
	 * @return jp.co.sra.jun.vrml.support.JunVrmlScannerTable
	 */
	public static JunVrmlScannerTable ScannerTable() {
		return null;
	}

	/**
	 * Answer the object at the specified place.
	 * 
	 * @param index int
	 * 
	 * @return java.lang.Object
	 */
	public Object at(int index) {
		if ((256 <= index) && (index <= 65535)) {
			if ((index >= 'a' && index <= 'z') || (index >= 'A' && index <= 'Z')) {
				return $("xSymbol");
			} else {
				return $("xBinary");
			}
		} else {
			return table[index];
		}
	}

	/**
	 * Put the object at the specified place. This is a replacement of the
	 * smalltalk method 'at:put:'.
	 * 
	 * @param index int
	 * @param anObject java.lang.Object
	 */
	public void put(int index, Object anObject) {
		table[index] = anObject;
	}

	/**
	 * Answer the source end charcter.
	 * 
	 * @return char
	 */
	protected char endChar() {
		return EndChar;
	}
}
