package jp.co.sra.jun.vrml.support;

import java.awt.Color;
import java.lang.String;
import jp.co.sra.smalltalk.*;
import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.geometry.curves.JunNurbsCurve;
import jp.co.sra.jun.geometry.surfaces.JunNurbsSurface;
import jp.co.sra.jun.opengl.objects.*;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;

/**
 * JunVrmlRenderingContext class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/01/12 (by MATSUDA Ryouichi)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlRenderingContext.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlRenderingContext extends StObject {
	public static StSymbol VERSION10 = $("vrml10");
	public static StSymbol VERSION20 = $("vrml20");

	/** The vrmlVersion of the object. */
	protected StSymbol vrmlVersion;

	/** The alpha of the object. */
	protected JunOpenGL3dCompoundObject vrmlObject;

	/** The presentation of the object. */
	protected StSymbol presentation;

	/** The projection of the object. */
	protected JunOpenGLProjection projection;

	/**
	 * Constainer.
	 */
	public JunVrmlRenderingContext() {
		vrmlObject = new JunOpenGL3dCompoundObject();
		this.setVrml20();
		this.solidPresentation();
	}

	/**
	 * Answer the alpha.
	 * 
	 * @return float
	 */
	public final float alpha() {
		return vrmlObject.alpha();
	}

	/**
	 * Set the aplha.
	 * 
	 * @param aNumber
	 */
	public final void alpha_(float aNumber) {
		vrmlObject.alpha_(aNumber);
	}

	/**
	 * Write a line to the vrmlRenderingContext.
	 * 
	 * @param aCollectionOfPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 */
	public void displayLine_(Jun3dPoint[] aCollectionOfPoints) {
		if (aCollectionOfPoints.length <= 2) {
			vrmlObject.add_(new JunOpenGL3dPolyline(aCollectionOfPoints));
		} else {
			Jun3dPoint[] firstLast = { aCollectionOfPoints[0], aCollectionOfPoints[aCollectionOfPoints.length] };
			vrmlObject.add_(new JunOpenGL3dPolyline(firstLast));
		}
	}

	/**
	 * Write a line loop to the vrmlRenderingContext.
	 * 
	 * @param aCollectionOfPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 */
	public void displayLineLoop_(Jun3dPoint[] aCollectionOfPoints) {
		vrmlObject.add_(new JunOpenGL3dPolylineLoop(aCollectionOfPoints));
	}

	/**
	 * Write lines to the vrmlRenderingContext.
	 * 
	 * @param aCollectionOfPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 */
	public void displayLines_(Jun3dPoint[] aCollectionOfPoints) {
		vrmlObject.add_(new JunOpenGL3dPolyline(aCollectionOfPoints));
	}

	/**
	 * Write a NurbsCurve to the vrmlRenderingContext.
	 * 
	 * @param aNurbsCurve jp.co.sra.jun.geometry.curves.JunNurbsCurve
	 */
	public void displayNurbsCurve_(JunNurbsCurve aNurbsCurve) {
		vrmlObject.add_(new JunOpenGL3dNurbsCurve(aNurbsCurve.controlPoints(), aNurbsCurve.weights(), aNurbsCurve.knotVector()));
	}

	/**
	 * Write a NurbsSurface to the vrmlRenderingContext.
	 * 
	 * @param aNurbsSurface jp.co.sra.jun.geometry.surfaces.JunNurbsSurface
	 */
	public void displayNurbsSurface_(JunNurbsSurface aNurbsSurface) {
		vrmlObject.add_(new JunOpenGL3dNurbsSurface(aNurbsSurface.controlPoints(), aNurbsSurface.weights(), aNurbsSurface.uKnotVector(), aNurbsSurface.vKnotVector()));
	}

	/**
	 * Write a 3dObject to the vrmlRenderingContext.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public void displayObject_(JunOpenGL3dObject a3dObject) {
		vrmlObject.add_(a3dObject);
	}

	/**
	 * Write a 3dPoint to the vrmlRenderingContext.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public void displayPoint_(Jun3dPoint a3dPoint) {
		vrmlObject.add_(JunOpenGL3dVertex.Point_(a3dPoint));
	}

	/**
	 * Write a polygon to the vrmlRenderingContext.
	 * 
	 * @param aCollectionOfPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 */
	public void displayPolygon_(Jun3dPoint[] aCollectionOfPoints) {
		vrmlObject.add_(new JunOpenGL3dPolygon(aCollectionOfPoints));
	}

	/**
	 * Answer the paint.
	 * 
	 * @return java.awt.Color
	 */
	public final Color paint() {
		return vrmlObject.paint();
	}

	/**
	 * Set the paint.
	 * 
	 * @param aPaint java.awt.Color
	 */
	public final void paint_(Color aPaint) {
		vrmlObject.paint_(aPaint);
	}

	/**
	 * Answer a Symbol of presentation.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 */
	public StSymbol presentation() {
		// presentation := #solid | #wireframe
		if (presentation == null) {
			presentation = $("solid");
		}

		return presentation;
	}

	/**
	 * Set a Symbol of presentation.
	 * 
	 * @param aSymbol jp.co.sra.smalltalk.StSymbol
	 */
	public void presentation_(StSymbol aSymbol) {
		// presentation := #solid | #wireframe
		if ((aSymbol == $("solid")) || (aSymbol == $("wireframe"))) {
			presentation = aSymbol;
		}
	}

	/**
	 * Answer the projection.
	 * 
	 * @return jp.co.sra.jun.opengl.projection.JunOpenGLProjection
	 */
	public JunOpenGLProjection projection() {
		return projection;
	}

	/**
	 * Set the projection.
	 * 
	 * @param aProjection jp.co.sra.jun.opengl.projection.JunOpenGLProjection
	 */
	public void projection_(JunOpenGLProjection aProjection) {
		projection = aProjection;
	}

	/**
	 * Set vrml10 mode.
	 */
	public void setVrml10() {
		vrmlVersion = VERSION10;
	}

	/**
	 * Set vrml20 mode.
	 */
	public void setVrml20() {
		vrmlVersion = VERSION20;
	}

	/**
	 * Set solidPresentation.
	 */
	public void solidPresentation() {
		this.presentation_($("solid"));
	}

	/**
	 * Answer a vrml10 string.
	 * 
	 * @return java.lang.String
	 */
	public String vrml10String() {
		return vrmlObject.vrml10String();
	}

	/**
	 * Answer a vrml20 string.
	 * 
	 * @return java.lang.String
	 */
	public String vrml20String() {
		return vrmlObject.vrml20String();
	}

	/**
	 * Answer a vrml string.
	 * 
	 * @return java.lang.String
	 */
	public String vrmlString() {
		if (vrmlVersion == VERSION10) {
			return this.vrml10String();
		}

		if (vrmlVersion == VERSION20) {
			return this.vrml20String();
		}

		return null;
	}

	/**
	 * Answer the vrmlVersion.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 */
	public final StSymbol vrmlVersion() {
		return vrmlVersion;
	}

	/**
	 * Set wireframePresentation.
	 */
	public void wireframePresentation() {
		this.presentation_($("wireframe"));
	}
}
