package jp.co.sra.jun.vrml.node.property20;

import java.util.Hashtable;

import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.field.mf.JunVrmlMFStringField;
import jp.co.sra.jun.vrml.field.sf.*;
import jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode;

/**
 * JunVrmlFontStyleNode20 class
 * 
 *  @author    nisinaka
 *  @created   2003/09/30 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlFontStyleNode20.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlFontStyleNode20 extends JunVrmlAbstractPropertyNode {

	protected JunVrmlMFStringField familyField;
	protected JunVrmlSFBoolField horizontalField;
	protected JunVrmlMFStringField justifyField;
	protected JunVrmlSFStringField languageField;
	protected JunVrmlSFBoolField leftToRightField;
	protected JunVrmlSFFloatField sizeField;
	protected JunVrmlSFFloatField spacingField;
	protected JunVrmlSFStringField styleField;
	protected JunVrmlSFBoolField topToBottomField;

	/**
	 * The default constructor.
	 * 
	 * @category Instance creation
	 */
	public JunVrmlFontStyleNode20() {
	}

	/**
	 * Create a new instance of JunVrmlFontStyleNode20 and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 * @category Instance creation
	 */
	public JunVrmlFontStyleNode20(Hashtable aDictionary) {
		if (aDictionary.containsKey($("family"))) {
			familyField = new JunVrmlMFStringField(aDictionary.get($("family")));
		}

		if (aDictionary.containsKey($("horizontal"))) {
			horizontalField = new JunVrmlSFBoolField(aDictionary.get($("horizontal")));
		}

		if (aDictionary.containsKey($("justify"))) {
			justifyField = new JunVrmlMFStringField(aDictionary.get($("justify")));
		}

		if (aDictionary.containsKey($("language"))) {
			languageField = new JunVrmlSFStringField(aDictionary.get($("language")));
		}

		if (aDictionary.containsKey($("leftToRight"))) {
			leftToRightField = new JunVrmlSFBoolField(aDictionary.get($("leftToRight")));
		}

		if (aDictionary.containsKey($("size"))) {
			sizeField = new JunVrmlSFFloatField(aDictionary.get($("size")));
		}

		if (aDictionary.containsKey($("spacing"))) {
			spacingField = new JunVrmlSFFloatField(aDictionary.get($("spacing")));
		}

		if (aDictionary.containsKey($("style"))) {
			styleField = new JunVrmlSFStringField(aDictionary.get($("style")));
		}

		if (aDictionary.containsKey($("topToBottom"))) {
			topToBottomField = new JunVrmlSFBoolField(aDictionary.get($("topToBottom")));
		}
	}

	/**
	 * Answer the default value of family field.
	 * 
	 * @return java.lang.String
	 * @category Defaults
	 */
	public static final String[] DefaultFamily() {
		return new String[] { "SERIF" };
	}

	/**
	 * Answer the default value of horizontal field.
	 * 
	 * @return boolean
	 * @category Defaults
	 */
	public static final boolean DefaultHorizontal() {
		return true;
	}

	/**
	 * Answer the default value of justify field.
	 * 
	 * @return java.lang.String
	 * @category Defaults
	 */
	public static final String[] DefaultJustify() {
		return new String[] { "BEGIN" };
	}

	/**
	 * Answer the default value of language field.
	 * 
	 * @return java.lang.String
	 * @category Defaults
	 */
	public static final String DefaultLanguage() {
		return "";
	}

	/**
	 * Answer the default value of leftToRight field.
	 * 
	 * @return boolean
	 * @category Defaults
	 */
	public static final boolean DefaultLeftToRight() {
		return true;
	}

	/**
	 * Answer the default value of size field.
	 * 
	 * @return float
	 * @category Defaults
	 */
	public static final float DefaultSize() {
		return 1.0f;
	}

	/**
	 * Answer the default value of spacing field.
	 * 
	 * @return float
	 * @category Defaults
	 */
	public static final float DefaultSpacing() {
		return 1.0f;
	}

	/**
	 * Answer the default value of style field.
	 * 
	 * @return java.lang.String
	 * @category Defaults
	 */
	public static final String DefaultStyle() {
		return "PLAIN";
	}

	/**
	 * Answer the default value of topToBottom field.
	 * 
	 * @return boolean
	 * @category Defaults
	 */
	public static final boolean DefaultTopToBottom() {
		return true;
	}

	/**
	 * Answer the value of the family field.
	 * 
	 * @return java.lang.String[]
	 * @category accessing
	 */
	public String[] family() {
		return this.familyField().value();
	}

	/**
	 * Answer the family field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFStringField
	 * @category accessing
	 */
	protected JunVrmlMFStringField familyField() {
		if (familyField == null) {
			familyField = new JunVrmlMFStringField(DefaultFamily());
		}
		return familyField;
	}

	/**
	 * Answer the value of the horizontal field.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean horizontal() {
		return this.horizontalField().value();
	}

	/**
	 * Answer the horzontal field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 * @category accessing
	 */
	protected JunVrmlSFBoolField horizontalField() {
		if (horizontalField == null) {
			horizontalField = new JunVrmlSFBoolField(DefaultHorizontal());
		}
		return horizontalField;
	}

	/**
	 * Answer the value of the justify field.
	 * 
	 * @return java.lang.String[]
	 * @category accessing
	 */
	public String[] justify() {
		return this.justifyField().value();
	}

	/**
	 * Answer the justify field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFStringField
	 * @category accessing
	 */
	protected JunVrmlMFStringField justifyField() {
		if (justifyField == null) {
			justifyField = new JunVrmlMFStringField(DefaultJustify());
		}
		return justifyField;
	}

	/**
	 * Answer the value of the language field.
	 * 
	 * @return java.lang.String[]
	 * @category accessing
	 */
	public String language() {
		return this.languageField().value();
	}

	/**
	 * Answer the language field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFStringField
	 * @category accessing
	 */
	protected JunVrmlSFStringField languageField() {
		if (languageField == null) {
			languageField = new JunVrmlSFStringField(DefaultLanguage());
		}
		return languageField;
	}

	/**
	 * Answer the value of the leftToRight field.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean leftToRight() {
		return this.leftToRightField().value();
	}

	/**
	 * Answer the leftToRight field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 * @category accessing
	 */
	protected JunVrmlSFBoolField leftToRightField() {
		if (leftToRightField == null) {
			leftToRightField = new JunVrmlSFBoolField(DefaultLeftToRight());
		}
		return leftToRightField;
	}

	/**
	 * Answer the value of the size field.
	 * 
	 * @return float
	 * @category accessing
	 */
	public float size() {
		return this.sizeField().value();
	}

	/**
	 * Answer the size field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 * @category accessing
	 */
	protected JunVrmlSFFloatField sizeField() {
		if (sizeField == null) {
			sizeField = new JunVrmlSFFloatField(DefaultSize());
		}
		return sizeField;
	}

	/**
	 * Answer the value of the spacing field.
	 * 
	 * @return float
	 * @category accessing
	 */
	public float spacing() {
		return this.spacingField().value();
	}

	/**
	 * Answer the spacing field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 * @category accessing
	 */
	protected JunVrmlSFFloatField spacingField() {
		if (spacingField == null) {
			spacingField = new JunVrmlSFFloatField(DefaultSpacing());
		}
		return spacingField;
	}

	/**
	 * Answer the value of the style field.
	 * 
	 * @return java.lang.String[]
	 * @category accessing
	 */
	public String style() {
		return this.styleField().value();
	}

	/**
	 * Answer the style field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFStringField
	 * @category accessing
	 */
	protected JunVrmlSFStringField styleField() {
		if (styleField == null) {
			styleField = new JunVrmlSFStringField(DefaultStyle());
		}
		return styleField;
	}

	/**
	 * Answer the value of the topToBottom field.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean topToBottom() {
		return this.topToBottomField().value();
	}

	/**
	 * Answer the topToBottom field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 * @category accessing
	 */
	protected JunVrmlSFBoolField topToBottomField() {
		if (topToBottomField == null) {
			topToBottomField = new JunVrmlSFBoolField(DefaultTopToBottom());
		}
		return topToBottomField;
	}

	/**
	 * Set my properties on the JunOpenGL3dObject.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @see jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode#propertyOn_(jp.co.sra.jun.opengl.objects.JunOpenGL3dObject)
	 * @category code generation
	 */
	public void propertyOn_(JunOpenGL3dObject a3dObject) {
		// Does not support now.
	}

}
