package jp.co.sra.jun.vrml.node.property10;

import java.util.Hashtable;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.field.mf.JunVrmlMFVec3fField;
import jp.co.sra.jun.vrml.support.*;

/**
 * JunVrmlCoordinate3Node class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/04/14 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlCoordinate3Node.java,v 8.10 2008/02/20 06:33:16 nisinaka Exp $
 */
public class JunVrmlCoordinate3Node extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode {
	protected JunVrmlMFVec3fField pointField;

	/**
	 * Create a new instance of JunVrmlCoordinate3Node and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlCoordinate3Node(Hashtable aDictionary) {
		if (aDictionary.containsKey($("point"))) {
			pointField = new JunVrmlMFVec3fField(aDictionary.get($("point")));
		}
	}

	/**
	 * Answer the default value of point.
	 * 
	 * @return java.lang.Integer[]
	 */
	public static final float[] DefaultPoint() {
		return new float[] { 0, 0, 0 };
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doCoordinate3_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Answer the point.
	 * 
	 * @return float[]
	 */
	public float[] point() {
		return this.pointField().value();
	}

	/**
	 * Answer the points as an array of Jun3dPoint.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 */
	public Jun3dPoint[] pointAs3dPoints() {
		return this.pointField.as3dPoints();
	}

	/**
	 * Set my properties on the JunOpenGL3dObject.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public void propertyOn_(JunOpenGL3dObject a3dObject) {
	}

	/**
	 * Answer the point field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFVec3fField
	 */
	protected JunVrmlMFVec3fField pointField() {
		if (pointField == null) {
			pointField = new JunVrmlMFVec3fField(DefaultPoint());
		}

		return pointField;
	}
}
