package jp.co.sra.jun.vrml.node.grouping20;

import java.util.*;
import jp.co.sra.jun.vrml.field.sf.JunVrmlSFVec3fField;
import jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlGroupNode class
 * 
 *  @author    nisinaka
 *  @created   2000/04/17 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlGroupNode.java,v 8.10 2008/02/20 06:33:16 nisinaka Exp $
 */
public class JunVrmlGroupNode extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractGroupingNode {
	protected JunVrmlNode[] children;
	protected JunVrmlSFVec3fField bboxCenterField;
	protected JunVrmlSFVec3fField bboxSizeField;

	/**
	 * Create a new instance of JunVrmlGroupNode and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlGroupNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("children"))) {
			this.children_(aDictionary.get($("children")));
		}

		if (aDictionary.containsKey($("bboxCenter"))) {
			bboxCenterField = new JunVrmlSFVec3fField(aDictionary.get($("bboxCenter")));
		}

		if (aDictionary.containsKey($("bboxSize"))) {
			bboxSizeField = new JunVrmlSFVec3fField(aDictionary.get($("bboxSize")));
		}
	}

	/**
	 * Answer the default value of bboxCenter.
	 * 
	 * @return java.lang.Integer[]
	 */
	public static final float[] DefaultBboxCenter() {
		return new float[] { 0, 0, 0 };
	}

	/**
	 * Answer the default value of bboxSize.
	 * 
	 * @return java.lang.Integer[]
	 */
	public static final float[] DefaultBboxSize() {
		return new float[] { -1, -1, -1 };
	}

	/**
	 * Answer the bboxCenter.
	 * 
	 * @return float[]
	 */
	public float[] bboxCenter() {
		return this.bboxCenterField().value();
	}

	/**
	 * Answer the bboxSize.
	 * 
	 * @return float[]
	 */
	public float[] bboxSize() {
		return this.bboxSizeField().value();
	}

	/**
	 * Answer the children.
	 * 
	 * @return jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode[]
	 */
	public JunVrmlNode[] children() {
		return children;
	}

	/**
	 * Set the children nodes.
	 * 
	 * @param aNode java.lang.Object
	 * 
	 * @throws jp.co.sra.smalltalk.SmalltalkException DOCUMENT ME!
	 */
	public void children_(Object aNode) {
		if (aNode instanceof JunVrmlNode) {
			children = new JunVrmlNode[] {(JunVrmlNode) aNode };
		} else if (aNode instanceof Vector) {
			Vector collection = (Vector) aNode;
			children = new JunVrmlNode[collection.size()];
			collection.copyInto(children);
		} else {
			throw new jp.co.sra.smalltalk.SmalltalkException();
		}
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doGroup_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Answer the bboxCenter field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFVec3fField
	 */
	protected JunVrmlSFVec3fField bboxCenterField() {
		if (bboxCenterField == null) {
			bboxCenterField = new JunVrmlSFVec3fField(DefaultBboxCenter());
		}

		return bboxCenterField;
	}

	/**
	 * Answer the bboxSize field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFVec3fField
	 */
	protected JunVrmlSFVec3fField bboxSizeField() {
		if (bboxSizeField == null) {
			bboxSizeField = new JunVrmlSFVec3fField(DefaultBboxSize());
		}

		return bboxSizeField;
	}
}
