package jp.co.sra.jun.vrml.node.geometry;

import java.util.Hashtable;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dSphere;
import jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField;

/**
 * JunVrmlSphereNode class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlSphereNode.java,v 8.10 2008/02/20 06:33:15 nisinaka Exp $
 */
public class JunVrmlSphereNode extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractGeometryNode {
	protected JunVrmlSFFloatField radiusField;

	/**
	 * Create a new instance of JunVrmlSphereNode and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlSphereNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("radius"))) {
			radiusField = new JunVrmlSFFloatField(aDictionary.get($("radius")));
		}
	}

	/**
	 * Answer the default value of radius.
	 * 
	 * @return float
	 */
	public static final float DefaultRadius() {
		return 1;
	}

	/**
	 * Convert to a JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		return new JunOpenGL3dSphere(this.radius());
	}

	/**
	 * Answer the radius.
	 * 
	 * @return float
	 */
	public float radius() {
		return this.radiusField().value();
	}

	/**
	 * Answer the radius.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 */
	protected JunVrmlSFFloatField radiusField() {
		if (radiusField == null) {
			radiusField = new JunVrmlSFFloatField(DefaultRadius());
		}

		return radiusField;
	}
}
