package jp.co.sra.jun.vrml.node.abstracts;

import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlAbstractGeometryNode class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlAbstractGeometryNode.java,v 8.10 2008/02/20 06:33:15 nisinaka Exp $
 */
public abstract class JunVrmlAbstractGeometryNode extends JunVrmlNode {

	/**
	 * Convert the geometry node as a JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public abstract JunOpenGL3dObject asJunOpenGL3dObject();

	/**
	 * Answer true if the receiver is a geometry node, otherwise false.
	 * 
	 * @return boolean
	 */
	public boolean isGeometryNode() {
		return true;
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		aVisitor.doGeneralGeometry_(this);
	}
}
