package jp.co.sra.jun.vrml.field.mf;

import java.util.Vector;
import jp.co.sra.jun.vrml.field.abstracts.*;

/**
 * JunVrmlMFStringField class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlMFStringField.java,v 8.11 2008/02/20 06:33:14 nisinaka Exp $
 */
public class JunVrmlMFStringField extends JunVrmlMFField {
	protected String[] value;

	/**
	 * Create a new instance of JunVrmlMFStringField and initialize it.
	 * 
	 * @param strings java.lang.String[]
	 */
	public JunVrmlMFStringField(String[] strings) {
		super();
		this.value_(strings);
	}

	/**
	 * Create a JunVrmlMFStringField and initialize it.
	 * 
	 * @param anObject java.lang.Object
	 */
	public JunVrmlMFStringField(Object anObject) {
		super();

		//
		// anObject should be a Vector, but in some examples,
		// anObject is passwd as a String... sigh.
		if (anObject instanceof String) {
			this.value_(new String[] {(String) anObject });
		} else {
			this.value_((Vector) anObject);
		}
	}

	/**
	 * Create a JunVrmlMFStringField and initialize it.
	 * 
	 * @param aVector java.utilVector
	 */
	public JunVrmlMFStringField(Vector aVector) {
		super();
		this.value_(aVector);
	}

	/**
	 * Answer my value.
	 * 
	 * @return java.lang.String[]
	 */
	public String[] value() {
		return value;
	}

	/**
	 * Set my value.
	 * 
	 * @param strings java.lang.String[]
	 */
	public void value_(String[] strings) {
		value = strings;
	}

	/**
	 * Set my value.
	 * 
	 * @param aVector float[]
	 */
	public void value_(Vector aVector) {
		value = new String[aVector.size()];
		aVector.copyInto(value);
	}
}
