package jp.co.sra.jun.vrml.field.mf;

import java.util.Vector;

/**
 * JunVrmlMFInt32Field class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlMFInt32Field.java,v 8.11 2008/02/20 06:33:14 nisinaka Exp $
 */
public class JunVrmlMFInt32Field extends jp.co.sra.jun.vrml.field.abstracts.JunVrmlMFField {
	protected int[] value;

	/**
	 * Create a new instance of JunVrmlMFInt32Field and initialize it.
	 * 
	 * @param numbers int[]
	 */
	public JunVrmlMFInt32Field(int[] numbers) {
		super();
		this.value_(numbers);
	}

	/**
	 * Create a JunVrmlMFInt32Field and initialize it.
	 * 
	 * @param anObject java.lang.Object
	 */
	public JunVrmlMFInt32Field(Object anObject) {
		this((Vector) anObject);
	}

	/**
	 * Create a JunVrmlMFInt32Field and initialize it.
	 * 
	 * @param aVector java.util.Vector
	 */
	public JunVrmlMFInt32Field(Vector aVector) {
		super();
		this.value_(aVector);
	}

	/**
	 * Convert the value to a point array.
	 * 
	 * @return int[][]
	 */
	public int[][] asPointArray() {
		Vector collection = new Vector();
		int lastIndex = 0;

		for (int i = 0; i < value.length; i++) {
			if (value[i] < 0) {
				int size = i - lastIndex;
				int[] array = new int[size];

				for (int j = 0; j < size; j++) {
					array[j] = value[lastIndex + j];
				}

				collection.addElement(array);
				lastIndex = i + 1;
			}
		}

		if (lastIndex < value.length) {
			int size = value.length - lastIndex;
			int[] array = new int[size];

			for (int j = 0; j < size; j++) {
				array[j] = value[lastIndex + j];
			}

			collection.addElement(array);
		}

		//
		int size = collection.size();
		int[][] pointArray = new int[size][];
		collection.copyInto(pointArray);

		return pointArray;
	}

	/**
	 * Answer my value.
	 * 
	 * @return int[]
	 */
	public int[] value() {
		return value;
	}

	/**
	 * Set my value.
	 * 
	 * @param numbers int[]
	 */
	public void value_(int[] numbers) {
		value = numbers;
	}

	/**
	 * Set my value.
	 * 
	 * @param aVector java.util.Vector
	 */
	public void value_(Vector aVector) {
		Number[] numbers = new Number[aVector.size()];
		aVector.copyInto(numbers);
		value = new int[numbers.length];

		for (int i = 0; i < numbers.length; i++) {
			value[i] = numbers[i].intValue();
		}
	}
}
