package jp.co.sra.jun.topology.setoperators;

import java.awt.Color;
import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.opengl.objects.*;
import jp.co.sra.jun.topology.elements.JunBody;

/**
 * JunUNIONTestExamples class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunUNIONTestExamples.java,v 8.10 2008/02/20 06:33:13 nisinaka Exp $
 */
public class JunUNIONTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * JunUNION example1.
	 * 
	 * @return boolean.
	 */
	public static boolean Example1() {
		Jun3dPoint[] points = { new Jun3dPoint(0, 0, 0), new Jun3dPoint(1.5, 0, 0), new Jun3dPoint(0, 1.5, 0), new Jun3dPoint(0, 0, 1.5)};
		JunBody body1 = JunBody.Tetrahedron_(points);
		JunBody body2 = JunBody.UnitCube();
		JunUNION union = new JunUNION(body1, body2);
		union.doOperation();
		union.body().asJunOpenGL3dObject().show();

		return true;
	}

	/**
	 * JunUNION example2.
	 * 
	 * @return boolean.
	 */
	public static boolean Example2() {
		JunBody body1 = JunBody.CubeOrigin_corner_(new Jun3dPoint(-1, -1, -1), new Jun3dPoint(1, 1, 1));
		JunBody body2 = JunBody.CubeOrigin_corner_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(2, 2, 2));
		JunUNION union = new JunUNION(body1, body2);
		union.doOperation();

		JunOpenGL3dObject object = body1.asJunOpenGL3dObject();
		object.paint_(Color.blue);
		object.show();

		return true;
	}

	/**
	 * JunUNION example3.
	 * 
	 * @return boolean.
	 */
	public static boolean Example3() {
		JunBody body1 = JunBody.CubeOrigin_corner_(new Jun3dPoint(-1, -1, -1), new Jun3dPoint(2, 1, 1));
		JunBody body2 = JunBody.CubeOrigin_corner_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 2, 2));
		JunUNION union = new JunUNION(body1, body2);
		union.doOperation();

		JunOpenGL3dObject object = body1.asJunOpenGL3dObject();
		object.paint_(Color.blue);
		object.show();

		return true;
	}

	/**
	 * JunUNION example4.
	 * 
	 * @return boolean.
	 */
	public static boolean Example4() {
		JunBody body1 = JunBody.CubeOrigin_corner_(new Jun3dPoint(-3, -1, -1), new Jun3dPoint(1, 3, 1));
		JunBody body2 = JunBody.GlobeLatitudes_longitudes_center_radius_(9, 18, new Jun3dPoint(0, 0, 0), 2.0);
		JunUNION union = new JunUNION(body1, body2);
		union.doOperation();

		JunOpenGL3dObject object = body1.asJunOpenGL3dObject();
		object.paint_(Color.blue);
		object.show();

		return true;
	}

	/**
	 * JunUNION example5.
	 * 
	 * @return boolean.
	 */
	public static boolean Example5() {
		JunBody body1 = JunBody.GlobeLatitudes_longitudes_center_radius_(8, 16, new Jun3dPoint(8, 0, 0), 8.0);
		JunBody body2 = JunBody.GlobeLatitudes_longitudes_center_radius_(8, 16, new Jun3dPoint(0, 0, 0), 8.0);
		JunUNION union = new JunUNION(body1, body2);
		union.doOperation();

		JunOpenGL3dObject object = body1.asJunOpenGL3dObject();
		object.paint_(Color.blue);
		object.show();

		return true;
	}

	/**
	 * JunUNION example6.
	 * 
	 * @return boolean.
	 */
	public static boolean Example6() {
		JunBody body1 = JunBody.CubeOrigin_corner_(new Jun3dPoint(-2, -1, -1), new Jun3dPoint(2, 1, 2));
		JunBody body2 = JunBody.CubeOrigin_corner_(new Jun3dPoint(-1, -2, -2), new Jun3dPoint(1, 2, 1));
		(new JunDIFF(body1, body2)).doOperation();

		JunBody body3 = JunBody.CubeOrigin_corner_(new Jun3dPoint(-3, -3, -2), new Jun3dPoint(3, 3, 0));
		JunUNION union = new JunUNION(body1, body3);
		union.doOperation();

		JunOpenGL3dObject object = union.body().asJunOpenGL3dObject();
		object.paint_(Color.blue);
		object.show();

		return true;
	}

	/**
	 * JunUNION example7.
	 * 
	 * @return boolean.
	 */
	public static boolean Example7() {
		JunBody body1 = JunBody.CubeOrigin_corner_(new Jun3dPoint(-3, -1, -1), new Jun3dPoint(1, 3, 1));
		JunBody body2 = JunBody.GlobeLatitudes_longitudes_center_radius_(9, 18, new Jun3dPoint(0, 0, 0), 2.01);
		JunUNION union = new JunUNION(body1, body2);
		union.doOperation();

		JunOpenGL3dObject object = body1.asJunOpenGL3dObject();
		object.paint_(Color.blue);
		object.show();
		union.inverse().doOperation();
		object = body1.asJunOpenGL3dObject();
		object.paint_(Color.blue);
		object.show();
		union.doOperation();
		object = body1.asJunOpenGL3dObject();
		object.paint_(Color.blue);
		object.show();

		return true;
	}

	/**
	 * JunUNION example8.
	 * 
	 * @return boolean.
	 */
	public static boolean Example8() {
		JunBody body1 = JunBody.CubeOrigin_corner_(new Jun3dPoint(-1, -1, -1), new Jun3dPoint(0, 0, 0));
		JunBody body2 = JunBody.CubeOrigin_corner_(new Jun3dPoint(-1, -1, 0), new Jun3dPoint(1, 1, 1));
		JunUNION union = new JunUNION(body1, body2);
		union.doOperation();

		JunOpenGL3dObject object = body1.asJunOpenGL3dObject();
		object.paint_(Color.blue);
		object.show();
		union.inverse().doOperation();
		object = body1.asJunOpenGL3dObject();
		object.paint_(Color.blue);
		object.show();
		union.doOperation();
		object = body1.asJunOpenGL3dObject();
		object.paint_(Color.blue);
		object.show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunUNIONTestExamples();
	}
}
