package jp.co.sra.jun.topology.grapher;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;

import jp.co.sra.smalltalk.StColorValue;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.system.framework.JunAbstractView;
import jp.co.sra.jun.topology.graph.JunElementalNode;

/**
 * JunGrapherView interface
 * 
 *  @author    nisinaka
 *  @created   2006/04/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun602 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunGrapherView.java,v 8.11 2008/02/20 06:33:13 nisinaka Exp $
 */
public interface JunGrapherView extends JunAbstractView {

	public static Rectangle DefaultBounds = new Rectangle(64, 48, 1024, 768);
	public static Color DefaultBackgroundColor = StColorValue.ScaledRed_ScaledGreen_ScaledBlue_(8000, 8000, 8000);

	/**
	 * Answer my model as JunGrapher.
	 * 
	 * @return jp.co.sra.jun.topology.graph.JunElementalGrapher
	 * @category model accessing
	 */
	public JunGrapher getGrapher();

	/**
	 * Answer my scale factor for the bird view.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category accessing
	 */
	public Jun2dPoint _scaleFactor();

	/**
	 * Flush my scale factor for the bird view.
	 * 
	 * @category flushing
	 */
	public void _flushScaleFactor();

	/**
	 * Redislay the view.
	 * 
	 * @category displaying
	 */
	public void redisplay();

	/**
	 * Answer the scroll amount.
	 * 
	 * @return java.awt.Point
	 * @category scrolling
	 */
	public Point scrollAmount();

	/**
	 * Set the scroll amount.
	 * 
	 * @param aPoint java.awt.Point
	 * @category scrolling
	 */
	public void scrollAmount_(Point aPoint);

	/**
	 * Scroll to the specified point.
	 * 
	 * @param aPoint java.awt.Point
	 * @category scrolling
	 */
	public void scrollTo_(Point aPoint);

	/**
	 * Scroll by the specified amount.
	 * 
	 * @param aPoint java.awt.Point
	 * @category scrolling 
	 */
	public void scrollBy_(Point aPoint);

	/**
	 * Scroll for the specified node.
	 * 
	 * @param aNode jp.co.sra.jun.topology.graph.JunElementalNode
	 * @category scrolling
	 */
	public void scrollFor_(JunElementalNode aNode);

	/**
	 * Convert a model point to a view point, and answer it.
	 * 
	 * @param aPoint java.awt.Point
	 * @return java.awt.Point
	 * @category converting
	 */
	public Point convertModelPointToViewPoint_(Point aPoint);

	/**
	 * Convert a view point to a model point, and answer it.
	 * 
	 * @param aPoint java.awt.Point
	 * @return java.awt.Point
	 * @category converting
	 */
	public Point convertViewPointToModelPoint_(Point aPoint);

}
