package jp.co.sra.jun.topology.graph;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.HashMap;
import java.util.Iterator;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.track.JunSimpleSliderModel;
import jp.co.sra.jun.goodies.track.JunSimpleSliderViewAwt;

/**
 * JunElementalNodeSettingsViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2006/04/17 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun593 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunElementalNodeSettingsViewAwt.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunElementalNodeSettingsViewAwt extends JunElementalStuffSettingsViewAwt implements JunElementalNodeSettingsView {

	protected TextField labelStringField;
	protected TextField xLocationStringField;
	protected TextField yLocationStringField;
	protected Button foregroundColorButton;
	protected Button backgroundColorButton;
	protected Button borderColorButton;
	protected JunSimpleSliderViewAwt borderWidthSlider;
	protected Button allDefaultsButton;

	private HashMap _blockValues;

	/**
	 * Create a new instance of JunElementalNodeSettingsViewAwt and initialize it.
	 *
	 * @param anElementalNodeSettings
	 * @category Instance creation
	 */
	public JunElementalNodeSettingsViewAwt(JunElementalNodeSettings anElementalNodeSettings) {
		super(anElementalNodeSettings);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		_blockValues = new HashMap();
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(new Label($String("Label") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 16));
		this.add(this.labelStringField(), WindowSpecLayout.Position(0f, 88, 0f, 16, 0f, 248, 0f, 40));
		this.add(new Label($String("Location") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 48));
		this.add(new Label("x"), WindowSpecLayout.Position(0f, 96 - 3, 0f, 48));
		this.add(this.xLocationStringField(), WindowSpecLayout.Position(0f, 112, 0f, 48, 0f, 168, 0f, 72));
		this.add(new Label("y"), WindowSpecLayout.Position(0f, 176 - 3, 0f, 48));
		this.add(this.yLocationStringField(), WindowSpecLayout.Position(0f, 192, 0f, 48, 0f, 248, 0f, 72));
		this.add(new Label($String("Foreground Color") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 80));
		this.add(this.foregroundColorButton(), WindowSpecLayout.Position(0f, 168, 0f, 80, 0f, 248, 0f, 104));
		this.add(new Label($String("Background Color") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 112));
		this.add(this.backgroundColorButton(), WindowSpecLayout.Position(0f, 168, 0f, 112, 0f, 248, 0f, 136));
		this.add(new Label($String("Border Color") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 144));
		this.add(this.borderColorButton(), WindowSpecLayout.Position(0f, 168, 0f, 144, 0f, 248, 0f, 168));
		this.add(new Label($String("Border Width") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 176));
		this.add(this.borderWidthSlider(), WindowSpecLayout.Position(0f, 168, 0f, 176, 0f, 248, 0f, 200));
		this.add(this.allDefaultsButton(), WindowSpecLayout.Position(0.5f, -52, 0f, 216, 0.5f, 52, 0f, 240));
		this.setSize(DefaultBounds.getSize());
	}

	/**
	 * Answer my model as JunElementalNodeSettings.
	 * 
	 * @return jp.co.sra.jun.topology.graph.JunElementalNodeSettings
	 * @see jp.co.sra.jun.topology.graph.JunElementalNodeSettingsView#getElementalNodeSettings()
	 * @category model accessing
	 */
	public JunElementalNodeSettings getElementalNodeSettings() {
		return (JunElementalNodeSettings) this.model();
	}

	/**
	 * Answer the label string field.
	 * 
	 * @return java.awt.TextField
	 * @category user interface
	 */
	protected TextField labelStringField() {
		if (labelStringField == null) {
			labelStringField = new TextField() {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(labelStringField)).release();
					super.removeNotify();
				}

			};
			labelStringField.addTextListener(new TextListener() {
				public void textValueChanged(TextEvent e) {
					getElementalNodeSettings().labelStringHolder().value_(labelStringField.getText());
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					String aString = (String) anObject;
					if (labelStringField.getText().equals(aString) == false) {
						labelStringField.setText(aString);
					}
					return null;
				}
			};
			StBlockValue blockValue = this.getElementalNodeSettings().labelStringHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(labelStringField, blockValue);
		}
		return labelStringField;
	}

	/**
	 * Answer the x-location string field.
	 * 
	 * @return java.awt.TextField
	 * @category user interface
	 */
	protected TextField xLocationStringField() {
		if (xLocationStringField == null) {
			xLocationStringField = new TextField() {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(xLocationStringField)).release();
					super.removeNotify();
				}
			};
			xLocationStringField.addTextListener(new TextListener() {
				public void textValueChanged(TextEvent e) {
					getElementalNodeSettings().labelStringHolder().setValue_(xLocationStringField.getText());
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					String aString = (String) anObject;
					if (xLocationStringField.getText().equals(aString) == false) {
						xLocationStringField.setText(aString);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalNodeSettings().xLocationStringHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(xLocationStringField, blockValue);
		}
		return xLocationStringField;
	}

	/**
	 * Answer the y-location string field.
	 * 
	 * @return java.awt.TextField
	 * @category user interface
	 */
	protected TextField yLocationStringField() {
		if (yLocationStringField == null) {
			yLocationStringField = new TextField() {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(yLocationStringField)).release();
					super.removeNotify();
				}
			};
			yLocationStringField.addTextListener(new TextListener() {
				public void textValueChanged(TextEvent e) {
					getElementalNodeSettings().labelStringHolder().setValue_(yLocationStringField.getText());
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					String aString = (String) anObject;
					if (yLocationStringField.getText().equals(aString) == false) {
						yLocationStringField.setText(aString);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalNodeSettings().yLocationStringHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(yLocationStringField, blockValue);
		}
		return yLocationStringField;
	}

	/**
	 * Answer the foreground color button.
	 * 
	 * @return java.awt.Button
	 * @category user interface
	 */
	protected Button foregroundColorButton() {
		if (foregroundColorButton == null) {
			foregroundColorButton = new Button() {
				public void paint(Graphics g) {
					super.paint(g);

					Dimension size = this.getSize();
					int x = (size.width - ButtonColorImageSize.width) / 2;
					int y = (size.height - ButtonColorImageSize.height) / 2;
					g.setColor((Color) getElementalNodeSettings().foregroundColorHolder().value());
					g.fillRect(x, y, ButtonColorImageSize.width, ButtonColorImageSize.height);
				}

				public void removeNotify() {
					((StBlockValue) _blockValues.get(foregroundColorButton)).release();
					super.removeNotify();
				}
			};
			foregroundColorButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalNodeSettings().foregroundColorButtonPressed();
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					foregroundColorButton.repaint();
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalNodeSettings().foregroundColorHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(foregroundColorButton, blockValue);
		}
		return foregroundColorButton;
	}

	/**
	 * Answer the background color button.
	 * 
	 * @return java.awt.Button
	 * @category user interface
	 */
	protected Button backgroundColorButton() {
		if (backgroundColorButton == null) {
			backgroundColorButton = new Button() {
				public void paint(Graphics g) {
					super.paint(g);

					Dimension size = this.getSize();
					int x = (size.width - ButtonColorImageSize.width) / 2;
					int y = (size.height - ButtonColorImageSize.height) / 2;
					g.setColor((Color) getElementalNodeSettings().backgroundColorHolder().value());
					g.fillRect(x, y, ButtonColorImageSize.width, ButtonColorImageSize.height);
				}

				public void removeNotify() {
					((StBlockValue) _blockValues.get(backgroundColorButton)).release();
					super.removeNotify();
				}
			};
			backgroundColorButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalNodeSettings().backgroundColorButtonPressed();
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					backgroundColorButton.repaint();
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalNodeSettings().backgroundColorHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(backgroundColorButton, blockValue);
		}
		return backgroundColorButton;
	}

	/**
	 * Answer the border color button.
	 * 
	 * @return java.awt.Button
	 * @category user interface
	 */
	protected Button borderColorButton() {
		if (borderColorButton == null) {
			borderColorButton = new Button() {
				public void paint(Graphics g) {
					super.paint(g);

					Dimension size = this.getSize();
					int x = (size.width - ButtonColorImageSize.width) / 2;
					int y = (size.height - ButtonColorImageSize.height) / 2;
					g.setColor((Color) getElementalNodeSettings().borderColorHolder().value());
					g.fillRect(x, y, ButtonColorImageSize.width, ButtonColorImageSize.height);
				}

				public void removeNotify() {
					((StBlockValue) _blockValues.get(borderColorButton)).release();
					super.removeNotify();
				}
			};
			borderColorButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalNodeSettings().borderColorButtonPressed();
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					borderColorButton.repaint();
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalNodeSettings().borderColorHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(borderColorButton, blockValue);
		}
		return borderColorButton;
	}

	/**
	 * Answer the border width slider.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunSimpleSliderViewAwt
	 * @category user interface
	 */
	protected JunSimpleSliderViewAwt borderWidthSlider() {
		if (borderWidthSlider == null) {
			JunSimpleSliderModel sliderModel = new JunSimpleSliderModel();
			sliderModel.compute_(new StBlockClosure() {
				public Object value_(Object anObject) {
					double value = ((Number) anObject).doubleValue();
					int width = (int) (Math.round(value * 4)) + 1;
					getElementalNodeSettings().borderWidthHolder().value_(new Integer(width));
					return null;
				}
			});
			borderWidthSlider = new JunSimpleSliderViewAwt(sliderModel) {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(borderWidthSlider)).release();
					super.removeNotify();
				}
			};

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					int width = ((Number) anObject).intValue();
					double value = (width - 1) / 4.0d;
					if (value != borderWidthSlider.getSimpleSliderModel().doubleValue()) {
						borderWidthSlider.getSimpleSliderModel().value_(value);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalNodeSettings().borderWidthHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(borderWidthSlider, blockValue);

		}
		return borderWidthSlider;
	}

	/**
	 * Answer the all defaults button.
	 * 
	 * @return java.awt.Button
	 * @category user interface
	 */
	protected Button allDefaultsButton() {
		if (allDefaultsButton == null) {
			allDefaultsButton = new Button($String("Default"));
			allDefaultsButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalNodeSettings().defaultButtonPressed();
				}
			});
		}
		return allDefaultsButton;
	}

	/**
	 * Update for the change notice from the model.
	 * 
	 * @param e jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent e) {
		if (e.getAspect() == $("widgets")) {
			Iterator i = _blockValues.values().iterator();
			while (i.hasNext()) {
				((StBlockValue) i.next()).computeValue();
			}
		} else {
			super.update_(e);
		}
	}

}
