package jp.co.sra.jun.topology.graph;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.HashMap;
import java.util.Iterator;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.track.JunSimpleSliderModel;
import jp.co.sra.jun.goodies.track.JunSimpleSliderViewAwt;

/**
 * JunElementalGraphSettingsViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2006/04/20 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun593 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunElementalGraphSettingsViewAwt.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunElementalGraphSettingsViewAwt extends JunElementalStuffSettingsViewAwt implements JunElementalGraphSettingsView {

	protected TextField labelStringField;
	protected Button selectionBorderColorButton;
	protected JunSimpleSliderViewAwt selectionBorderWidthSlider;
	protected Checkbox arrangeNoneButton;
	protected Checkbox arrangeForestButton;
	protected JunSimpleSliderViewAwt arrangeForestIntervalSlider;
	protected JunSimpleSliderViewAwt arrangeForestMarginSlider;
	protected Checkbox arrangeConcentricButton;
	protected JunSimpleSliderViewAwt arrangeConcentricRadiusSlider;
	protected JunSimpleSliderViewAwt arrangeConcentricSpiralSlider;
	protected Checkbox arrangeConcentricGradationOnButton;
	protected Checkbox arrangeConcentricGradationOffButton;
	protected TextField arrangeAttributeSymbolField;
	protected Button allDefaultsButton;

	private HashMap _blockValues;
	private CheckboxGroup _arrangeFormatCheckboxGroup;
	private CheckboxGroup _arrangeConcentricGradationCheckboxGroup;

	/**
	 * Create a new instance of JunElementalGraphSettingsViewAwt and initialize it.
	 *
	 * @param anElementalGraphSettings jp.co.sra.jun.topology.graph.JunElementalGraphSettings
	 * @category Instance creation
	 */
	public JunElementalGraphSettingsViewAwt(JunElementalGraphSettings anElementalGraphSettings) {
		super(anElementalGraphSettings);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		_blockValues = new HashMap();
		_arrangeFormatCheckboxGroup = new CheckboxGroup();
		_arrangeConcentricGradationCheckboxGroup = new CheckboxGroup();
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(new Label($String("Label") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 16));
		this.add(this.labelStringField(), WindowSpecLayout.Position(0f, 88, 0f, 16, 0f, 248, 0f, 40));
		this.add(new Label($String("Selection Border Color") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 48));
		this.add(this.selectionBorderColorButton(), WindowSpecLayout.Position(0f, 168, 0f, 48, 0f, 248, 0f, 72));
		this.add(new Label($String("Selection Border Width") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 80));
		this.add(this.selectionBorderWidthSlider(), WindowSpecLayout.Position(0f, 168, 0f, 80, 0f, 248, 0f, 104));
		this.add(new Label($String("Arrange Format") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 112));
		this.add(this.arrangeNoneButton(), WindowSpecLayout.Position(0f, 24, 0f, 144));
		this.add(this.arrangeForestButton(), WindowSpecLayout.Position(0f, 24, 0f, 176));
		this.add(new Label($String("Interval") + " :"), WindowSpecLayout.Position(0f, 48, 0f, 208));
		this.add(this.arrangeForestIntervalSlider(), WindowSpecLayout.Position(0f, 144, 0f, 208, 0f, 248, 0f, 232));
		this.add(new Label($String("Margin") + " :"), WindowSpecLayout.Position(0f, 48, 0f, 240));
		this.add(this.arrangeForestMarginSlider(), WindowSpecLayout.Position(0f, 168, 0f, 240, 0f, 248, 0f, 264));
		this.add(this.arrangeConcentricButton(), WindowSpecLayout.Position(0f, 24, 0f, 272));
		this.add(new Label($String("Radius") + " :"), WindowSpecLayout.Position(0f, 48, 0f, 304));
		this.add(this.arrangeConcentricRadiusSlider(), WindowSpecLayout.Position(0f, 144, 0f, 304, 0f, 248, 0f, 328));
		this.add(new Label($String("Spiral") + " :"), WindowSpecLayout.Position(0f, 48, 0f, 336));
		this.add(this.arrangeConcentricSpiralSlider(), WindowSpecLayout.Position(0f, 168, 0f, 336, 0f, 248, 0f, 360));
		this.add(new Label($String("Gradation") + " :"), WindowSpecLayout.Position(0f, 48, 0f, 368));
		this.add(this.arrangeConcentricGradationOnButton(), WindowSpecLayout.Position(0f, 152, 0f, 368));
		this.add(this.arrangeConcentricGradationOffButton(), WindowSpecLayout.Position(0f, 200, 0f, 368));
		this.add(new Label($String("Attribute") + " :"), WindowSpecLayout.Position(0f, 48, 0f, 400));
		this.add(this.arrangeAttributeSymbolField(), WindowSpecLayout.Position(0f, 144, 0f, 400, 0f, 248, 0f, 424));
		this.add(this.allDefaultsButton(), WindowSpecLayout.Position(0.5f, -52, 0f, 440, 0.5f, 52, 0f, 464));
		this.setSize(DefaultBounds.getSize());
	}

	/**
	 * Answer my model as JunElementalGraphSettings.
	 * 
	 * @return jp.co.sra.jun.topology.graph.JunElementalGraphSettings
	 * @see jp.co.sra.jun.topology.graph.JunElementalGraphSettingsView#getElementalGraphSettings()
	 * @category model accessing
	 */
	public JunElementalGraphSettings getElementalGraphSettings() {
		return (JunElementalGraphSettings) this.model();
	}

	/**
	 * Answer the label string field.
	 * 
	 * @return java.awt.TextField
	 * @category user interface
	 */
	protected TextField labelStringField() {
		if (labelStringField == null) {
			labelStringField = new TextField() {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(labelStringField)).release();
					super.removeNotify();
				}

			};
			labelStringField.addTextListener(new TextListener() {
				public void textValueChanged(TextEvent e) {
					getElementalGraphSettings().labelStringHolder().value_(labelStringField.getText());
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					String aString = (String) anObject;
					if (labelStringField.getText().equals(aString) == false) {
						labelStringField.setText(aString);
					}
					return null;
				}
			};
			StBlockValue blockValue = this.getElementalGraphSettings().labelStringHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(labelStringField, blockValue);
		}
		return labelStringField;
	}

	/**
	 * Answer the selection border color button.
	 * 
	 * @return java.awt.Button
	 * @category user interface
	 */
	protected Button selectionBorderColorButton() {
		if (selectionBorderColorButton == null) {
			selectionBorderColorButton = new Button() {
				public void paint(Graphics g) {
					super.paint(g);

					Dimension size = this.getSize();
					int x = (size.width - ButtonColorImageSize.width) / 2;
					int y = (size.height - ButtonColorImageSize.height) / 2;
					g.setColor((Color) getElementalGraphSettings().selectionBorderColorHolder().value());
					g.fillRect(x, y, ButtonColorImageSize.width, ButtonColorImageSize.height);
				}

				public void removeNotify() {
					((StBlockValue) _blockValues.get(selectionBorderColorButton)).release();
					super.removeNotify();
				}
			};
			selectionBorderColorButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalGraphSettings().selectionBorderColorButtonPressed();
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					selectionBorderColorButton.repaint();
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().selectionBorderColorHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(selectionBorderColorButton, blockValue);
		}
		return selectionBorderColorButton;
	}

	/**
	 * Answer the selection border width slider.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunSimpleSliderViewAwt
	 * @category user interface
	 */
	protected JunSimpleSliderViewAwt selectionBorderWidthSlider() {
		if (selectionBorderWidthSlider == null) {
			JunSimpleSliderModel sliderModel = new JunSimpleSliderModel();
			sliderModel.compute_(new StBlockClosure() {
				public Object value_(Object anObject) {
					double value = ((Number) anObject).doubleValue();
					int width = (int) ((value + 0.125) * 4) + 1;
					getElementalGraphSettings().selectionBorderWidthHolder().value_(new Integer(width));
					return null;
				}
			});
			selectionBorderWidthSlider = new JunSimpleSliderViewAwt(sliderModel) {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(selectionBorderWidthSlider)).release();
					super.removeNotify();
				}
			};

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					int width = ((Number) anObject).intValue();
					double value = (width - 1) / 4.0d;
					if (value != selectionBorderWidthSlider.getSimpleSliderModel().doubleValue()) {
						selectionBorderWidthSlider.getSimpleSliderModel().value_(value);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().selectionBorderWidthHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(selectionBorderWidthSlider, blockValue);
		}
		return selectionBorderWidthSlider;
	}

	/**
	 * Answer the arrange none button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox arrangeNoneButton() {
		if (arrangeNoneButton == null) {
			arrangeNoneButton = new Checkbox($String("None"), false, _arrangeFormatCheckboxGroup);
			arrangeNoneButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalGraphSettings().arrangeFormatHolder().value_($("none"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("none") && arrangeNoneButton.getState() == false) {
						arrangeNoneButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeFormatHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeNoneButton, blockValue);
		}
		return arrangeNoneButton;
	}

	/**
	 * Answer the arrange forest button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox arrangeForestButton() {
		if (arrangeForestButton == null) {
			arrangeForestButton = new Checkbox($String("Forest"), false, _arrangeFormatCheckboxGroup);
			arrangeForestButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalGraphSettings().arrangeFormatHolder().value_($("forest"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("forest") && arrangeForestButton.getState() == false) {
						arrangeForestButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeFormatHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeForestButton, blockValue);
		}
		return arrangeForestButton;
	}

	/**
	 * Answer the arrange forest interval slider.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunSimpleSliderViewAwt
	 * @category user interface
	 */
	protected JunSimpleSliderViewAwt arrangeForestIntervalSlider() {
		if (arrangeForestIntervalSlider == null) {
			JunSimpleSliderModel sliderModel = new JunSimpleSliderModel();
			sliderModel.compute_(new StBlockClosure() {
				public Object value_(Object anObject) {
					double value = ((Number) anObject).doubleValue();
					int width = (int) Math.round(value * 250 / 5) * 5;
					getElementalGraphSettings().arrangeForestIntervalHolder().value_(new Integer(width));
					return null;
				}
			});
			arrangeForestIntervalSlider = new JunSimpleSliderViewAwt(sliderModel) {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(arrangeForestIntervalSlider)).release();
					super.removeNotify();
				}
			};

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					int width = ((Number) anObject).intValue();
					double value = width / 250.0d;
					if (value != arrangeForestIntervalSlider.getSimpleSliderModel().doubleValue()) {
						arrangeForestIntervalSlider.getSimpleSliderModel().value_(value);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeForestIntervalHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeForestIntervalSlider, blockValue);
		}
		return arrangeForestIntervalSlider;
	}

	/**
	 * Answer the arrange forest margin slider.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunSimpleSliderViewAwt
	 * @category user interface
	 */
	protected JunSimpleSliderViewAwt arrangeForestMarginSlider() {
		if (arrangeForestMarginSlider == null) {
			JunSimpleSliderModel sliderModel = new JunSimpleSliderModel();
			sliderModel.compute_(new StBlockClosure() {
				public Object value_(Object anObject) {
					double value = ((Number) anObject).doubleValue();
					int width = (int) Math.round(value * 75);
					getElementalGraphSettings().arrangeForestMarginHolder().value_(new Integer(width));
					return null;
				}
			});
			arrangeForestMarginSlider = new JunSimpleSliderViewAwt(sliderModel) {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(arrangeForestMarginSlider)).release();
					super.removeNotify();
				}
			};

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					int width = ((Number) anObject).intValue();
					double value = width / 75.0d;
					if (value != arrangeForestMarginSlider.getSimpleSliderModel().doubleValue()) {
						arrangeForestMarginSlider.getSimpleSliderModel().value_(value);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeForestMarginHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeForestMarginSlider, blockValue);
		}
		return arrangeForestMarginSlider;
	}

	/**
	 * Answer the arrange concentric button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox arrangeConcentricButton() {
		if (arrangeConcentricButton == null) {
			arrangeConcentricButton = new Checkbox($String("Concentric"), false, _arrangeFormatCheckboxGroup);
			arrangeConcentricButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalGraphSettings().arrangeFormatHolder().value_($("concentric"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("concentric") && arrangeConcentricButton.getState() == false) {
						arrangeConcentricButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeFormatHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeConcentricButton, blockValue);
		}
		return arrangeConcentricButton;
	}

	/**
	 * Answer the arrange concentric radius slider.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunSimpleSliderViewAwt
	 * @category user interface
	 */
	protected JunSimpleSliderViewAwt arrangeConcentricRadiusSlider() {
		if (arrangeConcentricRadiusSlider == null) {
			JunSimpleSliderModel sliderModel = new JunSimpleSliderModel();
			sliderModel.compute_(new StBlockClosure() {
				public Object value_(Object anObject) {
					double value = ((Number) anObject).doubleValue();
					int width = (int) (Math.round(value * 900 / 20) * 20) + 100;
					getElementalGraphSettings().arrangeConcentricRadiusHolder().value_(new Integer(width));
					return null;
				}
			});
			arrangeConcentricRadiusSlider = new JunSimpleSliderViewAwt(sliderModel) {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(arrangeConcentricRadiusSlider)).release();
					super.removeNotify();
				}
			};

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					int width = ((Number) anObject).intValue();
					double value = (width - 100) / 900.0d;
					if (value != arrangeConcentricRadiusSlider.getSimpleSliderModel().doubleValue()) {
						arrangeConcentricRadiusSlider.getSimpleSliderModel().value_(value);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeConcentricRadiusHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeConcentricRadiusSlider, blockValue);
		}
		return arrangeConcentricRadiusSlider;
	}

	/**
	 * Answer the arrange concentric spiral slider.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunSimpleSliderViewAwt
	 * @category user interface
	 */
	protected JunSimpleSliderViewAwt arrangeConcentricSpiralSlider() {
		if (arrangeConcentricSpiralSlider == null) {
			JunSimpleSliderModel sliderModel = new JunSimpleSliderModel();
			sliderModel.compute_(new StBlockClosure() {
				public Object value_(Object anObject) {
					double value = ((Number) anObject).doubleValue();
					float width = (float) (Math.round(value * 9 / 0.25) * 0.25) + 1;
					getElementalGraphSettings().arrangeConcentricSpiralHolder().value_(new Float(width));
					return null;
				}
			});
			arrangeConcentricSpiralSlider = new JunSimpleSliderViewAwt(sliderModel) {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(arrangeConcentricSpiralSlider)).release();
					super.removeNotify();
				}
			};

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					float width = ((Number) anObject).floatValue();
					double value = (width - 1) / 9.0d;
					if (value != arrangeConcentricSpiralSlider.getSimpleSliderModel().doubleValue()) {
						arrangeConcentricSpiralSlider.getSimpleSliderModel().value_(value);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeConcentricSpiralHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeConcentricSpiralSlider, blockValue);
		}
		return arrangeConcentricSpiralSlider;
	}

	/**
	 * Answer the arrange concentric gradation on button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox arrangeConcentricGradationOnButton() {
		if (arrangeConcentricGradationOnButton == null) {
			arrangeConcentricGradationOnButton = new Checkbox("on", false, _arrangeConcentricGradationCheckboxGroup);
			arrangeConcentricGradationOnButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalGraphSettings().arrangeConcentricGradationHolder().value_(Boolean.TRUE);
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == Boolean.TRUE && arrangeConcentricGradationOnButton.getState() == false) {
						arrangeConcentricGradationOnButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeConcentricGradationHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeConcentricGradationOnButton, blockValue);

		}
		return arrangeConcentricGradationOnButton;
	}

	/**
	 * Answer the arrange concentric gradation off button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox arrangeConcentricGradationOffButton() {
		if (arrangeConcentricGradationOffButton == null) {
			arrangeConcentricGradationOffButton = new Checkbox("off", false, _arrangeConcentricGradationCheckboxGroup);
			arrangeConcentricGradationOffButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalGraphSettings().arrangeConcentricGradationHolder().value_(Boolean.FALSE);
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == Boolean.FALSE && arrangeConcentricGradationOffButton.getState() == false) {
						arrangeConcentricGradationOffButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalGraphSettings().arrangeConcentricGradationHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeConcentricGradationOffButton, blockValue);
		}
		return arrangeConcentricGradationOffButton;
	}

	/**
	 * Answer the arrange attribute symbol field.
	 * 
	 * @return java.awt.TextField
	 * @category user interface
	 */
	protected TextField arrangeAttributeSymbolField() {
		if (arrangeAttributeSymbolField == null) {
			arrangeAttributeSymbolField = new TextField() {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(arrangeAttributeSymbolField)).release();
					super.removeNotify();
				}

			};
			arrangeAttributeSymbolField.addTextListener(new TextListener() {
				public void textValueChanged(TextEvent e) {
					getElementalGraphSettings().arrangeAttributeSymbolHolder().value_(arrangeAttributeSymbolField.getText());
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					String aString = ((StSymbol) anObject).toString();
					if (arrangeAttributeSymbolField.getText().equals(aString) == false) {
						arrangeAttributeSymbolField.setText(aString);
					}
					return null;
				}
			};
			StBlockValue blockValue = this.getElementalGraphSettings().arrangeAttributeSymbolHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(arrangeAttributeSymbolField, blockValue);
		}
		return arrangeAttributeSymbolField;
	}

	/**
	 * Answer the all defaults button.
	 * 
	 * @return java.awt.Button
	 * @category user interface
	 */
	protected Button allDefaultsButton() {
		if (allDefaultsButton == null) {
			allDefaultsButton = new Button($String("Default"));
			allDefaultsButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalGraphSettings().defaultButtonPressed();
				}
			});
		}
		return allDefaultsButton;
	}

	/**
	 * Update for the change notice from the model.
	 * 
	 * @param e jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent e) {
		if (e.getAspect() == $("widgets")) {
			Iterator i = _blockValues.values().iterator();
			while (i.hasNext()) {
				((StBlockValue) i.next()).computeValue();
			}

			if (this.arrangeForestButton().getState()) {
				this.arrangeForestIntervalSlider().setVisible(true);
				this.arrangeForestMarginSlider().setVisible(true);
				this.arrangeConcentricRadiusSlider().setVisible(false);
				this.arrangeConcentricSpiralSlider().setVisible(false);
				this.arrangeConcentricGradationOnButton().setVisible(false);
				this.arrangeConcentricGradationOffButton().setVisible(false);
				this.arrangeAttributeSymbolField().setVisible(false);
			} else if (this.arrangeConcentricButton().getState()) {
				this.arrangeForestIntervalSlider().setVisible(false);
				this.arrangeForestMarginSlider().setVisible(false);
				this.arrangeConcentricRadiusSlider().setVisible(true);
				this.arrangeConcentricSpiralSlider().setVisible(true);
				this.arrangeConcentricGradationOnButton().setVisible(true);
				this.arrangeConcentricGradationOffButton().setVisible(true);
				this.arrangeAttributeSymbolField().setVisible(true);
			} else {
				this.arrangeForestIntervalSlider().setVisible(false);
				this.arrangeForestMarginSlider().setVisible(false);
				this.arrangeConcentricRadiusSlider().setVisible(false);
				this.arrangeConcentricSpiralSlider().setVisible(false);
				this.arrangeConcentricGradationOnButton().setVisible(false);
				this.arrangeConcentricGradationOffButton().setVisible(false);
				this.arrangeAttributeSymbolField().setVisible(false);
			}
		} else {
			super.update_(e);
		}
	}

}
