package jp.co.sra.jun.topology.graph;

import java.awt.Color;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunElementalGraphSettingsTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/04/20 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun593 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunElementalGraphSettingsTestExamples.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunElementalGraphSettingsTestExamples extends JunTestExamples {

	/**
	 * Example0: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example0() {
		JunElementalGraphSettings settings = new JunElementalGraphSettings();
		settings.compute_(new StBlockClosure() {
			public Object value_value_(Object table, Object stuff) {
				System.out.println(table.toString() + " " + stuff);
				return null;
			}
		});
		settings.open();

		return true;
	}

	/**
	 * Example1: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunElementalGraph graph = new JunElementalGraph();
		graph.labelString_($String("Untitled"));
		graph.selectionBorderColor_(Color.blue);
		graph.selectionBorderWidth_(3);
		graph.arrangeFormat_($("forest"));
		graph.arrangeForestInterval_(100);
		graph.arrangeForestMargin_(5);

		JunElementalGraphSettings settings = new JunElementalGraphSettings(graph);
		settings.compute_(new StBlockClosure() {
			public Object value_value_(Object table, Object stuff) {
				System.out.println(table.toString() + " " + stuff);
				return null;
			}
		});
		settings.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunElementalGraphSettingsTestExamples();
	}

}
