package jp.co.sra.jun.topology.graph;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.goodies.tables.JunAttributeTable;

/**
 * JunElementalGraphSettings class
 * 
 *  @author    nisinaka
 *  @created   2006/04/20 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun593 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunElementalGraphSettings.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunElementalGraphSettings extends JunElementalStuffSettings {

	protected StValueHolder labelStringHolder;
	protected StValueHolder selectionBorderColorHolder;
	protected StValueHolder selectionBorderWidthHolder;
	protected StValueHolder arrangeFormatHolder;
	protected StValueHolder arrangeForestIntervalHolder;
	protected StValueHolder arrangeForestMarginHolder;
	protected StValueHolder arrangeConcentricRadiusHolder;
	protected StValueHolder arrangeConcentricSpiralHolder;
	protected StValueHolder arrangeConcentricGradationHolder;
	protected StValueHolder arrangeAttributeSymbolHolder;

	/**
	 * Create a new instance of JunElementalGraphSettings and initialize it.
	 *
	 * @category Instance creation
	 */
	public JunElementalGraphSettings() {
		super();
	}

	/**
	 * Create a new instance of JunElementalGraphSettings and initialize it.
	 *
	 * @param anElementalGraph jp.co.sra.jun.topology.graph.JunElementalGraph
	 * @category Instance creation
	 */
	public JunElementalGraphSettings(JunElementalGraph anElementalGraph) {
		this.stuff_(anElementalGraph);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		StBlockClosure updateSettingsBlock = new StBlockClosure() {
			public Object value_(Object anObject) {
				updateSettings();
				return null;
			}
		};

		labelStringHolder = new StValueHolder(JunElementalGraph.DefaultLabelString());
		labelStringHolder.compute_(updateSettingsBlock);

		selectionBorderColorHolder = new StValueHolder(JunElementalGraph.DefaultSelectionBorderColor());
		selectionBorderColorHolder.compute_(updateSettingsBlock);

		selectionBorderWidthHolder = new StValueHolder(JunElementalGraph.DefaultSelectionBorderWidth());
		selectionBorderWidthHolder.compute_(updateSettingsBlock);

		arrangeFormatHolder = new StValueHolder(JunElementalGraph.DefaultArrangeFormat());
		arrangeFormatHolder.compute_(updateSettingsBlock);

		arrangeForestIntervalHolder = new StValueHolder(JunElementalGraph.DefaultArrangeForestInterval());
		arrangeForestIntervalHolder.compute_(updateSettingsBlock);

		arrangeForestMarginHolder = new StValueHolder(JunElementalGraph.DefaultArrangeForestMargin());
		arrangeForestMarginHolder.compute_(updateSettingsBlock);

		arrangeConcentricRadiusHolder = new StValueHolder(JunElementalGraph.DefaultArrangeConcentricRadius());
		arrangeConcentricRadiusHolder.compute_(updateSettingsBlock);

		arrangeConcentricSpiralHolder = new StValueHolder(JunElementalGraph.DefaultArrangeConcentricSpiral());
		arrangeConcentricSpiralHolder.compute_(updateSettingsBlock);

		arrangeConcentricGradationHolder = new StValueHolder(JunElementalGraph.DefaultArrangeConcentricGradation());
		arrangeConcentricGradationHolder.compute_(updateSettingsBlock);

		arrangeAttributeSymbolHolder = new StValueHolder(JunElementalGraph.DefaultArrangeAttributeSymbol());
		arrangeAttributeSymbolHolder.compute_(updateSettingsBlock);
	}

	/**
	 * Answer the current settings.
	 * 
	 * @return java.util.Map
	 * @see jp.co.sra.jun.topology.graph.JunElementalStuffSettings#currentSettings()
	 * @category accessing
	 */
	public Map currentSettings() {
		HashMap aMap = new HashMap(10);
		aMap.put($("labelString"), this.labelStringHolder().value());
		aMap.put($("selectionBorderColor"), this.selectionBorderColorHolder().value());
		aMap.put($("selectionBorderWidth"), this.selectionBorderWidthHolder().value());
		aMap.put($("arrangeFormat"), this.arrangeFormatHolder().value());
		aMap.put($("arrangeForestInterval"), this.arrangeForestIntervalHolder().value());
		aMap.put($("arrangeForestMargin"), this.arrangeForestMarginHolder().value());
		aMap.put($("arrangeConcentricRadius"), this.arrangeConcentricRadiusHolder().value());
		aMap.put($("arrangeConcentricSpiral"), this.arrangeConcentricSpiralHolder().value());
		aMap.put($("arrangeConcentricGradation"), this.arrangeConcentricGradationHolder().value());
		aMap.put($("arrangeAttributeSymbol"), this.arrangeAttributeSymbolHolder().value());
		return aMap;
	}

	/**
	 * Answer the stuff settings.
	 * 
	 * @return java.util.Map
	 * @see jp.co.sra.jun.topology.graph.JunElementalStuffSettings#currentSettings()
	 * @category accessing
	 */
	public Map stuffSettings() {
		HashMap aMap = new HashMap(10);
		if (this.stuff() == null) {
			JunAttributeTable attributes = this.defaultAttributes();
			aMap.put($("labelStringHolder"), attributes.at_($("labelString")));
			aMap.put($("selectionBorderColorHolder"), attributes.at_($("selectionBorderColor")));
			aMap.put($("selectionBorderWidthHolder"), attributes.at_($("selectionBorderWidth")));
			aMap.put($("arrangeFormatHolder"), attributes.at_($("arrangeFormat")));
			aMap.put($("arrangeForestIntervalHolder"), attributes.at_($("arrangeForestInterval")));
			aMap.put($("arrangeForestMarginHolder"), attributes.at_($("arrangeForestMargin")));
			aMap.put($("arrangeConcentricRadiusHolder"), attributes.at_($("arrangeConcentricRadius")));
			aMap.put($("arrangeConcentricSpiralHolder"), attributes.at_($("arrangeConcentricSpiral")));
			aMap.put($("arrangeConcentricGradationHolder"), attributes.at_($("arrangeConcentricGradation")));
			aMap.put($("arrangeAttributeSymbolHolder"), attributes.at_($("arrangeAttributeSymbol")));
		} else if (this.stuff() instanceof JunElementalGraph) {
			JunElementalGraph aGraph = (JunElementalGraph) this.stuff();
			aMap.put($("labelStringHolder"), aGraph.labelString());
			aMap.put($("selectionBorderColorHolder"), aGraph.selectionBorderColor());
			aMap.put($("selectionBorderWidthHolder"), new Integer(aGraph.selectionBorderWidth()));
			aMap.put($("arrangeFormatHolder"), aGraph.arrangeFormat());
			aMap.put($("arrangeForestIntervalHolder"), new Integer(aGraph.arrangeForestInterval()));
			aMap.put($("arrangeForestMarginHolder"), new Integer(aGraph.arrangeForestMargin()));
			aMap.put($("arrangeConcentricRadiusHolder"), new Integer(aGraph.arrangeConcentricRadius()));
			aMap.put($("arrangeConcentricSpiralHolder"), new Float(aGraph.arrangeConcentricSpiral()));
			aMap.put($("arrangeConcentricGradationHolder"), aGraph.arrangeConcentricGradation());
			aMap.put($("arrangeAttributeSymbolHolder"), aGraph.arrangeAttributeSymbol());
		}
		return aMap;
	}

	/**
	 * Answer the value holder for the label string.
	 * 
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category aspects
	 */
	protected StValueHolder labelStringHolder() {
		return labelStringHolder;
	}

	/**
	 * Answer the value holder for the selection border color.
	 * 
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category aspects
	 */
	protected StValueHolder selectionBorderColorHolder() {
		return selectionBorderColorHolder;
	}

	/**
	 * Answer the value holder for the selection border width.
	 * 
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category aspects
	 */
	protected StValueHolder selectionBorderWidthHolder() {
		return selectionBorderWidthHolder;
	}

	/**
	 * Answer the value holder for the arrange format.
	 * 
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category aspects
	 */
	protected StValueHolder arrangeFormatHolder() {
		return arrangeFormatHolder;
	}

	/**
	 * Answer the value holder for the arrange forest interval.
	 * 
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category aspects
	 */
	protected StValueHolder arrangeForestIntervalHolder() {
		return arrangeForestIntervalHolder;
	}

	/**
	 * Answer the value holder for the arrange forest margin.
	 * 
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category aspects
	 */
	protected StValueHolder arrangeForestMarginHolder() {
		return arrangeForestMarginHolder;
	}

	/**
	 * Answer the value holder for the arrange concentric radius.
	 * 
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category aspects
	 */
	protected StValueHolder arrangeConcentricRadiusHolder() {
		return arrangeConcentricRadiusHolder;
	}

	/**
	 * Answer the value holder for the arrange concentric spiral.
	 * 
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category aspects
	 */
	protected StValueHolder arrangeConcentricSpiralHolder() {
		return arrangeConcentricSpiralHolder;
	}

	/**
	 * Answer the value holder for the arrange concentric gradation.
	 * 
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category aspects
	 */
	protected StValueHolder arrangeConcentricGradationHolder() {
		return arrangeConcentricGradationHolder;
	}

	/**
	 * Answer the value holder for the arrange attribute symbol.
	 * 
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category aspects
	 */
	protected StValueHolder arrangeAttributeSymbolHolder() {
		return arrangeAttributeSymbolHolder;
	}

	/**
	 * Create my default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunElementalGraphSettingsViewAwt(this);
		} else {
			return new JunElementalGraphSettingsViewSwing(this);
		}
	}

	/**
	 * Answer the default attribute table.
	 * 
	 * @return jp.co.sra.jun.goodies.tables.JunAttributeTable
	 * @see jp.co.sra.jun.topology.graph.JunElementalStuffSettings#defaultAttributes()
	 * @category defaults
	 */
	protected JunAttributeTable defaultAttributes() {
		return JunElementalGraph.DefaultAttributes;
	}

	/**
	 * Answer the window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		String aString = $String("Graph Settings");
		if (this.stuff() == null) {
			aString += " (==" + $String("Global") + "==)";
		} else {
			aString += " " + this.stuff().displayString();
		}
		return aString;
	}

	/**
	 * Action for the selection border color button.
	 * 
	 * @category actions
	 */
	protected void selectionBorderColorButtonPressed() {
		this._chooseColorFor(this.selectionBorderColorHolder());
	}

	/**
	 * Copy settings from current to stuff.
	 * 
	 * @see jp.co.sra.jun.topology.graph.JunElementalStuffSettings#settingsFromCurrentToStuff()
	 * @category private
	 */
	protected void settingsFromCurrentToStuff() {
		Map aMap = this.currentSettings();
		if (this.stuff() == null) {
			JunAttributeTable attributes = this.defaultAttributes();
			attributes.at_put_($("labelString"), aMap.get($("labelString")));
			attributes.at_put_($("selectionBorderColor"), aMap.get($("selectionBorderColor")));
			attributes.at_put_($("selectionBorderWidth"), aMap.get($("selectionBorderWidth")));
			attributes.at_put_($("arrangeFormat"), aMap.get($("arrangeFormat")));
			attributes.at_put_($("arrangeForestInterval"), aMap.get($("arrangeForestInterval")));
			attributes.at_put_($("arrangeForestMargin"), aMap.get($("arrangeForestMargin")));
			attributes.at_put_($("arrangeConcentricRadius"), aMap.get($("arrangeConcentricRadius")));
			attributes.at_put_($("arrangeConcentricSpiral"), aMap.get($("arrangeConcentricSpiral")));
			attributes.at_put_($("arrangeConcentricGradation"), aMap.get($("arrangeConcentricGradation")));
			attributes.at_put_($("arrangeAttributeSymbol"), aMap.get($("arrangeAttributeSymbol")));
		} else if (this.stuff() instanceof JunElementalGraph) {
			JunElementalGraph aGraph = (JunElementalGraph) this.stuff();
			aGraph.labelString_((String) aMap.get($("labelString")));
			aGraph.selectionBorderColor_((Color) aMap.get($("selectionBorderColor")));
			aGraph.selectionBorderWidth_(((Number) aMap.get($("selectionBorderWidth"))).intValue());
			aGraph.arrangeFormat_((StSymbol) aMap.get($("arrangeFormat")));
			aGraph.arrangeForestInterval_(((Number) aMap.get($("arrangeForestInterval"))).intValue());
			aGraph.arrangeForestMargin_(((Number) aMap.get($("arrangeForestMargin"))).intValue());
			aGraph.arrangeConcentricRadius_(((Number) aMap.get($("arrangeConcentricRadius"))).intValue());
			aGraph.arrangeConcentricSpiral_(((Number) aMap.get($("arrangeConcentricSpiral"))).floatValue());
			aGraph.arrangeConcentricGradation_((Boolean) aMap.get($("arrangeConcentricGradation")));
			aGraph.arrangeAttributeSymbol_((StSymbol) aMap.get($("arrangeAttributeSymbol")));
		}
	}

	/**
	 * Copy settings from stuff to current.
	 * 
	 * @see jp.co.sra.jun.topology.graph.JunElementalStuffSettings#settingsFromStuffToCurrent()
	 * @category private
	 */
	protected void settingsFromStuffToCurrent() {
		Map aMap = this.stuffSettings();
		this.labelStringHolder().setValue_(aMap.get($("labelStringHolder")));
		this.selectionBorderColorHolder().setValue_(aMap.get($("selectionBorderColorHolder")));
		this.selectionBorderWidthHolder().setValue_(aMap.get($("selectionBorderWidthHolder")));
		this.arrangeFormatHolder().setValue_(aMap.get($("arrangeFormatHolder")));
		this.arrangeForestIntervalHolder().setValue_(aMap.get($("arrangeForestIntervalHolder")));
		this.arrangeForestMarginHolder().setValue_(aMap.get($("arrangeForestMarginHolder")));
		this.arrangeConcentricRadiusHolder().setValue_(aMap.get($("arrangeConcentricRadiusHolder")));
		this.arrangeConcentricSpiralHolder().setValue_(aMap.get($("arrangeConcentricSpiralHolder")));
		this.arrangeConcentricGradationHolder().setValue_(aMap.get($("arrangeConcentricGradationHolder")));
		this.arrangeAttributeSymbolHolder().setValue_(aMap.get($("arrangeAttributeSymbolHolder")));

		settingsHolder.value_(this.stuffSettings());
		this.updateWidgets();
	}

	/**
	 * Reset the default attributes.
	 * 
	 * @see jp.co.sra.jun.topology.graph.JunElementalStuffSettings#resetDefaultAttributes()
	 * @category private
	 */
	protected void resetDefaultAttributes() {
		JunAttributeTable attributes = this.defaultAttributes();
		attributes.at_put_($("labelString"), JunElementalGraph.DefaultLabelString());
		attributes.at_put_($("selectionBorderColor"), JunElementalGraph.DefaultSelectionBorderColor());
		attributes.at_put_($("selectionBorderWidth"), new Integer(JunElementalGraph.DefaultSelectionBorderWidth()));
		attributes.at_put_($("arrangeFormat"), JunElementalGraph.DefaultArrangeFormat());
		attributes.at_put_($("arrangeForestInterval"), new Integer(JunElementalGraph.DefaultArrangeForestInterval()));
		attributes.at_put_($("arrangeForestMargin"), new Integer(JunElementalGraph.DefaultArrangeForestMargin()));
		attributes.at_put_($("arrangeConcentricRadius"), new Integer(JunElementalGraph.DefaultArrangeConcentricRadius()));
		attributes.at_put_($("arrangeConcentricSpiral"), new Float(JunElementalGraph.DefaultArrangeConcentricSpiral()));
		attributes.at_put_($("arrangeConcentricGradation"), JunElementalGraph.DefaultArrangeConcentricGradation());
		attributes.at_put_($("arrangeAttributeSymbol"), JunElementalGraph.DefaultArrangeAttributeSymbol());
	}

}
