package jp.co.sra.jun.topology.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;

import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.WindowSpecLayout;

/**
 * JunElementalArcSettingsViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2006/04/21 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun593 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunElementalArcSettingsViewSwing.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunElementalArcSettingsViewSwing extends JunElementalStuffSettingsViewSwing implements JunElementalArcSettingsView {

	protected JButton lineColorButton;
	protected JSlider lineWidthSlider;
	protected JButton firstBoxColorButton;
	protected JButton lastBoxColorButton;
	protected JRadioButton firstTopLeftButton;
	protected JRadioButton firstTopCenterButton;
	protected JRadioButton firstTopRightButton;
	protected JRadioButton firstLeftButton;
	protected JRadioButton firstCenterButton;
	protected JRadioButton firstRightButton;
	protected JRadioButton firstBottomLeftButton;
	protected JRadioButton firstBottomCenterButton;
	protected JRadioButton firstBottomRightButton;
	protected JRadioButton lastTopLeftButton;
	protected JRadioButton lastTopCenterButton;
	protected JRadioButton lastTopRightButton;
	protected JRadioButton lastLeftButton;
	protected JRadioButton lastCenterButton;
	protected JRadioButton lastRightButton;
	protected JRadioButton lastBottomLeftButton;
	protected JRadioButton lastBottomCenterButton;
	protected JRadioButton lastBottomRightButton;
	protected JButton allDefaultsButton;

	private HashMap _blockValues;
	private ButtonGroup _firstPointAlignmentButtonGroup;
	private ButtonGroup _lastPointAlignmentButtonGroup;

	/**
	 * Create a new instance of JunElementalArcSettingsViewSwing and initialize it.
	 *
	 * @param anElementalArcSettings jp.co.sra.jun.topology.graph.JunElementalArcSettings
	 * @category Instance creation
	 */
	public JunElementalArcSettingsViewSwing(JunElementalArcSettings anElementalArcSettings) {
		super(anElementalArcSettings);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		_blockValues = new HashMap();
		_firstPointAlignmentButtonGroup = new ButtonGroup();
		_lastPointAlignmentButtonGroup = new ButtonGroup();
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(new JLabel($String("Line Color") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 16));
		this.add(this.lineColorButton(), WindowSpecLayout.Position(0f, 168, 0f, 16, 0f, 248, 0f, 40));
		this.add(new JLabel($String("Line Width") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 48));
		this.add(this.lineWidthSlider(), WindowSpecLayout.Position(0f, 168, 0f, 48, 0f, 248, 0f, 72));
		this.add(new JLabel($String("First Box Color") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 80));
		this.add(this.firstBoxColorButton(), WindowSpecLayout.Position(0f, 168, 0f, 80, 0f, 248, 0f, 104));
		this.add(new JLabel($String("Last Box Color") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 112));
		this.add(this.lastBoxColorButton(), WindowSpecLayout.Position(0f, 168, 0f, 112, 0f, 248, 0f, 136));
		this.add(new JLabel($String("First Point Alignment") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 144));
		this.add(this.firstTopLeftButton(), WindowSpecLayout.Position(0f, 168, 0f, 152));
		this.add(this.firstTopCenterButton(), WindowSpecLayout.Position(0f, 200, 0f, 152));
		this.add(this.firstTopRightButton(), WindowSpecLayout.Position(0f, 232, 0f, 152));
		this.add(this.firstLeftButton(), WindowSpecLayout.Position(0f, 168, 0f, 176));
		this.add(this.firstCenterButton(), WindowSpecLayout.Position(0f, 200, 0f, 176));
		this.add(this.firstRightButton(), WindowSpecLayout.Position(0f, 232, 0f, 176));
		this.add(this.firstBottomLeftButton(), WindowSpecLayout.Position(0f, 168, 0f, 200));
		this.add(this.firstBottomCenterButton(), WindowSpecLayout.Position(0f, 200, 0f, 200));
		this.add(this.firstBottomRightButton(), WindowSpecLayout.Position(0f, 232, 0f, 200));
		this.add(new JLabel($String("Last Point Alignment") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 224));
		this.add(this.lastTopLeftButton(), WindowSpecLayout.Position(0f, 168, 0f, 232));
		this.add(this.lastTopCenterButton(), WindowSpecLayout.Position(0f, 200, 0f, 232));
		this.add(this.lastTopRightButton(), WindowSpecLayout.Position(0f, 232, 0f, 232));
		this.add(this.lastLeftButton(), WindowSpecLayout.Position(0f, 168, 0f, 256));
		this.add(this.lastCenterButton(), WindowSpecLayout.Position(0f, 200, 0f, 256));
		this.add(this.lastRightButton(), WindowSpecLayout.Position(0f, 232, 0f, 256));
		this.add(this.lastBottomLeftButton(), WindowSpecLayout.Position(0f, 168, 0f, 280));
		this.add(this.lastBottomCenterButton(), WindowSpecLayout.Position(0f, 200, 0f, 280));
		this.add(this.lastBottomRightButton(), WindowSpecLayout.Position(0f, 232, 0f, 280));
		this.add(this.allDefaultsButton(), WindowSpecLayout.Position(0.5f, -52, 0f, 312, 0.5f, 52, 0f, 336));
		this.setPreferredSize(DefaultBounds.getSize());
	}

	/**
	 * Answer my model as JunElementalArcSettings.
	 * 
	 * @return jp.co.sra.jun.topology.graph.JunElementalArcSettings
	 * @see jp.co.sra.jun.topology.graph.JunElementalArcSettingsView#getElementalArcSettings()
	 * @category model accessing
	 */
	public JunElementalArcSettings getElementalArcSettings() {
		return (JunElementalArcSettings) this.model();
	}

	/**
	 * Answer the line color button.
	 * 
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton lineColorButton() {
		if (lineColorButton == null) {
			lineColorButton = new JButton() {
				public void paint(Graphics g) {
					super.paint(g);

					Dimension size = this.getSize();
					int x = (size.width - ButtonColorImageSize.width) / 2;
					int y = (size.height - ButtonColorImageSize.height) / 2;
					g.setColor((Color) getElementalArcSettings().lineColorHolder().value());
					g.fillRect(x, y, ButtonColorImageSize.width, ButtonColorImageSize.height);
				}

				public void removeNotify() {
					((StBlockValue) _blockValues.get(lineColorButton)).release();
					super.removeNotify();
				}
			};
			lineColorButton.setAction(new AbstractAction() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().lineColorButtonPressed();
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					lineColorButton.repaint();
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lineColorHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lineColorButton, blockValue);
		}
		return lineColorButton;
	}

	/**
	 * Answer the selection border width slider.
	 * 
	 * @return javax.swing.JSlider
	 * @category user interface
	 */
	protected JSlider lineWidthSlider() {
		if (lineWidthSlider == null) {
			lineWidthSlider = new JSlider(JSlider.HORIZONTAL, 1, 5, 1) {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(lineWidthSlider)).release();
					super.removeNotify();
				}
			};
			lineWidthSlider.setMajorTickSpacing(1);
			lineWidthSlider.setPaintTicks(true);
			lineWidthSlider.setSnapToTicks(true);
			lineWidthSlider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					int value = lineWidthSlider.getValue();
					getElementalArcSettings().lineWidthHolder().value_(new Integer(value));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					int value = ((Number) anObject).intValue();
					if (value != lineWidthSlider.getValue()) {
						lineWidthSlider.setValue(value);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lineWidthHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lineWidthSlider, blockValue);
		}
		return lineWidthSlider;
	}

	/**
	 * Answer the first box color button.
	 * 
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton firstBoxColorButton() {
		if (firstBoxColorButton == null) {
			firstBoxColorButton = new JButton() {
				public void paint(Graphics g) {
					super.paint(g);

					Dimension size = this.getSize();
					int x = (size.width - ButtonColorImageSize.width) / 2;
					int y = (size.height - ButtonColorImageSize.height) / 2;
					g.setColor((Color) getElementalArcSettings().firstBoxColorHolder().value());
					g.fillRect(x, y, ButtonColorImageSize.width, ButtonColorImageSize.height);
				}

				public void removeNotify() {
					((StBlockValue) _blockValues.get(firstBoxColorButton)).release();
					super.removeNotify();
				}
			};
			firstBoxColorButton.setAction(new AbstractAction() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().firstBoxColorButtonPressed();
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					firstBoxColorButton.repaint();
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstBoxColorHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstBoxColorButton, blockValue);
		}
		return firstBoxColorButton;
	}

	/**
	 * Answer the last box color button.
	 * 
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton lastBoxColorButton() {
		if (lastBoxColorButton == null) {
			lastBoxColorButton = new JButton() {
				public void paint(Graphics g) {
					super.paint(g);

					Dimension size = this.getSize();
					int x = (size.width - ButtonColorImageSize.width) / 2;
					int y = (size.height - ButtonColorImageSize.height) / 2;
					g.setColor((Color) getElementalArcSettings().lastBoxColorHolder().value());
					g.fillRect(x, y, ButtonColorImageSize.width, ButtonColorImageSize.height);
				}

				public void removeNotify() {
					((StBlockValue) _blockValues.get(lastBoxColorButton)).release();
					super.removeNotify();
				}
			};
			lastBoxColorButton.setAction(new AbstractAction() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().lastBoxColorButtonPressed();
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					lastBoxColorButton.repaint();
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastBoxColorHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastBoxColorButton, blockValue);
		}
		return lastBoxColorButton;
	}

	/**
	 * Answer the first top left button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton firstTopLeftButton() {
		if (firstTopLeftButton == null) {
			firstTopLeftButton = new JRadioButton();
			firstTopLeftButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("topLeft"));
				}
			});
			_firstPointAlignmentButtonGroup.add(firstTopLeftButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("topLeft") && firstTopLeftButton.isSelected() == false) {
						firstTopLeftButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstTopLeftButton, blockValue);
		}
		return firstTopLeftButton;
	}

	/**
	 * Answer the first top center button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton firstTopCenterButton() {
		if (firstTopCenterButton == null) {
			firstTopCenterButton = new JRadioButton();
			firstTopCenterButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("topCenter"));
				}
			});
			_firstPointAlignmentButtonGroup.add(firstTopCenterButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("topCenter") && firstTopCenterButton.isSelected() == false) {
						firstTopCenterButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstTopCenterButton, blockValue);
		}
		return firstTopCenterButton;
	}

	/**
	 * Answer the first top center button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton firstTopRightButton() {
		if (firstTopRightButton == null) {
			firstTopRightButton = new JRadioButton();
			firstTopRightButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("topRight"));
				}
			});
			_firstPointAlignmentButtonGroup.add(firstTopRightButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("topRight") && firstTopRightButton.isSelected() == false) {
						firstTopRightButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstTopRightButton, blockValue);
		}
		return firstTopRightButton;
	}

	/**
	 * Answer the first left button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton firstLeftButton() {
		if (firstLeftButton == null) {
			firstLeftButton = new JRadioButton();
			firstLeftButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("leftCenter"));
				}
			});
			_firstPointAlignmentButtonGroup.add(firstLeftButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("leftCenter") && firstLeftButton.isSelected() == false) {
						firstLeftButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstLeftButton, blockValue);
		}
		return firstLeftButton;
	}

	/**
	 * Answer the first center button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton firstCenterButton() {
		if (firstCenterButton == null) {
			firstCenterButton = new JRadioButton();
			firstCenterButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("center"));
				}
			});
			_firstPointAlignmentButtonGroup.add(firstCenterButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("center") && firstCenterButton.isSelected() == false) {
						firstCenterButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstCenterButton, blockValue);
		}
		return firstCenterButton;
	}

	/**
	 * Answer the first right button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton firstRightButton() {
		if (firstRightButton == null) {
			firstRightButton = new JRadioButton();
			firstRightButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("rightCenter"));
				}
			});
			_firstPointAlignmentButtonGroup.add(firstRightButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("rightCenter") && firstRightButton.isSelected() == false) {
						firstRightButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstRightButton, blockValue);
		}
		return firstRightButton;
	}

	/**
	 * Answer the first bottom left button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton firstBottomLeftButton() {
		if (firstBottomLeftButton == null) {
			firstBottomLeftButton = new JRadioButton();
			firstBottomLeftButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("bottomLeft"));
				}
			});
			_firstPointAlignmentButtonGroup.add(firstBottomLeftButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("bottomLeft") && firstBottomLeftButton.isSelected() == false) {
						firstBottomLeftButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstBottomLeftButton, blockValue);
		}
		return firstBottomLeftButton;
	}

	/**
	 * Answer the first bottom center button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton firstBottomCenterButton() {
		if (firstBottomCenterButton == null) {
			firstBottomCenterButton = new JRadioButton();
			firstBottomCenterButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("bottomCenter"));
				}
			});
			_firstPointAlignmentButtonGroup.add(firstBottomCenterButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("bottomCenter") && firstBottomCenterButton.isSelected() == false) {
						firstBottomCenterButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstBottomCenterButton, blockValue);
		}
		return firstBottomCenterButton;
	}

	/**
	 * Answer the first bottom center button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton firstBottomRightButton() {
		if (firstBottomRightButton == null) {
			firstBottomRightButton = new JRadioButton();
			firstBottomRightButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("bottomRight"));
				}
			});
			_firstPointAlignmentButtonGroup.add(firstBottomRightButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("bottomRight") && firstBottomRightButton.isSelected() == false) {
						firstBottomRightButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstBottomRightButton, blockValue);
		}
		return firstBottomRightButton;
	}

	/**
	 * Answer the last top left button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton lastTopLeftButton() {
		if (lastTopLeftButton == null) {
			lastTopLeftButton = new JRadioButton();
			lastTopLeftButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("topLeft"));
				}
			});
			_lastPointAlignmentButtonGroup.add(lastTopLeftButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("topLeft") && lastTopLeftButton.isSelected() == false) {
						lastTopLeftButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastTopLeftButton, blockValue);
		}
		return lastTopLeftButton;
	}

	/**
	 * Answer the last top center button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton lastTopCenterButton() {
		if (lastTopCenterButton == null) {
			lastTopCenterButton = new JRadioButton();
			lastTopCenterButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("topCenter"));
				}
			});
			_lastPointAlignmentButtonGroup.add(lastTopCenterButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("topCenter") && lastTopCenterButton.isSelected() == false) {
						lastTopCenterButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastTopCenterButton, blockValue);
		}
		return lastTopCenterButton;
	}

	/**
	 * Answer the last top center button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton lastTopRightButton() {
		if (lastTopRightButton == null) {
			lastTopRightButton = new JRadioButton();
			lastTopRightButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("topRight"));
				}
			});
			_lastPointAlignmentButtonGroup.add(lastTopRightButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("topRight") && lastTopRightButton.isSelected() == false) {
						lastTopRightButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastTopRightButton, blockValue);
		}
		return lastTopRightButton;
	}

	/**
	 * Answer the last left button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton lastLeftButton() {
		if (lastLeftButton == null) {
			lastLeftButton = new JRadioButton();
			lastLeftButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("leftCenter"));
				}
			});
			_lastPointAlignmentButtonGroup.add(lastLeftButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("leftCenter") && lastLeftButton.isSelected() == false) {
						lastLeftButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastLeftButton, blockValue);
		}
		return lastLeftButton;
	}

	/**
	 * Answer the last center button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton lastCenterButton() {
		if (lastCenterButton == null) {
			lastCenterButton = new JRadioButton();
			lastCenterButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("center"));
				}
			});
			_lastPointAlignmentButtonGroup.add(lastCenterButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("center") && lastCenterButton.isSelected() == false) {
						lastCenterButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastCenterButton, blockValue);
		}
		return lastCenterButton;
	}

	/**
	 * Answer the last right button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton lastRightButton() {
		if (lastRightButton == null) {
			lastRightButton = new JRadioButton();
			lastRightButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("rightCenter"));
				}
			});
			_lastPointAlignmentButtonGroup.add(lastRightButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("rightCenter") && lastRightButton.isSelected() == false) {
						lastRightButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastRightButton, blockValue);
		}
		return lastRightButton;
	}

	/**
	 * Answer the last bottom left button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton lastBottomLeftButton() {
		if (lastBottomLeftButton == null) {
			lastBottomLeftButton = new JRadioButton();
			lastBottomLeftButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("bottomLeft"));
				}
			});
			_lastPointAlignmentButtonGroup.add(lastBottomLeftButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("bottomLeft") && lastBottomLeftButton.isSelected() == false) {
						lastBottomLeftButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastBottomLeftButton, blockValue);
		}
		return lastBottomLeftButton;
	}

	/**
	 * Answer the last bottom center button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton lastBottomCenterButton() {
		if (lastBottomCenterButton == null) {
			lastBottomCenterButton = new JRadioButton();
			lastBottomCenterButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("bottomCenter"));
				}
			});
			_lastPointAlignmentButtonGroup.add(lastBottomCenterButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("bottomCenter") && lastBottomCenterButton.isSelected() == false) {
						lastBottomCenterButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastBottomCenterButton, blockValue);
		}
		return lastBottomCenterButton;
	}

	/**
	 * Answer the last bottom center button.
	 * 
	 * @return javax.swing.JRadioButton
	 * @category user interface
	 */
	protected JRadioButton lastBottomRightButton() {
		if (lastBottomRightButton == null) {
			lastBottomRightButton = new JRadioButton();
			lastBottomRightButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("bottomRight"));
				}
			});
			_lastPointAlignmentButtonGroup.add(lastBottomRightButton);

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("bottomRight") && lastBottomRightButton.isSelected() == false) {
						lastBottomRightButton.setSelected(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastBottomRightButton, blockValue);
		}
		return lastBottomRightButton;
	}

	/**
	 * Answer the all defaults button.
	 * 
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton allDefaultsButton() {
		if (allDefaultsButton == null) {
			allDefaultsButton = new JButton(new AbstractAction($String("Default")) {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().defaultButtonPressed();
				}
			});
		}
		return allDefaultsButton;
	}

	/**
	 * Update for the change notice from the model.
	 * 
	 * @param e jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent e) {
		if (e.getAspect() == $("widgets")) {
			Iterator i = _blockValues.values().iterator();
			while (i.hasNext()) {
				((StBlockValue) i.next()).computeValue();
			}
		} else {
			super.update_(e);
		}
	}

}
