package jp.co.sra.jun.topology.graph;

import java.awt.Color;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunElementalArcSettingsTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/04/20 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun593 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunElementalArcSettingsTestExamples.java,v 8.11 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunElementalArcSettingsTestExamples extends JunTestExamples {

	/**
	 * Example0: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example0() {
		JunElementalArcSettings settings = new JunElementalArcSettings();
		settings.compute_(new StBlockClosure() {
			public Object value_value_(Object table, Object stuff) {
				System.out.println(table.toString() + " " + stuff);
				return null;
			}
		});
		settings.open();

		return true;
	}

	/**
	 * Example1: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunElementalArc arc = new JunElementalArc();
		arc.lineColor_(Color.red);
		arc.lineWidth_(3);
		arc.firstBoxColor_(Color.green);
		arc.lastBoxColor_(Color.blue);
		arc.firstPointAlignment_($("leftCenter"));
		arc.lastPointAlignment_($("rightCenter"));

		JunElementalArcSettings settings = new JunElementalArcSettings(arc);
		settings.compute_(new StBlockClosure() {
			public Object value_value_(Object table, Object stuff) {
				System.out.println(table.toString() + " " + stuff);
				return null;
			}
		});
		settings.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunElementalArcSettingsTestExamples();
	}

}
