package jp.co.sra.jun.topology.globaloperators;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.system.support.*;
import jp.co.sra.jun.topology.elements.*;
import jp.co.sra.jun.topology.euleroperators.*;

/**
 * JunSEPARATETestExamples class
 * 
 *  @author    UNKNOWN
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSEPARATETestExamples.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunSEPARATETestExamples extends JunTestExamples {

	/**
	 * JunSEPARATE example1.
	 * 
	 * @return boolean.
	 */
	public static boolean Example1() {
		Jun3dPoint point1 = new Jun3dPoint(0, 0, 0);
		Jun3dPoint point2 = new Jun3dPoint(-1, -1, -1);
		Jun3dPoint point3 = new Jun3dPoint(1, 1, 1);
		JunBody body1 = JunBody.GlobeLatitudes_longitudes_center_radius_(9, 18, point1, 1.5);
		JunBody body2 = JunBody.CubeOrigin_corner_(point2, point3);
		JunADD add = new JunADD(body1, body2);
		add.doOperation();

		JunSEPARATE separate = new JunSEPARATE(body1, body2);
		separate.doOperation();
		separate.body().show();

		return true;
	}

	/**
	 * JunSEPARATE example2.
	 * 
	 * @return boolean.
	 */
	public static boolean Example2() {
		Jun3dPoint point1 = new Jun3dPoint(0, 0, 0);
		Jun3dPoint point2 = new Jun3dPoint(-1, -1, -1);
		Jun3dPoint point3 = new Jun3dPoint(1, 1, 1);
		JunBody body1 = JunBody.GlobeLatitudes_longitudes_center_radius_(9, 18, point1, 1.5);
		JunBody body2 = JunBody.CubeOrigin_corner_(point2, point3);
		JunADD add = new JunADD(body1, body2);
		add.doOperation();

		JunSEPARATE separate = new JunSEPARATE(body1, body2);
		separate.doOperation();
		separate.inverse().doOperation();
		separate.body().show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new JunSEPARATETestExamples();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean ManualExample1() {
		JunBody body1 = new JunBody();

		JunMEVVL mevvl = JunMEVVL.Body_point_point_(body1, new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 0, 1));
		mevvl.doOperation();

		JunLoop loop1 = mevvl.loop();
		JunVertex vertex100 = mevvl.newVertex1();
		JunVertex vertex001 = mevvl.newVertex2();

		JunMEV mev = JunMEV.Body_vertex_loop_point_(body1, vertex100, loop1, new Jun3dPoint(0, 0, 0));
		mev.doOperation();

		JunVertex vertex000 = mev.newVertex();

		JunMEL mel = JunMEL.Body_loop_vertex_vertex_(body1, loop1, vertex001, vertex000);
		mel.doOperation();

		JunBody body2 = new JunBody();

		mevvl = JunMEVVL.Body_point_point_(body2, new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 0, 1));
		mevvl.doOperation();

		JunLoop loop2 = mevvl.loop();
		JunVertex vertex010 = mevvl.newVertex1();
		vertex001 = mevvl.newVertex2();

		mev = JunMEV.Body_vertex_loop_point_(body2, vertex010, loop2, new Jun3dPoint(0, 0, 0));
		mev.doOperation();
		vertex000 = mev.newVertex();

		mel = JunMEL.Body_loop_vertex_vertex_(body2, loop2, vertex001, vertex000);
		mel.doOperation();

		JunADD add = JunADD.Body_body_(body1, body2);
		add.doOperation();

		body1.show();

		JunSEPARATE separate = JunSEPARATE.Body_body_(body1, body2);
		separate.doOperation();
		body1.show();
		body2.show();

		System.out.println("-------- body2");
		System.out.println(separate.body2());

		return true;
	}
}
