package jp.co.sra.jun.topology.globaloperators;

import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunSEPARATE class
 * 
 *  @author    nisinaka
 *  @created   1998/11/xx (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSEPARATE.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunSEPARATE extends JunGlobalOperator {
	/** Another body to separate. */
	protected JunBody body2 = null;

	/**
	 * Create a new instance of JunSEPARATE and initialize it with two bodies.
	 * 
	 * @param aBody1 jp.co.sra.jun.topology.elements.JunBody
	 * @param aBody2 jp.co.sra.jun.topology.elements.JunBody
	 */
	public JunSEPARATE(JunBody aBody1, JunBody aBody2) {
		this.body_(aBody1);
		this.body2_(aBody2);
	}

	/**
	 * Create an JunSEPARATE operator with two bodies.
	 * 
	 * @param aBody1 jp.co.sra.jun.topology.elements.JunBody
	 * @param aBody2 jp.co.sra.jun.topology.elements.JunBody
	 * 
	 * @return jp.co.sra.jun.topology.globaloperators.JunSEPARATE
	 */
	public static final JunSEPARATE Body_body_(JunBody aBody1, JunBody aBody2) {
		return new JunSEPARATE(aBody1, aBody2);
	}

	/**
	 * Answer another body.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunBody
	 */
	public JunBody body2() {
		return body2;
	}

	/**
	 * Set another body.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 */
	public void body2_(JunBody aBody) {
		body2 = aBody;
	}

	/**
	 * Execute the receiver.
	 */
	public void execute() {
		JunLoopProxy[] loopProxies = body2.loopProxies();

		for (int i = 0; i < loopProxies.length; i++) {
			JunLoopProxy proxy = loopProxies[i];
			JunLoop loop = this.body().loopAt_(proxy);
			body2.addLoop_as_(loop, proxy);
			body.removeLoop_(loop);
		}

		JunEdgeProxy[] edgeProxies = body2.edgeProxies();

		for (int i = 0; i < edgeProxies.length; i++) {
			JunEdgeProxy proxy = edgeProxies[i];
			JunEdge edge = this.body().edgeAt_(proxy);
			body2.addEdge_as_(edge, proxy);
			body.removeEdge_(edge);
		}

		JunVertexProxy[] vertexProxies = body2.vertexProxies();

		for (int i = 0; i < vertexProxies.length; i++) {
			JunVertexProxy proxy = vertexProxies[i];
			JunVertex vertex = this.body().vertexAt_(proxy);
			body2.addVertex_as_(vertex, proxy);
			body.removeVertex_(vertex);
		}
	}

	/**
	 * Answer the inverse operator of the receiver.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return new JunADD(this.body(), this.body2());
	}
}
