package jp.co.sra.jun.topology.globaloperators;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.geometry.abstracts.JunCurve;
import jp.co.sra.jun.geometry.abstracts.JunSurface;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.Jun3dPolygon;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.topology.abstracts.JunAbstractOperator;
import jp.co.sra.jun.topology.abstracts.JunGlobalOperator;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.jun.topology.elements.JunEdge;
import jp.co.sra.jun.topology.elements.JunLoop;
import jp.co.sra.jun.topology.elements.JunVertex;
import jp.co.sra.jun.topology.support.JunGeometryTransformer;

/**
 * JunMIRROR class
 * 
 *  @author    UNKNOWN
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMIRROR.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunMIRROR extends JunGlobalOperator {
	Jun3dPoint point;
	Jun3dPoint vector;

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aJunBody DOCUMENT ME!
	 * @param aJun3dPoint1 DOCUMENT ME!
	 * @param aJun3dPoint2 DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static final JunMIRROR Body_point_vector_(JunBody aJunBody, Jun3dPoint aJun3dPoint1, Jun3dPoint aJun3dPoint2) {
		JunMIRROR anOperator;

		anOperator = new JunMIRROR();
		anOperator.body_(aJunBody);
		anOperator.point_(aJun3dPoint1);
		anOperator.vector_(aJun3dPoint2);

		return anOperator;
	}

	/**
	 * Execute the operation.
	 */
	public void execute() {
		final JunBody body_ = this.body();
		final JunPlane mirrorPlane = this.mirrorPlane();
		final Jun3dPoint normalVector;
		final JunGeometryTransformer transformer;
		normalVector = (Jun3dPoint) (this.vector().unitVector());
		transformer = JunGeometryTransformer.Block_(new StBlockClosure() {
			public Object value_(Object anObject) {
				Jun3dPoint p = (Jun3dPoint) anObject;
				double distance = mirrorPlane.distanceFromPoint_(p);
				Jun3dPoint mirrorVector = (Jun3dPoint) (normalVector.multipliedBy_(distance).multipliedBy_(2));
				Jun3dPoint mirrorPoint1 = (Jun3dPoint) (p.plus_(mirrorVector));
				Jun3dPoint mirrorPoint2 = (Jun3dPoint) (p.minus_(mirrorVector));

				if (mirrorPlane.distanceFromPoint_(mirrorPoint1) < mirrorPlane.distanceFromPoint_(mirrorPoint2)) {
					return mirrorPoint1;
				} else {
					return mirrorPoint2;
				}
			}
		});
		body_.vertexesDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunVertex vertex = (JunVertex) anObject;

				if (vertex.point() != null) {
					vertex.point_((Jun3dPoint) vertex.point().transform_(transformer));
				}

				return null;
			}
		});
		body_.edgesDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunEdge edge = (JunEdge) anObject;
				Jun3dLine curve = (Jun3dLine) (edge.basicCurve());

				if (curve != null) {
					edge.setCurve_((JunCurve) (curve.transform_(transformer)));
				}

				return null;
			}
		});
		body_.loopsDo_(new StBlockClosure() {
			public Object value_(Object loop) {
				Jun3dPolygon surface = (Jun3dPolygon) (((JunLoop) loop).basicSurface());

				if (surface != null) {
					((JunLoop) loop).setSurface_((JunSurface) surface.transform_(transformer));
				}

				return null;
			}
		});
		(new JunNEGATE(body_)).doOperation();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunMIRROR.Body_point_vector_(this.body(), this.point(), this.vector()));
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPlane mirrorPlane() {
		return JunPlane.On_vertical_(this.point(), new Jun3dLine(Jun3dPoint.Zero(), this.vector()));
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public Jun3dPoint point() {
		return this.point;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aJun3dPoint DOCUMENT ME!
	 */
	public void point_(Jun3dPoint aJun3dPoint) {
		this.point = aJun3dPoint;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public Jun3dPoint vector() {
		return this.vector;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aJun3dPoint DOCUMENT ME!
	 */
	public void vector_(Jun3dPoint aJun3dPoint) {
		vector = aJun3dPoint;
	}
}
