package jp.co.sra.jun.topology.geometricoperators;

/*
 * @(#)JunMSF.java        1.0 98/9/17
 */
import jp.co.sra.jun.geometry.abstracts.JunSurface;
import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunMSF class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMSF.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunMSF extends JunGeometricOperator {
	/** The topology on which the receiver operates. */
	protected JunLoopProxy loopProxy;

	/** The geometry which corresponds to the receiver's topology. */
	protected JunSurface surface;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aSurface DOCUMENT ME!
	 * 
	 * @return jp.co.sra.jun.topology.geometricoperators.JunKSF
	 */
	public static final JunMSF Body_loop_surface_(JunBody aBody, JunTopologicalElementOrProxy aLoopOrProxy, JunSurface aSurface) {
		JunMSF anOperator = new JunMSF();
		anOperator.body_(aBody);
		anOperator.loop_(aLoopOrProxy);
		anOperator.surface_(aSurface);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		this.loop().surface_(this.surface());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunKSF.Body_loop_(this.body(), loopProxy));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.geometry.abstracts.JunLoop
	 */
	public JunLoop loop() {
		return (JunLoop) this.getTopologicalElement_(loopProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop_(JunTopologicalElementOrProxy aLoopOrProxy) {
		loopProxy = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aLoopOrProxy, loopProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		JunLoop loop = this.loop();

		if (loop == null) {
			return false;
		}

		if (loop.basicSurface() != null) {
			return false;
		}

		return super.precondition();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.geometry.abstracts.JunSurface
	 */
	public JunSurface surface() {
		return surface;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aSurface jp.co.sra.jun.geometry.abstracts.JunSurface
	 */
	public void surface_(JunSurface aSurface) {
		surface = aSurface;
	}
}
