package jp.co.sra.jun.topology.geometricoperators;

/*
 * @(#)JunKSF.java        1.0 98/9/17
 */
import jp.co.sra.jun.geometry.abstracts.JunSurface;
import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunKSF class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKSF.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunKSF extends JunGeometricOperator {
	/** The topology on which the receiver operates. */
	protected JunLoopProxy loopProxy;

	/** The geometry which corresponds to the receiver's topology. */
	protected JunSurface surface;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.geometricoperators.JunKSF
	 */
	public static final JunKSF Body_loop_(JunBody aBody, JunTopologicalElementOrProxy aLoopOrProxy) {
		JunKSF anOperator = new JunKSF();
		anOperator.body_(aBody);
		anOperator.loop_(aLoopOrProxy);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		this.surface_(this.loop().basicSurface());
		this.loop().surface_(null);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunMSF.Body_loop_surface_(this.body(), loopProxy, this.surface()));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.geometry.abstracts.JunLoop
	 */
	public JunLoop loop() {
		return (JunLoop) this.getTopologicalElement_(loopProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop_(JunTopologicalElementOrProxy aLoopOrProxy) {
		loopProxy = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aLoopOrProxy, loopProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		JunLoop loop = this.loop();

		if (loop == null) {
			return false;
		}

		if (loop.basicSurface() == null) {
			return false;
		}

		return super.precondition();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.geometry.abstracts.JunSurface
	 */
	public JunSurface surface() {
		return surface;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aSurface jp.co.sra.jun.geometry.abstracts.JunSurface
	 */
	public void surface_(JunSurface aSurface) {
		surface = aSurface;
	}
}
