package jp.co.sra.jun.topology.geometricoperators;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.JunNurbsCurve;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.jun.topology.elements.*;
import jp.co.sra.jun.topology.euleroperators.*;

/**
 * JunKCVTestExamples class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   1999/04/16 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKCVTestExamples.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunKCVTestExamples extends JunTestExamples {

	/**
	 * JunKCV example1.
	 * 
	 * @return boolean.
	 */
	public static boolean Example1() {
		JunBody body;
		JunMEVVL mevvl;
		JunEdge edge;
		JunMEL mel;
		JunMVE mve;
		JunKCV kcv;

		//
		body = new JunBody();
		mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 0, 0));
		mevvl.doOperation();
		edge = mevvl.edge();
		mel = JunMEL.Body_loop_vertex_vertex_(body, mevvl.loop(), mevvl.vertex1(), mevvl.vertex2());
		mel.doOperation();
		mve = JunMVE.Body_edge_point_(body, mel.newEdge(), new Jun3dPoint(0, -1, 0));
		mve.doOperation();

		JunNurbsCurve curve = JunNurbsCurve.BezierControlPoints_(new Jun3dPoint[] { new Jun3dPoint(0, 0, 0), new Jun3dPoint(0.5, 0, 0.5), new Jun3dPoint(1, 0, 0)});
		JunMCV mcv = JunMCV.Body_edge_curve_(body, edge, curve);
		mcv.doOperation();
		body.asWireframedOpenGL3dObject().show();
		kcv = JunKCV.Body_edge_(body, edge);
		kcv.doOperation();
		body.asWireframedOpenGL3dObject().show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunKCVTestExamples();
	}

	/**
	 * The example on JunKCV.htm
	 * 
	 * @return boolean.
	 */
	public static boolean ManualExample1() {
		JunBody body = new JunBody();
		JunMEVVL mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		mevvl.doOperation();

		JunLoop loop = mevvl.newLoop();
		JunEdge edge = mevvl.newEdge();
		JunVertex vertex100 = mevvl.newVertex1();
		JunVertex vertex010 = mevvl.newVertex2();

		//
		JunMEV mev = JunMEV.Body_vertex_loop_point_(body, vertex100, loop, new Jun3dPoint(0, 0, 0));
		mev.doOperation();

		JunVertex vertex000 = mev.newVertex();

		//
		JunMEL mel = JunMEL.Body_loop_vertex_vertex_(body, loop, vertex010, vertex000);
		mel.doOperation();

		//
		Jun3dPoint[] controlPoints = new Jun3dPoint[] { new Jun3dPoint(1, 0, 0), new Jun3dPoint(0.5, 0.5, -0.5), new Jun3dPoint(0, 1, 0)};
		JunNurbsCurve curve = JunNurbsCurve.BezierControlPoints_(controlPoints);
		JunMCV mcv = JunMCV.Body_edge_curve_(body, edge, curve);
		mcv.doOperation();

		//
		body.show();

		JunKCV kcv = JunKCV.Body_edge_(body, edge);
		kcv.doOperation();
		body.show();

		//
		System.out.println("-------- #curve");
		System.out.println(kcv.curve());
		System.out.println("-------- #edge");
		System.out.println(kcv.edge());

		//
		return true;
	}
}
