package jp.co.sra.jun.topology.euleroperators;

import java.util.Vector;
import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunMDEV class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMDEV.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunMDEV extends JunEulerOperator {
	protected JunEdgeProxy edgeProxy1;
	protected JunVertexProxy vertexProxy1;
	protected JunVertexProxy vertexProxy2;
	protected JunEdgeProxy edgeProxy2;
	protected JunEdgeProxy edgeProxy3;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy3
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunMDEV
	 */
	public static final JunMDEV Body_vertex_edge_edge_(JunBody aBody, JunTopologicalElementOrProxy aJunVertexOrProxy, JunTopologicalElementOrProxy aJunEdgeOrProxy2, JunTopologicalElementOrProxy aJunEdgeOrProxy3) {
		JunMDEV anOperator;
		anOperator = new JunMDEV();
		anOperator.body_(aBody);
		anOperator.vertex2_(aJunVertexOrProxy);
		anOperator.edge2_(aJunEdgeOrProxy2);
		anOperator.edge3_(aJunEdgeOrProxy3);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy3
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunMDEV
	 */
	public static final JunMDEV Body_vertex_edge_edge_adviseEdge_vertex_(
		JunBody aJunBody,
		JunTopologicalElementOrProxy aJunVertexOrProxy,
		JunTopologicalElementOrProxy aJunEdgeOrProxy2,
		JunTopologicalElementOrProxy aJunEdgeOrProxy3,
		JunTopologicalElementOrProxy aJunEdgeOrProxy,
		JunTopologicalElementOrProxy aJunVertexOrProxy2) {
		JunMDEV anOperator;
		anOperator = new JunMDEV();
		anOperator.body_(aJunBody);
		anOperator.vertex2_(aJunVertexOrProxy);
		anOperator.edge2_(aJunEdgeOrProxy2);
		anOperator.edge3_(aJunEdgeOrProxy3);
		anOperator.vertex1_(aJunVertexOrProxy2);
		anOperator.edge1_(aJunEdgeOrProxy);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge1() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge1_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy1 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge2() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge2_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy2 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge3() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy3);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge3_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy3 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy3);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		Vector v1Edges = new Vector();
		Vector v2Edges = new Vector();
		JunEdge currentEdge;
		JunEdge targetEdge;
		JunEdge nextEdge;
		this.vertex1_(JunVertex.Point_(this.vertex2().point()));
		this.edge1_(JunEdge.StartVertex_endVertex_(this.vertex1(), this.vertex2()));
		this.vertex1().edge_(this.edge1());
		v1Edges.addElement(this.edge2());
		currentEdge = this.edge2();
		targetEdge = this.edge3();
		nextEdge = currentEdge.nextEdgeWithVertex_(this.vertex2());

		while (nextEdge != targetEdge) {
			currentEdge = nextEdge;
			v1Edges.addElement(currentEdge);
			nextEdge = currentEdge.nextEdgeWithVertex_(this.vertex2());
		}

		v2Edges.addElement(this.edge3());
		currentEdge = this.edge3();
		targetEdge = this.edge2();
		nextEdge = currentEdge.nextEdgeWithVertex_(this.vertex2());

		while (nextEdge != targetEdge) {
			currentEdge = nextEdge;
			v2Edges.addElement(currentEdge);
			nextEdge = currentEdge.nextEdgeWithVertex_(this.vertex2());
		}

		if ((v1Edges.size() + v2Edges.size()) != this.vertex2().numberOfEdges()) {
			this.error_("MDEV internal error.");
		}

		this.edge1().setLoop_fromVertex_(this.edge2().loopFromVertex_(this.vertex2()), this.vertex1());
		this.edge1().setLoop_fromVertex_(this.edge3().loopFromVertex_(this.vertex2()), this.vertex2());
		((JunEdge) (v1Edges.lastElement())).setNextEdge_withVertex_(this.edge1(), this.vertex2());
		this.edge1().setNextEdge_withVertex_((JunEdge) (v2Edges.firstElement()), this.vertex2());
		((JunEdge) (v2Edges.lastElement())).setNextEdge_withVertex_(this.edge1(), this.vertex2());
		this.edge1().setNextEdge_withVertex_((JunEdge) (v1Edges.firstElement()), this.vertex1());

		for (int i = 0; i < v1Edges.size(); i++) {
			JunEdge edge = (JunEdge) (v1Edges.elementAt(i));
			edge.setVertex_insteadOf_(this.vertex1(), this.vertex2());
		}

		if (this.vertex2().edge().includesVertex_(this.vertex2()) == false) {
			this.vertex2().edge_((JunEdge) (v2Edges.firstElement()));
		}

		this.body().addVertex_(this.vertex1());
		this.body().addEdge_(this.edge1());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunKDEV.Body_edge_adviseVertex_vertex_edge_edge_(this.body(), this.edgeProxy1, this.vertexProxy1, this.vertexProxy2, this.edgeProxy2, this.edgeProxy3));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge newEdge() {
		return this.edge1();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex newVertex() {
		return this.vertex1();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		JunVertex vertex2;
		JunEdge edge2;
		JunEdge edge3;

		if (this.vertex1() != null) {
			return false;
		}

		if (this.edge1() != null) {
			return false;
		}

		vertex2 = this.vertex2();

		if (vertex2 == null) {
			return false;
		}

		edge2 = this.edge2();

		if (edge2 == null) {
			return false;
		}

		edge3 = this.edge3();

		if (edge3 == null) {
			return false;
		}

		return (super.precondition() && edge2.includesVertex_(vertex2) && edge3.includesVertex_(vertex2));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex1() {
		return (JunVertex) this.getTopologicalElement_(vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex1_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy1 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex2() {
		return (JunVertex) this.getTopologicalElement_(vertexProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex2_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy2 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy2);
	}
}
