package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunKVE class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKVE.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunKVE extends JunEulerOperator {
	protected JunVertexProxy vertexProxy;
	protected JunVertexProxy vertexProxy1;
	protected JunEdgeProxy edgeProxy1;
	protected JunEdgeProxy edgeProxy2;
	protected Jun3dPoint point;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKVE
	 */
	public static final JunKVE Body_vertex_(JunBody aBody, JunTopologicalElementOrProxy aJunVertexOrProxy) {
		JunKVE anOperator;
		anOperator = new JunKVE();
		anOperator.body_(aBody);
		anOperator.vertex_(aJunVertexOrProxy);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKVE
	 */
	public static final JunKVE Body_vertex_adviseEdge_edge_(JunBody aBody, JunTopologicalElementOrProxy aJunVertexOrProxy, JunTopologicalElementOrProxy aJunEdgeOrProxy1, JunTopologicalElementOrProxy aJunEdgeOrProxy2) {
		JunKVE anOperator;
		anOperator = new JunKVE();
		anOperator.body_(aBody);
		anOperator.vertex_(aJunVertexOrProxy);
		anOperator.edge1_(aJunEdgeOrProxy1);
		anOperator.edge2_(aJunEdgeOrProxy2);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKVE
	 */
	public static final JunKVE Body_vertex_killEdge_(JunBody aBody, JunTopologicalElementOrProxy aJunVertexOrProxy, JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		JunKVE anOperator;
		anOperator = new JunKVE();
		anOperator.body_(aBody);
		anOperator.vertex_(aJunVertexOrProxy);
		anOperator.edge1_(aJunEdgeOrProxy);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge aliveEdge() {
		return this.edge2();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge1() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge1_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy1 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge2() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge2_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy2 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		JunVertex oppositeVertex;
		JunEdge toEdge;
		JunEdge fromEdge;

		if (this.edge1() == null) {
			this.edge1_(this.vertex().edge());
		}

		if (this.edge2() == null) {
			this.edge2_(this.edge1().nextEdgeWithVertex_(this.vertex()));
		}

		point = this.vertex().point();
		oppositeVertex = this.edge1().oppositeVertexOfVertex_(this.vertex());
		this.vertex1_(oppositeVertex);
		toEdge = this.edge1().nextEdgeWithVertex_(oppositeVertex);
		fromEdge = this.edge1().prevEdgeWithVertex_(oppositeVertex);

		if (fromEdge == this.edge1()) {
			fromEdge = this.edge2();
		}

		this.edge2().setNextEdge_withVertex_(toEdge, this.vertex());
		this.edge2().setVertex_insteadOf_(oppositeVertex, this.vertex());
		fromEdge.setNextEdge_withVertex_(this.edge2(), oppositeVertex);

		if (oppositeVertex.edge() == this.edge1()) {
			oppositeVertex.edge_(this.edge2());
		}

		if (this.edge1().leftLoop().edge() == this.edge1()) {
			this.edge1().leftLoop().edge_(this.edge2());
		}

		if (this.edge1().rightLoop().edge() == this.edge1()) {
			this.edge1().rightLoop().edge_(this.edge2());
		}

		this.vertex().forget();
		this.edge1().forget();
		this.body().removeVertex_(this.vertex());
		this.body().removeEdge_(this.edge1());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunMVE.Body_edge_point_adviseVertex_edge_newEdgeOnVertex_(this.body(), this.edgeProxy2, this.point(), this.vertexProxy, this.edgeProxy1, this.vertexProxy1));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge killedEdge() {
		return this.edge1();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint point() {
		return this.point;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		JunVertex vertex;

		if (super.precondition() == false) {
			return false;
		}

		vertex = this.vertex();

		if (vertex == null) {
			return false;
		}

		JunEdge[] edges = vertex.edges();

		if (!(edges.length == 2)) {
			return false;
		}

		for (int i = 0; i < edges.length; i++) {
			JunEdge edge = edges[i];

			if (edge.oppositeVertexOfVertex_(vertex) == vertex) {
				return false;
			}
		}

		if ((this.edgeProxy1 != null && ((this.edge1() == null) || (this.edge1().isKilled()))) == true) {
			return false;
		}

		if ((this.edgeProxy2 != null && ((this.edge2() == null) || (this.edge2().isKilled()))) == true) {
			return false;
		}

		return true;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex1() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex1_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy1 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy1);
	}
}
