package jp.co.sra.jun.topology.abstracts;

/*
 * @(#)JunSetOperator.java 1.0 1998/9/24
 */
import java.util.Vector;
import jp.co.sra.jun.topology.compositeoperators.JunCompoundOperator;

/**
 * JunSetOperator class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSetOperator.java,v 8.10 2008/02/20 06:33:01 nisinaka Exp $
 */
public abstract class JunSetOperator extends JunAbstractOperator {
	/** ??? */
	protected Vector suboperators = null;

	/** Cached inverse operator. */
	protected JunAbstractOperator inverse = null;

	/**
	 * Answer the receiver's suboperators as an array of JunAbstractOperator.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator[]
	 */
	public JunAbstractOperator[] _suboperatorsAsArray() {
		if (suboperators == null) {
			return null;
		}

		JunAbstractOperator[] anArray = new JunAbstractOperator[suboperators.size()];
		suboperators.copyInto(anArray);

		return anArray;
	}

	/**
	 * Answer the inverse operator of the receiver.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		if (inverse == null) {
			inverse = JunCompoundOperator.Body_suboperators_(this.body(), this._suboperatorsAsArray()).inverse();
		}

		return inverse;
	}

	/**
	 * Answer true if the receiver can be inverted.
	 * 
	 * @return boolean
	 */
	public boolean isInversable() {
		return true;
	}

	/**
	 * Redo the operator.
	 */
	public void redo() {
		this.inverse().inverse().doOperation();
	}
}
