package jp.co.sra.jun.terrain.editor;

import java.awt.Rectangle;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.button.JunButtonViewAwt;
import jp.co.sra.jun.goodies.wheels.JunThumbWheelViewAwt;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewSwing;

/**
 * JunTerrainEditViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2002/04/05 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2007/08/28 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun519 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTerrainEditViewSwing.java,v 8.14 2008/02/20 06:33:00 nisinaka Exp $
 */
public class JunTerrainEditViewSwing extends JunOpenGLDisplayViewSwing implements JunTerrainEditView {

	/**
	 * Create a new instance of <code>JunTerrainEditViewSwing</code> and initialize it.
	 * 
	 * @param aTerrainEditModel jp.co.sra.jun.terrain.editor.JunTerrainEditModel
	 * @category Instance creation
	 */
	public JunTerrainEditViewSwing(JunTerrainEditModel aTerrainEditModel) {
		super(aTerrainEditModel);
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewAwt#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.createOpenGLDrawableOnBorderedPanel(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -20, 1f, -1));
		this.add(new JunButtonViewAwt(this.getTerrainEditModel().peakButton()), WindowSpecLayout.Position(1f, -19, 0f, 1, 1f, -1, 0f, 19));
		this.add(new JunButtonViewAwt(this.getTerrainEditModel().dragButton()), WindowSpecLayout.Position(1f, -19, 0f, 20, 1f, -1, 0f, 38));
		this.add(new JunButtonViewAwt(this.getTerrainEditModel().showButton()), WindowSpecLayout.Position(1f, -19, 0f, 39, 1f, -1, 0f, 57));
		this.add(new JunThumbWheelViewAwt(this.getTerrainEditModel().zThumbWheel()), WindowSpecLayout.Position(1f, -19, 0.5f, -61, 1f, -1, 0.5f, 61));
		this.setSize(300, 300);
	}

	/**
	 * Answer my model as JunTerrainEditModel.
	 * 
	 * @return jp.co.sra.jun.terrain.editor.JunTerrainEditModel
	 * @see jp.co.sra.jun.terrain.editor.JunTerrainEditView#getTerrainEditModel()
	 * @category model accessing
	 */
	public JunTerrainEditModel getTerrainEditModel() {
		return (JunTerrainEditModel) this.model();
	}

	/**
	 * Answer a default controller.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @see jp.co.sra.smalltalk.StViewPanel#defaultController()
	 * @category controller accessing
	 */
	protected StController defaultController() {
		return new JunTerrainEditController();
	}

	/**
	 * Answer the bounds of the canvas area.
	 * 
	 * @return java.awt.Rectangle
	 * @see jp.co.sra.jun.terrain.editor.JunTerrainEditView#boundsOfCanvas()
	 * @category bounds accessing
	 */
	public Rectangle boundsOfCanvas() {
		return this.getOpenGLDrawable().toComponent().getBounds();
	}

	/**
	 * Receive a change notice from an object of whom the receiver is a dependent.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.StViewPanel#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		if (this.isShowing() && evt.getAspect() == $("state")) {
			return;
		}

		super.update_(evt);
	}

}
