package jp.co.sra.jun.system.support;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.SystemResourceSupport;

import jp.co.sra.jun.goodies.display.JunDisplayModel;
import jp.co.sra.jun.goodies.display.JunDisplayViewAwt;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;

/**
 * JunLauncherViewAwt class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/11/11 (by MATSUDA Ryouichi)
 *  @updated   2002/11/21 (by nisinaka)
 *  @updated   2003/03/19 (by nisinaka)
 *  @updated   2003/03/20 (by Mitsuhiro Asada)
 *  @updated   2007/03/12 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLauncherViewAwt.java,v 8.12 2008/02/20 06:32:59 nisinaka Exp $
 */
public class JunLauncherViewAwt extends JunDisplayViewAwt implements JunLauncherView {

	/**
	 * Create a new instance of JunLauncherViewAwt and initialize it.
	 * 
	 * @param aLauncher jp.co.sra.jun.system.support.JunLauncher
	 * @category Instance creation
	 */
	public JunLauncherViewAwt(JunLauncher aLauncher) {
		super(aLauncher);
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.jun.goodies.display.JunDisplayViewAwt#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		super.buildComponent();

		this.canvas().setBackground(Color.white);
	}

	/**
	 * Open a banner.
	 *
	 * @param visual java.lang.Object
	 * @see jp.kidresearch.art.system.support.ArtLauncherView#_openBanner(java.lang.Object)
	 * @category utilities
	 */
	public void _openBanner(Object visual) {
		JunDisplayModel displayModel = new JunDisplayModel(visual);
		displayModel._isScrollable(false);
		JunDisplayViewAwt displayView = new JunDisplayViewAwt(displayModel);

		final Dialog aDialog = new Dialog(SystemResourceSupport.getFrame(), true);
		aDialog.setUndecorated(true);
		aDialog.setResizable(false);
		aDialog.add(displayView);
		aDialog.pack();

		displayView.canvasComponent().addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				synchronized (JunLauncherViewAwt.this) {
					if (aDialog.isShowing()) {
						aDialog.dispose();
					}
				}
			}
		});

		Thread aThread = new Thread() {
			public void run() {
				JunControlUtility.WaitForMilliseconds_(5000);
				synchronized (JunLauncherViewAwt.this) {
					if (aDialog.isShowing()) {
						aDialog.dispose();
					}
				}
			}
		};
		aThread.start();

		StApplicationModel._ShowAtCenterPoint(aDialog);
	}

	/**
	 * Open a dialog.
	 *
	 * @param title java.lang.String
	 * @param visual java.lang.Object
	 * @param size java.awt.Dimension
	 * @see jp.co.sra.jun.system.support.JunLauncherView#_openDialog_(java.lang.String, java.lang.Object, java.awt.Dimension)
	 * @category utilities
	 */
	public void _openDialog_(final String title, final Object visual, final Dimension size) {
		JunDisplayModel aModel = new JunDisplayModel(visual);
		aModel._isScrollable(false);
		JunDisplayViewAwt aComponent = new JunDisplayViewAwt(aModel);

		Frame aFrame = new Frame(title);
		aFrame.add(aComponent);
		aFrame.pack();
		aFrame.setResizable(false);
		if (size != null) {
			aFrame.setSize(size);
		}
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		aFrame.pack();

		StApplicationModel._ShowAtCenterPoint(aFrame);
	}

	/**
	 * Open a text viewer.
	 *
	 * @param title java.lang.String
	 * @param message java.lang.String 
	 * @param size java.awt.Dimension
	 * @see jp.co.sra.jun.system.support.JunLauncherView#_openTextViewer_(java.lang.String, java.lang.String, java.awt.Dimension)
	 * @category utilities
	 */
	public void _openTextViewer_(final String title, final String message, final Dimension size) {
		TextArea aTextArea = new TextArea(message, 0, 0, TextArea.SCROLLBARS_VERTICAL_ONLY) {
			public Dimension getPreferredSize() {
				return size;
			}
		};
		aTextArea.setFont(new Font("Monospaced", Font.PLAIN, 12));
		aTextArea.setBackground(Color.white);
		aTextArea.setEditable(false);

		Frame aFrame = new Frame(title);
		aFrame.add(aTextArea);
		aFrame.pack();
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});

		StApplicationModel._ShowAtCenterPoint(aFrame);
	}

}
