package jp.co.sra.jun.system.support;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

import javax.swing.UIManager;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StInputState;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StUserMessage;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

import jp.co.sra.gl4jun.GLjRenderingMode;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.goodies.display.JunDisplayModel;
import jp.co.sra.jun.goodies.lisp.JunLispInterpreter;
import jp.co.sra.jun.goodies.prolog.JunPrologInterpreter;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.grapher.JunOpenGL3dGrapher;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.support.JunOpenGLResource;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.topology.grapher.JunGrapher;

/**
 * JunLauncher class
 * 
 *  @author    nisinaka
 *  @created   1998/11/16 (by nisinaka)
 *  @updated   2000/02/17 (by MATSUDA Ryouichi)
 *  @updated   2002/11/21 (by nisinaka)
 *  @updated   2003/03/03 (by Mitsuhiro Asada)
 *  @updated   2003/03/20 (by Mitsuhiro Asada)
 *  @updated   2005/02/24 (by nisinaka)
 *  @updated   2006/03/16 (by Mitsuhiro Asada)
 *  @updated   2007/03/12 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun696 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLauncher.java,v 8.50 2008/02/20 06:32:59 nisinaka Exp $
 */
public class JunLauncher extends JunDisplayModel {

	protected static final Class[] TestExampleClasses = new Class[] {
			jp.co.sra.jun.collections.sequences.JunDoubleMatrixTestExamples.class,
			jp.co.sra.jun.collections.sequences.JunLinearEquationsTestExamples.class,
			jp.co.sra.jun.collections.support.JunCorrelationTestExamples.class,
			jp.co.sra.jun.csg.abstracts.JunCSGTestExamples.class,
			jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayProcessorTestExamples.class,
			jp.co.sra.jun.dxf.support.JunCADModelTestExamples.class,
			jp.co.sra.jun.dxf.support.JunDXFParserTestExamples.class,
			jp.co.sra.jun.geometry.basic.Jun2dPointTestExamples.class,
			jp.co.sra.jun.geometry.basic.Jun3dPointTestExamples.class,
			jp.co.sra.jun.geometry.basic.JunAngleTestExamples.class,
			jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBoxTestExamples.class,
			jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBallTestExamples.class,
			jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBoxTestExamples.class,
			jp.co.sra.jun.geometry.boundaries.JunBorderGeneratorTestExamples.class,
			jp.co.sra.jun.geometry.boxtree.Jun2dBoundingBoxNodeTestExamples.class,
			jp.co.sra.jun.geometry.boxtree.Jun2dBoundingBoxTreeTestExamples.class,
			jp.co.sra.jun.geometry.boxtree.Jun3dBoundingBoxNodeTestExamples.class,
			jp.co.sra.jun.geometry.boxtree.Jun3dBoundingBoxTreeTestExamples.class,
			jp.co.sra.jun.geometry.coordinate.Jun3dCoordinateSystemTestExamples.class,
			jp.co.sra.jun.geometry.curves.Jun2dLineTestExamples.class,
			jp.co.sra.jun.geometry.curves.Jun2dPolylineTestExamples.class,
			jp.co.sra.jun.geometry.curves.Jun3dLineTestExamples.class,
			jp.co.sra.jun.geometry.curves.Jun3dPolylineTestExamples.class,
			jp.co.sra.jun.geometry.forms.JunForm2dRegionTestExamples.class,
			jp.co.sra.jun.geometry.forms.JunFormCreationTestExamples.class,
			jp.co.sra.jun.geometry.forms.JunFormTriangulationTestExamples.class,
			jp.co.sra.jun.geometry.forms.JunFormTriangulation1TestExamples.class,
			jp.co.sra.jun.geometry.forms.JunFormTriangulation2TestExamples.class,
			jp.co.sra.jun.geometry.forms.JunFormTriangulation3TestExamples.class,
			jp.co.sra.jun.geometry.pluralities.Jun2dBoundingBallsTestExamples.class,
			jp.co.sra.jun.geometry.pluralities.Jun2dBoundingBoxesTestExamples.class,
			jp.co.sra.jun.geometry.pluralities.Jun2dTrianglesTestExamples.class,
			jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBallsTestExamples.class,
			jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBoxesTestExamples.class,
			jp.co.sra.jun.geometry.pluralities.Jun3dTrianglesTestExamples.class,
			jp.co.sra.jun.geometry.solid.JunCircularConeTestExamples.class,
			jp.co.sra.jun.geometry.solid.JunCircularCylinderTestExamples.class,
			jp.co.sra.jun.geometry.solid.JunSphereTestExamples.class,
			jp.co.sra.jun.geometry.solid.JunTetrahedronTestExamples.class,
			jp.co.sra.jun.geometry.support.JunPointsOnPlaneTestExamples.class,
			jp.co.sra.jun.geometry.support.JunPointSorterTestExamples.class,
			jp.co.sra.jun.geometry.surfaces.Jun2dCircleTestExamples.class,
			jp.co.sra.jun.geometry.surfaces.Jun2dTriangleTestExamples.class,
			jp.co.sra.jun.geometry.surfaces.Jun3dCircleTestExamples.class,
			jp.co.sra.jun.geometry.surfaces.Jun3dPolygonTestExamples.class,
			jp.co.sra.jun.geometry.surfaces.Jun3dTriangleTestExamples.class,
			jp.co.sra.jun.geometry.surfaces.JunPlaneTestExamples.class,
			jp.co.sra.jun.geometry.transformations.Jun3dTransformationTestExamples.class,
			jp.co.sra.jun.goodies.animation.JunCartoonMovieTestExamples.class,
			jp.co.sra.jun.goodies.bulletinboard.JunBulletinBoardTestExamples.class,
			jp.co.sra.jun.goodies.button.JunButtonModelTestExamples.class,
			jp.co.sra.jun.goodies.button.JunButtonWithMenuModelTestExamples.class,
			jp.co.sra.jun.goodies.calendar.JunCalendarClockDateAndTimeTestExamples.class,
			jp.co.sra.jun.goodies.calendar.JunCalendarClockDateTestExamples.class,
			jp.co.sra.jun.goodies.calendar.JunCalendarClockTimeTestExamples.class,
			jp.co.sra.jun.goodies.calendar.JunCalendarDateAndTimeDialogTestExamples.class,
			jp.co.sra.jun.goodies.calendar.JunCalendarDateAndTimeIntervalDialogTestExamples.class,
			jp.co.sra.jun.goodies.calendar.JunCalendarDateAndTimeIntervalModelTestExamples.class,
			jp.co.sra.jun.goodies.calendar.JunCalendarDateAndTimeModelTestExamples.class,
			jp.co.sra.jun.goodies.calendar.JunCalendarDateDialogTestExamples.class,
			jp.co.sra.jun.goodies.calendar.JunCalendarDateIntervalDialogTestExamples.class,
			jp.co.sra.jun.goodies.calendar.JunCalendarDateIntervalModelTestExamples.class,
			jp.co.sra.jun.goodies.calendar.JunCalendarDateModelTestExamples.class,
			jp.co.sra.jun.goodies.calendar.JunCalendarTimeDialogTestExamples.class,
			jp.co.sra.jun.goodies.calendar.JunCalendarTimeIntervalDialogTestExamples.class,
			jp.co.sra.jun.goodies.calendar.JunCalendarTimeIntervalModelTestExamples.class,
			jp.co.sra.jun.goodies.calendar.JunCalendarTimeModelTestExamples.class,
			jp.co.sra.jun.goodies.catalog.JunImageCatalogTestExamples.class,
			jp.co.sra.jun.goodies.catalog.JunMovieCatalogTestExamples.class,
			jp.co.sra.jun.goodies.catalog.JunVisualCatalogTestExamples.class,
			jp.co.sra.jun.goodies.colors.JunColorBarDialogTestExamples.class,
			jp.co.sra.jun.goodies.colors.JunColorBarModelTestExamples.class,
			jp.co.sra.jun.goodies.colors.JunColorChoiceDialogTestExamples.class,
			jp.co.sra.jun.goodies.colors.JunColorChoiceTestExamples.class,
			jp.co.sra.jun.goodies.colors.JunColorSpuitTestExamples.class,
			jp.co.sra.jun.goodies.cursors.JunCursorsTestExamples.class,
			jp.co.sra.jun.goodies.display.JunDisplayModelTestExamples.class,
			jp.co.sra.jun.goodies.drawing.JunDrawingTestExamples.class,
			jp.co.sra.jun.goodies.drawing.map.JunDrawingMapModelTestExamples.class,
			jp.co.sra.jun.goodies.drawing.properties.JunPathPropertiesModelTestExamples.class,
			jp.co.sra.jun.goodies.drawing.properties.JunRectangularShapePropertiesModelTestExamples.class,
			jp.co.sra.jun.goodies.drawing.properties.JunTextboxPropertiesModelTestExamples.class,
			jp.co.sra.jun.goodies.drawing.properties.JunTextPropertiesModelTestExamples.class,
			jp.co.sra.jun.goodies.files.JunFileDialogTestExamples.class,
			jp.co.sra.jun.goodies.files.JunFileModelTestExamples.class,
			jp.co.sra.jun.goodies.font.JunFontDialogTestExamples.class,
			jp.co.sra.jun.goodies.font.JunFontModelTestExamples.class,
			jp.co.sra.jun.goodies.fourier.JunDiscreteFourierTransformationTestExamples.class,
			jp.co.sra.jun.goodies.freehand.JunFreehandNoteTestExamples.class,
			jp.co.sra.jun.goodies.freehand.JunFreehandPageTestExamples.class,
			jp.co.sra.jun.goodies.gauge.JunGaugeDialogTestExamples.class,
			jp.co.sra.jun.goodies.gauge.JunGaugeModelTestExamples.class,
			jp.co.sra.jun.goodies.gauge.JunLevelGaugeModelTestExamples.class,
			jp.co.sra.jun.goodies.gauge.JunSimpleGaugeModelTestExamples.class,
			jp.co.sra.jun.goodies.icon.JunOpaqueImageIconsTestExamples.class,
			jp.co.sra.jun.goodies.image.framework.JunImageDisplayModelTestExamples.class,
			jp.co.sra.jun.goodies.image.streams.JunImageStreamTestExamples.class,
			jp.co.sra.jun.goodies.image.support.JunImageAdjusterTestExamples.class,
			jp.co.sra.jun.goodies.image.support.JunImageProcessorTestExamples.class,
			jp.co.sra.jun.goodies.image.support.JunImageToAsciiTestExamples.class,
			jp.co.sra.jun.goodies.itemlist.JunChoiceListDialogTestExamples.class,
			jp.co.sra.jun.goodies.itemlist.JunChoiceListTestExamples.class,
			jp.co.sra.jun.goodies.itemlist.JunItemListDialogTestExamples.class,
			jp.co.sra.jun.goodies.itemlist.JunItemListTestExamples.class,
			jp.co.sra.jun.goodies.itemlist.JunOrderListDialogTestExamples.class,
			jp.co.sra.jun.goodies.itemlist.JunOrderListTestExamples.class,
			jp.co.sra.jun.goodies.lisp.JunLispConsTestExamples.class,
			jp.co.sra.jun.goodies.lisp.JunLispInterpreterTestExamples.class,
			jp.co.sra.jun.goodies.lisp.JunLispParserTestExamples.class,
			jp.co.sra.jun.goodies.meter.JunLevelGaugeMeterTestExamples.class,
			jp.co.sra.jun.goodies.meter.JunStereoLevelMeterTestExamples.class,
			jp.co.sra.jun.goodies.milliseconds.JunMillisecondDialogTestExamples.class,
			jp.co.sra.jun.goodies.milliseconds.JunMillisecondModelTestExamples.class,
			jp.co.sra.jun.goodies.misc.JunSampleTriangleTestExamples.class,
			jp.co.sra.jun.goodies.movie.framework.JunMoviePlayerTestExamples.class,
			jp.co.sra.jun.goodies.movie.support.JunImagesToMovieTestExamples.class,
			jp.co.sra.jun.goodies.movie.support.JunMovieThumbnailsTestExamples.class,
			jp.co.sra.jun.goodies.movie.support.JunScreenRecorderTestExamples.class,
			jp.co.sra.jun.goodies.multimedia.JunMultiMediaBodyModelTestExamples.class,
			jp.co.sra.jun.goodies.multimedia.JunMultiMediaImageModelTestExamples.class,
			jp.co.sra.jun.goodies.multimedia.JunMultiMediaMovieModelTestExamples.class,
			jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextModelTestExamples.class,
			jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewerTestExamples.class,
			jp.co.sra.jun.goodies.nib.JunNibChoiceDialogTestExamples.class,
			jp.co.sra.jun.goodies.nib.JunNibChoiceTestExamples.class,
			jp.co.sra.jun.goodies.nib.JunNibChoiceWithColorDialogTestExamples.class,
			jp.co.sra.jun.goodies.nib.JunNibChoiceWithColorTestExamples.class,
			jp.co.sra.jun.goodies.parameter.JunParameterModelTestExamples.class,
			jp.co.sra.jun.goodies.parameter.JunParametersModelTestExamples.class,
			jp.co.sra.jun.goodies.plotter.JunPlotterTestExamples.class,
			jp.co.sra.jun.goodies.progress.JunCursorAnimatorTestExamples.class,
			jp.co.sra.jun.goodies.progress.JunProgressTestExamples.class,
			jp.co.sra.jun.goodies.prolog.JunPrologInterpreterTestExamples.class,
			jp.co.sra.jun.goodies.revision.JunRevisionManagerTestExamples.class,
			jp.co.sra.jun.goodies.soroban.JunSorobanTestExamples.class,
			jp.co.sra.jun.goodies.spirodesign.JunSpiroCircleTestExamples.class,
			jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignModelTestExamples.class,
			jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignTestExamples.class,
			jp.co.sra.jun.goodies.spirodesign.JunSpiroPenTestExamples.class,
			jp.co.sra.jun.goodies.stopwatch.JunStopwatchTestExamples.class,
			jp.co.sra.jun.goodies.texteditor.JunTextEditorDialogTestExamples.class,
			jp.co.sra.jun.goodies.texteditor.JunTextEditorTestExamples.class,
			jp.co.sra.jun.goodies.tips.JunURLTestExamples.class,
			jp.co.sra.jun.goodies.tools.JunFileLauncherTestExamples.class,
			jp.co.sra.jun.goodies.track.JunSimpleSliderModelTestExamples.class,
			jp.co.sra.jun.goodies.track.JunTrackSliderModelTestExamples.class,
			jp.co.sra.jun.goodies.track.JunTrackerModelTestExamples.class,
			jp.co.sra.jun.goodies.utilities.JunControlUtilityTestExamples.class,
			jp.co.sra.jun.goodies.utilities.JunImageUtilityTestExamples.class,
			jp.co.sra.jun.goodies.utilities.JunSensorUtilityTestExamples.class,
			jp.co.sra.jun.goodies.utilities.JunStringUtilityTestExamples.class,
			jp.co.sra.jun.goodies.wavelet.JunDiscreteWavelet1dTransformationTestExamples.class,
			jp.co.sra.jun.goodies.wavelet.JunDiscreteWavelet2dTransformationTestExamples.class,
			jp.co.sra.jun.goodies.wheels.JunThumbWheelTestExamples.class,
			jp.co.sra.jun.graphics.abstracts.JunAbstractMapTestExamples.class,
			jp.co.sra.jun.graphics.framework.JunGraphicTestExamples.class,
			jp.co.sra.jun.graphics.list.JunFileListTestExamples.class,
			jp.co.sra.jun.graphics.list.JunSequenceListTestExamples.class,
			jp.co.sra.jun.graphics.map.JunSequenceMapTestExamples.class,
			jp.co.sra.jun.graphics.navigator.JunFileNavigatorTestExamples.class,
			jp.co.sra.jun.graphics.navigator.JunFileRequesterDialogTestExamples.class,
			jp.co.sra.jun.graphics.navigator.JunFileRequesterTestExamples.class,
			jp.co.sra.jun.graphics.navigator.JunMultiMediaNavigatorTestExamples.class,
			jp.co.sra.jun.metaball.solid.JunMetaballSolidTestExamples.class,
			jp.co.sra.jun.octree.basic.Jun27TreeTestExamples.class,
			jp.co.sra.jun.octree.basic.JunOctreeTestExamples.class,
			jp.co.sra.jun.octree.editor.JunOctreeEditModelTestExamples.class,
			jp.co.sra.jun.opengl.chart.JunChartBandTestExamples.class,
			jp.co.sra.jun.opengl.chart.JunChartBarTestExamples.class,
			jp.co.sra.jun.opengl.chart.JunChartCombinationTestExamples.class,
			jp.co.sra.jun.opengl.chart.JunChartDataSheetTestExamples.class,
			jp.co.sra.jun.opengl.chart.JunChartDataTestExamples.class,
			jp.co.sra.jun.opengl.chart.JunChartDataWithNumericalKeysTestExamples.class,
			jp.co.sra.jun.opengl.chart.JunChartLineTestExamples.class,
			jp.co.sra.jun.opengl.chart.JunChartLineWithNumericalKeysTestExamples.class,
			jp.co.sra.jun.opengl.chart.JunChartPieTestExamples.class,
			jp.co.sra.jun.opengl.chart.JunChartPlotTestExamples.class,
			jp.co.sra.jun.opengl.chart.JunChartPlotWithNumericalKeysTestExamples.class,
			jp.co.sra.jun.opengl.chart.JunChartRadarTestExamples.class,
			jp.co.sra.jun.opengl.cosmos.JunOpenGLHypercosmModelTestExamples.class,
			jp.co.sra.jun.opengl.cosmos.JunOpenGLMacrocosmModelTestExamples.class,
			jp.co.sra.jun.opengl.cosmos.JunOpenGLMicrocosmModelTestExamples.class,
			jp.co.sra.jun.opengl.display.JunOpenGL3dModelTestExamples.class,
			jp.co.sra.jun.opengl.display.JunOpenGLDisplayLightTestExamples.class,
			jp.co.sra.jun.opengl.display.JunOpenGLDisplayModelTestExamples.class,
			jp.co.sra.jun.opengl.display.JunOpenGLDisplayObjectsTestExamples.class,
			jp.co.sra.jun.opengl.display.JunOpenGLShowModelTestExamples.class,
			jp.co.sra.jun.opengl.display.JunOpenGLStereoDisplayModelTestExamples.class,
			jp.co.sra.jun.opengl.flux.JunOpenGLFluxMakerTestExamples.class,
			jp.co.sra.jun.opengl.flux.JunOpenGLFluxModelTestExamples.class,
			jp.co.sra.jun.opengl.grapher.JunOpenGL3dArcTestExamples.class,
			jp.co.sra.jun.opengl.grapher.JunOpenGL3dGraphTestExamples.class,
			jp.co.sra.jun.opengl.grapher.JunOpenGL3dGrapherTestExamples.class,
			jp.co.sra.jun.opengl.grapher.JunOpenGL3dNodeTestExamples.class,
			jp.co.sra.jun.opengl.illusion.JunOpenGLIllusionTestExamples.class,
			jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObjectTestExamples.class,
			jp.co.sra.jun.opengl.objects.JunOpenGL3dNurbsCurveTestExamples.class,
			jp.co.sra.jun.opengl.objects.JunOpenGL3dNurbsSurfaceTestExamples.class,
			jp.co.sra.jun.opengl.objects.JunOpenGL3dObjectTestExamples.class,
			jp.co.sra.jun.opengl.objects.JunOpenGL3dPatchedObjectTestExamples.class,
			jp.co.sra.jun.opengl.objects.JunOpenGL3dTransformedObjectTestExamples.class,
			jp.co.sra.jun.opengl.objects.JunOpenGL3dVertexesTestExamples.class,
			jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBodyTestExamples.class,
			jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBodyModelTestExamples.class,
			jp.co.sra.jun.opengl.plotter.JunOpenGLPlotterTestExamples.class,
			jp.co.sra.jun.opengl.rotation.JunOpenGLRotationApplicationModelTestExamples.class,
			jp.co.sra.jun.opengl.rotation.JunOpenGLRotationModelTestExamples.class,
			jp.co.sra.jun.opengl.roughsketch.JunOpenGLRoughSketchTestExamples.class,
			jp.co.sra.jun.opengl.texture.JunOpenGLStippleTestExamples.class,
			jp.co.sra.jun.opengl.texture.JunOpenGLTextureTestExamples.class,
			jp.co.sra.jun.system.dialog.JunPopUpDialogTestExamples.class,
			jp.co.sra.jun.system.dialog.JunTextInputFieldTestExamples.class,
			jp.co.sra.jun.system.framework.JunAbstractModelTestExamples.class,
			jp.co.sra.jun.system.framework.JunDialogTestExamples.class,
			jp.co.sra.jun.system.support.JunSmallCompilerTestExamples.class,
			jp.co.sra.jun.system.support.JunTestExamples.class,
			jp.co.sra.jun.terrain.editor.JunTerrainEditModelTestExamples.class,
			jp.co.sra.jun.topology.elements.JunBodyTestExamples.class,
			jp.co.sra.jun.topology.euleroperators.JunKCLMPLTestExamples.class,
			jp.co.sra.jun.topology.euleroperators.JunKDEVTestExamples.class,
			jp.co.sra.jun.topology.euleroperators.JunKELTestExamples.class,
			jp.co.sra.jun.topology.euleroperators.JunKEVTestExamples.class,
			jp.co.sra.jun.topology.euleroperators.JunKEVVLTestExamples.class,
			jp.co.sra.jun.topology.euleroperators.JunKVETestExamples.class,
			jp.co.sra.jun.topology.euleroperators.JunMDEVTestExamples.class,
			jp.co.sra.jun.topology.euleroperators.JunMEKLTestExamples.class,
			jp.co.sra.jun.topology.euleroperators.JunMELTestExamples.class,
			jp.co.sra.jun.topology.euleroperators.JunMEVTestExamples.class,
			jp.co.sra.jun.topology.euleroperators.JunMEVVLTestExamples.class,
			jp.co.sra.jun.topology.euleroperators.JunMVETestExamples.class,
			jp.co.sra.jun.topology.geometricoperators.JunKCVTestExamples.class,
			jp.co.sra.jun.topology.geometricoperators.JunKSFTestExamples.class,
			jp.co.sra.jun.topology.geometricoperators.JunMCVTestExamples.class,
			jp.co.sra.jun.topology.geometricoperators.JunMSFTestExamples.class,
			jp.co.sra.jun.topology.geometricoperators.JunTCVTestExamples.class,
			jp.co.sra.jun.topology.geometricoperators.JunTSFTestExamples.class,
			jp.co.sra.jun.topology.geometricoperators.JunTVTestExamples.class,
			jp.co.sra.jun.topology.globaloperators.JunADDTestExamples.class,
			jp.co.sra.jun.topology.globaloperators.JunLineSCALETestExamples.class,
			jp.co.sra.jun.topology.globaloperators.JunMIRRORTestExamples.class,
			jp.co.sra.jun.topology.globaloperators.JunNEGATETestExamples.class,
			jp.co.sra.jun.topology.globaloperators.JunPlaneSCALETestExamples.class,
			jp.co.sra.jun.topology.globaloperators.JunPointSCALETestExamples.class,
			jp.co.sra.jun.topology.globaloperators.JunSEPARATETestExamples.class,
			jp.co.sra.jun.topology.graph.JunElementalArcSettingsTestExamples.class,
			jp.co.sra.jun.topology.graph.JunElementalArcTestExamples.class,
			jp.co.sra.jun.topology.graph.JunElementalGraphSettingsTestExamples.class,
			jp.co.sra.jun.topology.graph.JunElementalGraphTestExamples.class,
			jp.co.sra.jun.topology.graph.JunElementalNodeSettingsTestExamples.class,
			jp.co.sra.jun.topology.graph.JunElementalNodeTestExamples.class,
			jp.co.sra.jun.topology.grapher.JunGrapherTestExamples.class,
			jp.co.sra.jun.topology.setoperators.JunDIFFTestExamples.class,
			jp.co.sra.jun.topology.setoperators.JunINTERTestExamples.class,
			jp.co.sra.jun.topology.setoperators.JunUNIONTestExamples.class,
			jp.co.sra.jun.voronoi.twoD.diagram.JunDelaunay2dDiagramTestExamples.class,
			jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDiagramTestExamples.class,
			jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDotTestExamples.class,
			jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dLineTestExamples.class,
			jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dPointTestExamples.class,
			jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dProcessorTestExamples.class,
			jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dSideTestExamples.class,
			jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dTriangleTestExamples.class,
			jp.co.sra.jun.vrml.support.JunVrmlCompilerTestExamples.class,
			jp.co.sra.jun.vrml.support.JunVrmlGenerator10TestExamples.class,
			jp.co.sra.jun.vrml.support.JunVrmlGenerator20TestExamples.class,
			jp.co.sra.jun.vrml.support.JunVrmlGenerator97TestExamples.class,
			jp.co.sra.jun.vrml.support.JunVrmlParser10TestExamples.class,
			jp.co.sra.jun.vrml.support.JunVrmlParser20TestExamples.class,
			jp.co.sra.jun.vrml.support.JunVrmlParser97TestExamples.class,
			jp.co.sra.jun.vrml.support.JunVrmlRenderingContextTestExamples.class,
			jp.co.sra.qt4jun.JunQTInterfaceTestExamples.class,
			jp.co.sra.smalltalk.StImageTestExamples.class };

	public static final int _DefaultWidth = 187;
	protected static boolean _closeToExit = true;

	protected StMenuBar _menuBar;

	/**
	 * Initialize the JunLauncher when created.
	 * 
	 * @see jp.co.sra.jun.goodies.display.JunDisplayModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		_scrollable = false;
	}

	/**
	 * Answer my visual object.
	 * 
	 * @return jp.co.sra.smalltalk.StDisplayable
	 * @see jp.co.sra.jun.goodies.display.JunDisplayModel#visual()
	 * @category accessing
	 */
	public StDisplayable visual() {
		if (displayObject == null) {
			StImage logoImage = new StImage(JunSystem.LogoImage());
			int width = logoImage.width();
			int height = logoImage.height();
			height = (_DefaultWidth - 20) * height / width;
			width = (_DefaultWidth - 20);
			StImage image = new StImage(_DefaultWidth, height);
			Graphics aGraphics = null;
			try {
				aGraphics = image.image().getGraphics();
				aGraphics.drawImage(logoImage.image(), 10, 0, width, height, null);
			} finally {
				if (aGraphics != null) {
					aGraphics.dispose();
					aGraphics = null;
				}
			}
			displayObject = image;
		}
		return displayObject;
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.jun.goodies.display.JunDisplayModel#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunLauncherViewAwt(this);
		} else {
			return new JunLauncherViewSwing(this);
		}
	}

	/**
	 * Create a Frame for the application model.
	 * Do everything but open the frame.
	 *
	 * @param aView jp.co.sra.smalltalk.StView
	 * @return java.awt.Frame
	 * @see jp.co.sra.smalltalk.StApplicationModel#allButOpenView_(jp.co.sra.smalltalk.StView)
	 * @category interface opening
	 */
	protected Frame allButOpenView_(StView aView) {
		Frame aFrame = super.allButOpenView_(aView);
		aFrame.setSize(203, 167);
		return aFrame;
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.jun.goodies.display.JunDisplayModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return $String("Jun Launcher");
	}

	/**
	 * Invoked when a window is in the process of being closed.
	 * 
	 * @param e java.awt.event.WindowEvent
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#noticeOfWindowClose(java.awt.event.WindowEvent)
	 * @category interface closing
	 */
	public void noticeOfWindowClose(WindowEvent e) {
		if (_closeToExit) {
			if (JunDialog.Confirm_($String("Really quit?"), false)) {
				System.exit(0);
			}
		} else {
			super.noticeOfWindowClose(e);
		}
	}

	/**
	 * Open a 2D grapher.
	 * 
	 * @category menu messages
	 */
	public void open2dGrapher() {
		(new JunGrapher()).open();
	}

	/**
	 * Open a 2D plotter.
	 * 
	 * @category menu messages
	 */
	public void open2dPlotter() {
		(new jp.co.sra.jun.goodies.plotter.JunPlotter()).open();
	}

	/**
	 * Open a 3D grapher.
	 * 
	 * @category menu messages
	 */
	public void open3dGrapher() {
		(new JunOpenGL3dGrapher()).open();
	}

	/**
	 * Open a 3D plotter.
	 * 
	 * @category menu messages
	 */
	public void open3dPlotter() {
		(new jp.co.sra.jun.opengl.plotter.JunOpenGLPlotter()).open();
	}

	/**
	 * Open an about dialog.
	 * 
	 * @category menu messages
	 */
	public void openAbout() {
		JunLauncherView aView = (JunLauncherView) this.getView();
		if (aView != null) {
			aView._openBanner(JunSystem.Logo());
		}
	}

	/**
	 * Open a cartoon movie player.
	 * 
	 * @category menu messages
	 */
	public void openAnimation() {
		(new jp.co.sra.jun.goodies.animation.JunCartoonMovie()).openLightWeightWindowSpecMarkerFlag_(false);
	}

	/**
	 * Open a band chart.
	 * 
	 * @category menu messages
	 */
	public void openBandChart() {
		jp.co.sra.jun.opengl.chart.JunChartBandTestExamples.Example6();
	}

	/**
	 * Open a bar chart.
	 * 
	 * @category menu messages
	 */
	public void openBarChart() {
		jp.co.sra.jun.opengl.chart.JunChartBarTestExamples.Example6();
	}

	/**
	 * Open a viewfinder with a benzene.
	 * 
	 * @category menu messages
	 */
	public void openBenzene() {
		boolean shiftDown = StInputState.Default().shiftDown();
		boolean altDown = StInputState.Default().altDown();
		if (shiftDown && altDown) {
			jp.co.sra.jun.opengl.display.JunOpenGLDisplayObjectsTestExamples.Example();
			return;
		}
		if (shiftDown) {
			JunOpenGL3dObject.Doraemon().show();
			return;
		}
		if (altDown) {
			JunOpenGL3dObject.Aoki().show();
			return;
		}
		JunOpenGL3dObject.Benzene().show();
	}

	/**
	 * Open a cartoon movie player.
	 * 
	 * @category menu messages
	 */
	public void openCartoonMoviePlayer() {
		boolean shiftDown = StInputState.Default().shiftDown();
		boolean altDown = StInputState.Default().altDown();
		if (shiftDown && altDown) {
			// JunHistoryUtility.CartoonMovieAboutCityOfJun();
			return;
		}
		if (shiftDown) {
			jp.co.sra.jun.goodies.animation.JunCartoonMovieTestExamples.Example6();
			return;
		}
		if (altDown) {
			jp.co.sra.jun.goodies.animation.JunCartoonMovieTestExamples.Example6();
			return;
		}
		jp.co.sra.jun.goodies.animation.JunCartoonMovieTestExamples.Example5();
	}

	/**
	 * Open a JunParameterizedBodyModel with a chair.
	 * 
	 * @category menu messages
	 */
	public void openChair() {
		jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBodyModelTestExamples.Example1();
	}

	/**
	 * Open a JunOpenGL3dGrapher with a class tree.
	 * 
	 * @category menu messages
	 */
	public void openClassTree() {
		jp.co.sra.jun.opengl.grapher.JunOpenGL3dGrapherTestExamples.Example1();
	}

	/**
	 * Open a combination chart.
	 * 
	 * @category menu messages
	 */
	public void openCombinationChart() {
		jp.co.sra.jun.opengl.chart.JunChartCombinationTestExamples.Example1();
	}

	/**
	 * Open a copyright dialog.
	 * 
	 * @category menu messages
	 */
	public void openCopyright() {
		JunLauncherView aView = (JunLauncherView) this.getView();
		if (aView != null) {
			aView._openTextViewer_($String("Copyright"), JunSystem.Copyright(), new Dimension(500, 160));
		}
	}

	/**
	 * Open a viewfinder with a sphere.
	 * 
	 * @category menu messages
	 */
	public void openCube() {
		boolean shiftDown = StInputState.Default().shiftDown();
		boolean altDown = StInputState.Default().altDown();
		if (shiftDown && altDown) {
			JunOpenGL3dObject.SoccerBall().show();
			return;
		}
		if (shiftDown) {
			JunOpenGL3dObject.ColorCube().show().displayLightsAllOff();
			return;
		}
		if (altDown) {
			JunOpenGL3dObject.ColorCone().show().displayLightsAllOff();
			return;
		}
		JunOpenGL3dObject aCube = JunOpenGL3dObject.Cube();
		aCube.paint_(Color.pink);
		Map projection = new HashMap();
		projection.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		projection.put($("eyePoint"), new Jun3dPoint(9, 5, 7));
		projection.put($("upVector"), new Jun3dPoint(0, 0, 1));
		projection.put($("zoomHeight"), new Double(4));
		projection.put($("viewFactor"), new Double(10));
		projection.put($("presentation"), $("solidPresentation"));
		projection.put($("shading"), $("smoothShading"));
		aCube.showProjectionTable_(projection);
	}

	/**
	 * Open a JunOpenGLFluxModel.
	 * 
	 * @category menu messages
	 */
	public void openFlux() {
		(new jp.co.sra.jun.opengl.flux.JunOpenGLFluxModel()).open();
	}

	/**
	 * Open a JunOpenGL3dGrapher with a class tree.
	 * 
	 * @category menu messages
	 */
	public void openGlass() {
		jp.co.sra.jun.opengl.rotation.JunOpenGLRotationApplicationModelTestExamples.Example7();
	}

	/**
	 * Open a JunOpenGLGrapher.
	 * 
	 * @category menu messages
	 */
	public void openGrapher() {
		boolean shiftDown = StInputState.Default().shiftDown();
		boolean altDown = StInputState.Default().altDown();
		if (shiftDown && altDown) {
			jp.co.sra.jun.topology.grapher.JunGrapherTestExamples.Example05_Tokyo();
			return;
		}
		if (shiftDown) {
			jp.co.sra.jun.topology.grapher.JunGrapherTestExamples.Example00_Simple();
			return;
		}
		if (altDown) {
			jp.co.sra.jun.topology.grapher.JunGrapherTestExamples.Example04_Tokyo();
			return;
		}
		jp.co.sra.jun.topology.grapher.JunGrapherTestExamples.Example02_Forest();
	}

	/**
	 * Open a Hyper Cosmos.
	 *
	 * @category menu messages
	 */
	public void openHyperCosmos() {
		boolean shiftDown = StInputState.Default().shiftDown();
		boolean altDown = StInputState.Default().altDown();
		if (shiftDown && altDown) {
			jp.co.sra.jun.opengl.cosmos.JunOpenGLHypercosmModelTestExamples.Example1();
			return;
		}
		if (shiftDown) {
			jp.co.sra.jun.opengl.cosmos.JunOpenGLHypercosmModelTestExamples.Example3();
			return;
		}
		if (altDown) {
			jp.co.sra.jun.opengl.cosmos.JunOpenGLHypercosmModelTestExamples.Example2();
			return;
		}
		jp.co.sra.jun.opengl.cosmos.JunOpenGLHypercosmModelTestExamples.Example1();
	}

	/**
	 * Open a Illusion.
	 *
	 * @category menu messages
	 */
	public void openIllusion() {
		boolean shiftDown = StInputState.Default().shiftDown();
		boolean altDown = StInputState.Default().altDown();
		if (shiftDown && altDown) {
			jp.co.sra.jun.opengl.illusion.JunOpenGLIllusionTestExamples.Example_2();
			return;
		}
		if (shiftDown) {
			jp.co.sra.jun.opengl.illusion.JunOpenGLIllusionTestExamples.Example_1();
			return;
		}
		if (altDown) {
			jp.co.sra.jun.opengl.illusion.JunOpenGLIllusionTestExamples.Example02_2();
			return;
		}
		jp.co.sra.jun.opengl.illusion.JunOpenGLIllusionTestExamples.Example01_1();
	}

	/**
	 * Open an information dialog.
	 * 
	 * @category menu messages
	 */
	public void openInformation() {
		JunLauncherView aView = (JunLauncherView) this.getView();
		if (aView != null) {
			aView._openTextViewer_($String("Information"), JunSystem.Information(), new Dimension(600, 360));
		}
	}

	/**
	 * Open a license dialog.
	 * 
	 * @category menu messages
	 */
	public void openLicense() {
		JunLauncherView aView = (JunLauncherView) this.getView();
		if (aView != null) {
			aView._openTextViewer_($String("The modified BSD license"), JunSystem.License(), new Dimension(600, 360));
		}
	}

	/**
	 * Open a line chart.
	 * 
	 * @category menu messages
	 */
	public void openLineChart() {
		jp.co.sra.jun.opengl.chart.JunChartLineTestExamples.Example6();
	}

	/**
	 * Open a JunLispInterpreter.
	 * 
	 * @category menu messages
	 */
	public void openLispInterpreter() {
		JunLispInterpreter prologInterpreter = new JunLispInterpreter();
		prologInterpreter.open();
		prologInterpreter.textValue().value_("% Select the following expression.\n% Then do it from the popup menu.\n\n(append '(1 2) '(3 4))");
	}

	/**
	 * Open a Macro Cosmos.
	 *
	 * @category menu messages
	 */
	public void openMacroCosmos() {
		boolean shiftDown = StInputState.Default().shiftDown();
		boolean altDown = StInputState.Default().altDown();
		if (shiftDown && altDown) {
			jp.co.sra.jun.opengl.cosmos.JunOpenGLMacrocosmModelTestExamples.Example3();
			return;
		}
		if (shiftDown) {
			jp.co.sra.jun.opengl.cosmos.JunOpenGLMacrocosmModelTestExamples.Example2();
			return;
		}
		if (altDown) {
			jp.co.sra.jun.opengl.cosmos.JunOpenGLMacrocosmModelTestExamples.Example1();
			return;
		}
		jp.co.sra.jun.opengl.cosmos.JunOpenGLMacrocosmModelTestExamples.Example3();
	}

	/**
	 * Open a Movie or Sound.
	 * 
	 * @category menu messages
	 */
	public void openMovieOrSound() {
		boolean shiftDown = StInputState.Default().shiftDown();
		boolean altDown = StInputState.Default().altDown();
		if (shiftDown && altDown) {
			// JunQuickTimeMovie.open();
			(new jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer()).open();
			return;
		}
		if (shiftDown) {
			(new jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer()).open();
			return;
		}
		if (altDown) {
			(new jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer()).open();
			return;
		}
		// JunQuickTimeMovie.open();
		(new jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer()).open();
	}

	/**
	 * Open a Multi-Media Navigator.
	 * 
	 * @category menu messages
	 */
	public void openMultiMediaNavigator() {
		boolean shiftDown = StInputState.Default().shiftDown();
		boolean altDown = StInputState.Default().altDown();
		if (shiftDown || altDown) {
			(new jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewer()).open();
			return;
		}
		(new jp.co.sra.jun.graphics.navigator.JunMultiMediaNavigator(new File(System.getProperty("user.dir")))).open();
	}

	/**
	 * Open a pie chart.
	 * 
	 * @category menu messages
	 */
	public void openPieChart() {
		jp.co.sra.jun.opengl.chart.JunChartPieTestExamples.Example3();
	}

	/**
	 * Open a JunOpenGLFluxModel with a planet
	 * 
	 * @category menu messages
	 */
	public void openPlanet() {
		boolean shiftDown = StInputState.Default().shiftDown();
		boolean altDown = StInputState.Default().altDown();
		if (shiftDown || altDown) {
			jp.co.sra.jun.opengl.flux.JunOpenGLFluxModelTestExamples.Example6();
			return;
		}
		jp.co.sra.jun.opengl.flux.JunOpenGLFluxModelTestExamples.Example4();
	}

	/**
	 * Open a plot chart.
	 * 
	 * @category menu messages
	 */
	public void openPlotChart() {
		jp.co.sra.jun.opengl.chart.JunChartPlotTestExamples.Example6();
	}

	/**
	 * Open a JunPrologInterpreter.
	 * 
	 * @category menu messages
	 */
	public void openPrologInterpreter() {
		JunPrologInterpreter prologInterpreter = new JunPrologInterpreter();
		prologInterpreter.open();
		prologInterpreter.textValue().value_("% Select the following expression.\n% Then do it from the popup menu.\n\n?-append(X,Y,[1,2,3,4]).");
	}

	/**
	 * Open a radar chart.
	 * 
	 * @category menu messages
	 */
	public void openRadarChart() {
		jp.co.sra.jun.opengl.chart.JunChartRadarTestExamples.Example5();
	}

	/**
	 * Open a JunParameterizedBodyModel with a robot arm.
	 * 
	 * @category menu messages
	 */
	public void openRobotArm() {
		jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBodyModelTestExamples.Example2();
	}

	/**
	 * Open a JunOpenGLMicrocosmModel.
	 * 
	 * @category menu messages
	 */
	public void openRoom() {
		jp.co.sra.jun.opengl.cosmos.JunOpenGLMicrocosmModelTestExamples.Example1();
	}

	/**
	 * Open a JunOpenGLRotationApplicationModel.
	 * 
	 * @category menu messages
	 */
	public void openRotaionalBody() {
		(new jp.co.sra.jun.opengl.rotation.JunOpenGLRotationApplicationModel()).open();
	}

	/**
	 * Open a JunScreenRecorder.
	 * 
	 * @category menu messages
	 */
	public void openScreenRecorder() {
		(new jp.co.sra.jun.goodies.movie.support.JunScreenRecorder()).open();
	}

	/**
	 * Open a soroban.
	 * 
	 * @category menu messages
	 */
	public void openSoroban() {
		(new jp.co.sra.jun.goodies.soroban.JunSorobanModel()).open();
	}

	/**
	 * Open a spiro design.
	 * 
	 * @category menu messages
	 */
	public void openSpiroDesign() {
		boolean shiftDown = StInputState.Default().shiftDown();
		boolean altDown = StInputState.Default().altDown();
		if (shiftDown && altDown) {
			jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignModelTestExamples.Example2();
			return;
		}
		if (shiftDown) {
			(new jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign()).open();
			return;
		}
		if (altDown) {
			jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignTestExamples.Example5();
			return;
		}
		(new jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignModel()).open();
	}

	/**
	 * Open a stereoscope.
	 * 
	 * @category menu messages
	 */
	public void openStereoscope() {
		boolean shiftDown = StInputState.Default().shiftDown();
		boolean altDown = StInputState.Default().altDown();
		if (shiftDown || altDown) {
			jp.co.sra.jun.opengl.display.JunOpenGLStereoDisplayModelTestExamples.Example81();
			return;
		}
		jp.co.sra.jun.opengl.display.JunOpenGLStereoDisplayModelTestExamples.Example21();
	}

	/**
	 * Open a viewfinder with a sphere.
	 * 
	 * @category menu messages
	 */
	public void openSphere() {
		JunOpenGL3dObject aSphere = JunOpenGL3dObject.Sphere();
		aSphere.paint_(Color.blue);

		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel();
		displayModel.displayObject_(aSphere);
		displayModel.open();
	}

	/**
	 * Open a JunOpenGLFluxModel.
	 * 
	 * @category menu messages
	 */
	public void openTerrain() {
		(new jp.co.sra.jun.terrain.editor.JunTerrainEditModel()).open();
	}

	/**
	 * Open a new viewfinder.
	 * 
	 * @category menu messages
	 */
	public void openViewfinder() {
		(new JunOpenGLDisplayModel()).open();
	}

	/**
	 * Answer my menu bar.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenuBar
	 * @see jp.co.sra.smalltalk.StApplicationModel#_menuBar()
	 * @category resources
	 */
	public StMenuBar _menuBar() {
		if (_menuBar == null) {
			_menuBar = new StMenuBar();
			_menuBar.add(this._createToolsMenu());
			_menuBar.add(this._createExamplesMenu());
			_menuBar.add(this._createMiscMenu());

			JunSystem.AddDependentListenerOnDefaultLanguageMode(new DependentListener() {
				public void update_(DependentEvent evt) {
					_menuBar.resetAllLabels();
				}
			});
		}
		return _menuBar;
	}

	/**
	 * Answer my popup menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StPopupMenu
	 * @see jp.co.sra.smalltalk.StApplicationModel#_popupMenu()
	 * @category resources
	 */
	public StPopupMenu _popupMenu() {
		if (_popupMenu == null) {
			StPopupMenu aPopupMenu = new StPopupMenu();
			aPopupMenu.add(this._menuBar().atNameKey_($("tools")));
			aPopupMenu.add(this._menuBar().atNameKey_($("examples")));
			aPopupMenu.add(this._menuBar().atNameKey_($("misc")));
			_popupMenu = aPopupMenu;
		}
		return _popupMenu;
	}

	/**
	 * Create a "Tools" menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenu
	 * @category resources
	 */
	protected StMenu _createToolsMenu() {
		StMenu toolsMenu = new StMenu(new StUserMessage("Tools"), $("tools"));

		toolsMenu.add(new StMenuItem(new StUserMessage("Viewfinder"), new MenuPerformer(this, "openViewfinder")));
		toolsMenu.add(new StMenuItem(new StUserMessage("Flux"), new MenuPerformer(this, "openFlux")));
		toolsMenu.add(new StMenuItem(new StUserMessage("Grapher (3D)"), new MenuPerformer(this, "open3dGrapher")));
		toolsMenu.add(new StMenuItem(new StUserMessage("Grapher (2D)"), new MenuPerformer(this, "open2dGrapher")));
		toolsMenu.add(new StMenuItem(new StUserMessage("Rotational Body"), new MenuPerformer(this, "openRotaionalBody")));
		toolsMenu.add(new StMenuItem(new StUserMessage("Plotter (3D)"), new MenuPerformer(this, "open3dPlotter")));
		toolsMenu.add(new StMenuItem(new StUserMessage("Plotter (2D)"), new MenuPerformer(this, "open2dPlotter")));
		toolsMenu.add(new StMenuItem(new StUserMessage("Terrain"), new MenuPerformer(this, "openTerrain")));
		toolsMenu.addSeparator();
		toolsMenu.add(new StMenuItem(new StUserMessage("Animation"), new MenuPerformer(this, "openAnimation")));
		toolsMenu.add(new StMenuItem(new StUserMessage("Movie or Sound"), new MenuPerformer(this, "openMovieOrSound")));
		toolsMenu.add(new StMenuItem(new StUserMessage("Multi-Media Navigator"), new MenuPerformer(this, "openMultiMediaNavigator")));
		toolsMenu.add(new StMenuItem(new StUserMessage("Screen Recorder"), new MenuPerformer(this, "openScreenRecorder")));
		toolsMenu.addSeparator();
		toolsMenu.add(new StMenuItem(new StUserMessage("Lisp"), new MenuPerformer(this, "openLispInterpreter")));
		toolsMenu.add(new StMenuItem(new StUserMessage("Prolog"), new MenuPerformer(this, "openPrologInterpreter")));

		return toolsMenu;
	}

	/**
	 * Create an "Examples" menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenu
	 * @category resources
	 */
	protected StMenu _createExamplesMenu() {
		StMenu examplesMenu = new StMenu(new StUserMessage("Examples"), $("examples"));

		examplesMenu.add(new StMenuItem(new StUserMessage("Cube"), new MenuPerformer(this, "openCube")));
		examplesMenu.add(new StMenuItem(new StUserMessage("Sphere"), new MenuPerformer(this, "openSphere")));
		examplesMenu.add(new StMenuItem(new StUserMessage("Benzene"), new MenuPerformer(this, "openBenzene")));
		examplesMenu.add(new StMenuItem(new StUserMessage("Class Tree"), new MenuPerformer(this, "openClassTree"))); // Grapher
		examplesMenu.add(new StMenuItem(new StUserMessage("Planet"), new MenuPerformer(this, "openPlanet")));

		StMenu chartMenu = new StMenu(new StUserMessage("Chart", "Charts"));
		chartMenu.add(new StMenuItem(new StUserMessage("Bar Chart", "Bar"), new MenuPerformer(this, "openBarChart")));
		chartMenu.add(new StMenuItem(new StUserMessage("Band Chart", "Band"), new MenuPerformer(this, "openBandChart")));
		chartMenu.add(new StMenuItem(new StUserMessage("Line Chart", "Line"), new MenuPerformer(this, "openLineChart")));
		chartMenu.add(new StMenuItem(new StUserMessage("Plot Chart", "Plot"), new MenuPerformer(this, "openPlotChart")));
		chartMenu.add(new StMenuItem(new StUserMessage("Pie Chart", "Pie"), new MenuPerformer(this, "openPieChart")));
		chartMenu.add(new StMenuItem(new StUserMessage("Radar Chart", "Radar"), new MenuPerformer(this, "openRadarChart")));
		chartMenu.add(new StMenuItem(new StUserMessage("Combination"), new MenuPerformer(this, "openCombinationChart")));
		examplesMenu.add(chartMenu);

		examplesMenu.add(new StMenuItem(new StUserMessage("Glass"), new MenuPerformer(this, "openGlass")));
		examplesMenu.add(new StMenuItem(new StUserMessage("Chair"), new MenuPerformer(this, "openChair")));
		examplesMenu.add(new StMenuItem(new StUserMessage("Robot Arm"), new MenuPerformer(this, "openRobotArm")));
		examplesMenu.add(new StMenuItem(new StUserMessage("Room"), new MenuPerformer(this, "openRoom")));
		examplesMenu.add(new StMenuItem(new StUserMessage("Macrocosm", "Macro Cosmos"), new MenuPerformer(this, "openMacroCosmos")));
		examplesMenu.add(new StMenuItem(new StUserMessage("Hypercosm", "Hyper Cosmos"), new MenuPerformer(this, "openHyperCosmos")));
		examplesMenu.add(new StMenuItem(new StUserMessage("Illusion", "Illusion"), new MenuPerformer(this, "openIllusion")));
		examplesMenu.add(new StMenuItem(new StUserMessage("Stereoscope"), new MenuPerformer(this, "openStereoscope")));
		examplesMenu.add(new StMenuItem(new StUserMessage("Grapher"), new MenuPerformer(this, "openGrapher")));
		examplesMenu.add(new StMenuItem(new StUserMessage("Soroban"), new MenuPerformer(this, "openSoroban")));
		examplesMenu.add(new StMenuItem(new StUserMessage("Spiro Design"), new MenuPerformer(this, "openSpiroDesign")));
		examplesMenu.add(new StMenuItem(new StUserMessage("Cartoon Movie Player"), new MenuPerformer(this, "openCartoonMoviePlayer")));
		examplesMenu.addSeparator();
		examplesMenu.add(this._createAllTestExamplesMenu());

		return examplesMenu;
	}

	/**
	 * Create a "Misc" menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenu
	 * @category resources
	 */
	protected StMenu _createMiscMenu() {
		StMenu miscMenu = new StMenu(new StUserMessage("Misc"), $("misc"));
		miscMenu.add(new StMenuItem(new StUserMessage("About <1p>", "About", new StUserMessage("Jun")), new MenuPerformer(this, "openAbout")));
		miscMenu.add(new StMenuItem(new StUserMessage("Copyright"), new MenuPerformer(this, "openCopyright")));
		miscMenu.add(new StMenuItem(new StUserMessage("License"), new MenuPerformer(this, "openLicense")));
		miscMenu.add(new StMenuItem(new StUserMessage("Information"), new MenuPerformer(this, "openInformation")));
		miscMenu.addSeparator();
		miscMenu.add(JunOpenGLResource.DefaultOpenGLViewMenu);
		miscMenu.add(StApplicationModel.DefaultViewModeMenu);
		miscMenu.add(JunSystem.DefaultLanguageModeMenu);
		return miscMenu;
	}

	/**
	 * Create a menu for TestExamples.
	 * 
	 * @return jp.co.sra.smalltalk.StMenu
	 * @category resources
	 */
	protected StMenu _createAllTestExamplesMenu() {
		StMenu testMenu = new StMenu(new StUserMessage("Test"));

		HashMap testPackageMenus = new HashMap();
		for (int i = 0; i < TestExampleClasses.length; i++) {
			String className = TestExampleClasses[i].getName();
			String packageName = className.substring(0, className.lastIndexOf('.'));
			String[] sprits = packageName.split("\\.");
			String groupName = sprits[0] + "." + sprits[1] + "." + sprits[2] + "." + sprits[3] + ((sprits.length == 4) ? "" : ("." + sprits[4]));
			StMenu groupMenu = (StMenu) testPackageMenus.get(groupName);
			if (groupMenu == null) {
				groupMenu = new StMenu(groupName, $(groupName));
				testMenu.add(groupMenu);
				testPackageMenus.put(groupName, groupMenu);
			}

			StMenu packageMenu = (StMenu) testPackageMenus.get(packageName);
			if (packageMenu == null) {
				packageMenu = new StMenu(packageName.substring(groupName.length() + 1), $(packageName));
				groupMenu.add(packageMenu);
				testPackageMenus.put(packageName, packageMenu);
			}
			packageMenu.add(this._createTestExamplesMenuFor(TestExampleClasses[i]));
		}

		return testMenu;
	}

	/**
	 * Create a submenu for the specified class.
	 * 
	 * @param aClass java.lang.Class
	 * @return jp.co.sra.smalltalk.menu.StMenu
	 * @category resources
	 */
	protected StMenu _createTestExamplesMenuFor(Class aClass) {
		String[] methodNames = JunTestExamples.GetStaticMethodNamesFor(aClass);
		String className = aClass.getName();
		StMenu aMenu = new StMenu(className.substring(className.lastIndexOf('.') + 1));
		StMenuItem anItem = new StMenuItem(new StUserMessage("Spawn"), new MenuPerformer(this, "_spawnTestExamples", aClass));
		aMenu.add(anItem);
		aMenu.addSeparator();

		if (methodNames.length > 20 && methodNames[0].indexOf('_') > 0) {
			Map groupMenus = new HashMap();
			for (int i = 0; i < methodNames.length; i++) {
				String methodName = methodNames[i];
				String groupName = methodName.substring(0, methodName.indexOf('_'));
				StMenu groupMenu = (StMenu) groupMenus.get(groupName);
				if (groupMenu == null) {
					groupMenu = new StMenu(groupName, $(groupName));
					aMenu.add(groupMenu);
					groupMenus.put(groupName, groupMenu);
				}
				groupMenu.add(new StMenuItem(methodName, new MenuPerformer(this, "_performTestExampleMenu", new Object[] { aClass, methodName })));
			}
		} else {
			for (int i = 0; i < methodNames.length; i++) {
				String methodName = methodNames[i];
				anItem = new StMenuItem(methodName, new MenuPerformer(this, "_performTestExampleMenu", new Object[] { aClass, methodName }));
				aMenu.add(anItem);
			}
		}

		return aMenu;
	}

	/**
	 * Spawn the test examples launcher.
	 * 
	 * @param aClass java.lang.Class
	 * @category private
	 */
	public void _spawnTestExamples(Class aClass) {
		try {
			JunTestExamples aTestExamples = (JunTestExamples) aClass.newInstance();
			aTestExamples.closeToExit(false);
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Perform a test example menu.
	 * 
	 * @param aClass java.lang.Class
	 * @param methodName java.lang.String
	 * @category private
	 */
	public void _performTestExampleMenu(Class aClass, String methodName) {
		try {
			StObject._Perform(aClass, methodName);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Open a JunLauncher.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		if (_ProcessArgs_(args) == false) {
			System.exit(0);
		}

		JunLauncher aLauncher = new JunLauncher();
		JunLauncherView aLauncherView = (JunLauncherView) aLauncher.defaultView();
		aLauncherView._openBanner(JunSystem.Logo());
		aLauncher.openView_(aLauncherView);
	}

	/**
	 * Process arguments - set object properties from the list of args.
	 *
	 * @param args java.lang.String[]
	 * @return boolean
	 * @category Main
	 */
	public static boolean _ProcessArgs_(String[] args) {
		if (args == null || args.length == 0) {
			return true;
		}

		try {
			for (int i = 0; i < args.length; i++) {
				if ("-help".equals(args[i]) || "help".equals(args[i])) {
					_PrintUsage();
					return false;
				} else if ("-view".equals(args[i])) {
					i++;
					if (i >= args.length) {
						throw new Exception("The -view parameter is missing.");
					}

					if ("AWT".equalsIgnoreCase(args[i])) {
						StApplicationModel.SetDefaultViewModeAwt();
					} else if ("Swing only".equalsIgnoreCase(args[i])) {
						StApplicationModel.SetDefaultViewModeSwingOnly();
					} else {
						UIManager.LookAndFeelInfo theInfo = null;
						UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
						for (int j = 0; j < info.length; j++) {
							if (info[j].getName().startsWith(args[i])) {
								theInfo = info[j];
							}
						}
						if (theInfo != null) {
							StApplicationModel.SetDefaultViewModeSwing(theInfo);
						} else {
							throw new Exception("Invalid Look&Feel name - " + args[i]);
						}
					}
				} else if ("-rendering".equals(args[i])) {
					i++;
					if (i >= args.length) {
						throw new Exception("The -rendering parameter is missing.");
					}

					String renderingMode = args[i].toUpperCase();
					if ("NOTHING".equalsIgnoreCase(renderingMode)) {
						JunSystem.SetDefaultRenderingMode(GLjRenderingMode.NOTHING);
					} else if ("SINGLE_BUFFER".equalsIgnoreCase(renderingMode)) {
						JunSystem.SetDefaultRenderingMode(GLjRenderingMode.SINGLE_BUFFER);
					} else if ("IMAGE".equalsIgnoreCase(renderingMode)) {
						JunSystem.SetDefaultRenderingMode(GLjRenderingMode.IMAGE);
					} else if ("DIRECT".equalsIgnoreCase(renderingMode)) {
						JunSystem.SetDefaultRenderingMode(GLjRenderingMode.DIRECT);
					} else if ("DOUBLE_BUFFER".equalsIgnoreCase(renderingMode)) {
						JunSystem.SetDefaultRenderingMode(GLjRenderingMode.DOUBLE_BUFFER);
					} else {
						throw new Exception("Invalid rendering mode - " + args[i]);
					}
				} else {
					throw new Exception("Invalid argument - " + args[i]);
				}
			}
		} catch (Exception e) {
			System.out.println(e.getMessage());
			_PrintUsage();
			return false;
		}

		return true;
	}

	/**
	 * Print this usage.
	 * 
	 * @category Usage
	 */
	public static void _PrintUsage() {
		System.out.println("Usage: java jp.co.sra.jun.system.support.JunLauncher {options}");
		System.out.println();
		System.out.println("  Options are:");
		System.out.println("    -help (or help)    Show this usage report.");

		System.out.println("    -view <type>       View mode. the <type> is selected from a menu of ");
		System.out.println("                       'Default View Mode' in JunLauncher :");
		System.out.println("                           AWT : AWT mode");
		UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
		if (infos.length > 0) {
			System.out.print("                           ");
			for (int i = 0; i < infos.length; i++) {
				System.out.print(infos[i].getName());
				if (i < infos.length - 1) {
					System.out.print(", ");
				}
			}
			System.out.println(" : Swing mode");
		}
		System.out.println("                           Swing only : Swing only mode.");

		System.out.println("    -rendering <type>  Rendering Mode :");
		System.out.println("                         NOTHING : nothing");
		System.out.println("                         SINGLE_BUFFER : single buffer");
		System.out.println("                         IMAGE : image");
		System.out.println("                         DIRECT : direct");
		System.out.println("                         DOUBLE_BUFFER : double buffer");
		System.out.println();

		System.out.println("By defalut, view mode is 'AWT' and rendering mode is 'double buffer'.");
	}

}
