package jp.co.sra.jun.system.framework;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSimpleDialog;

import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunDialog class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/03/17 (by nisinaka)
 *  @updated   2006/04/19 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun467 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDialog.java,v 8.11 2008/02/20 06:32:50 nisinaka Exp $
 */
public class JunDialog extends StSimpleDialog {

	/**
	 * Show the dialog for choosing.
	 * 
	 * @param messageString java.lang.String
	 * @param list java.lang.String[]
	 * @param listValues java.lang.Object[]
	 * @param maxLines int
	 * @param cancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Choose_(String messageString, String[] list, Object[] listValues, int maxLines, StBlockClosure cancelBlock) {
		return Choose_(messageString, list, listValues, null, null, maxLines, cancelBlock);
	}

	/**
	 * Show the dialog for choosing.
	 * 
	 * @param messageString java.lang.String
	 * @param list java.lang.String[]
	 * @param listValues java.lang.Object[]
	 * @param buttons java.lang.String[]
	 * @param buttonValues java.lang.Object[]
	 * @param maxLines int
	 * @param cancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Choose_(String messageString, String[] list, Object[] listValues, String[] buttons, Object[] buttonValues, int maxLines, StBlockClosure cancelBlock) {
		JunDialog aDialog = new JunDialog();
		return aDialog.choose_fromList_values_buttons_values_lines_cancel_(messageString, list, listValues, buttons, buttonValues, maxLines, cancelBlock);
	}

	/**
	 * Show the dialog for choosing.
	 * 
	 * @param messageString java.lang.String
	 * @param labels java.lang.String[]
	 * @param values java.lang.Object[]
	 * @param defaultValue java.lang.Object
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Choose_(String messageString, String[] labels, Object[] values, Object defaultValue) {
		JunDialog aDialog = new JunDialog();
		return aDialog.choose_labels_values_default_(messageString, labels, values, defaultValue);
	}

	/**
	 * Show the dialog for confirming.
	 *
	 * @param messageString java.lang.String
	 * @return boolean
	 * @category Utilities
	 */
	public static boolean Confirm_(String messageString) {
		return Confirm_(messageString, true);
	}

	/**
	 * Show the dialog for confirming.
	 *
	 * @param messageString java.lang.String
	 * @param initialAnswer boolean
	 * @return boolean
	 * @category Utilities
	 */
	public static boolean Confirm_(String messageString, boolean initialAnswer) {
		JunDialog aDialog = new JunDialog();
		Object result = aDialog.choose_labels_values_default_(messageString, new String[] { JunSystem.$String("Yes"), JunSystem.$String("No") }, new Object[] { Boolean.TRUE, Boolean.FALSE }, new Boolean(initialAnswer));
		return ((Boolean) result).booleanValue();
	}

	/**
	 * Show the dialog for requesting a user input.
	 *
	 * @param messageString java.lang.String
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String Request_(String messageString) {
		return Request_(messageString, new String());
	}

	/**
	 * Show the dialog for requesting a user input.
	 *
	 * @param messageString java.lang.String
	 * @param aString java.lang.String
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String Request_(String messageString, String aString) {
		JunDialog aDialog = new JunDialog();
		return (String) aDialog.request_initialAnswer_onCancel_(messageString, aString, null);
	}

	/**
	 * Show the dialog for warning.
	 *
	 * @param messageString java.lang.String
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Warn_(String messageString) {
		JunDialog aDialog = new JunDialog();
		aDialog.choose_labels_values_default_(messageString, new String[] { JunSystem.$String("Accept") }, new Object[] { null }, null);
		return null;
	}

	/**
	 * Answer the string for the accept button label.
	 *
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StSimpleDialog#_acceptButtonLabelString()
	 * @category interface opening
	 */
	protected String _acceptButtonLabelString() {
		return JunSystem.$String("Accept");
	}

	/**
	 * Answer the string for the cancel button label.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StSimpleDialog#_cancelButtonLabelString()
	 * @category interface opening
	 */
	protected String _cancelButtonLabelString() {
		return JunSystem.$String("Cancel");
	}

}
