package jp.co.sra.jun.system.framework;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

import jp.co.sra.smalltalk.StViewCanvas;

/**
 * JunAbstractViewCanvas class
 * 
 *  @author    nisinaka
 *  @created   2004/09/21 (by nisinaka)
 *  @updated   2006/04/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun579 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunAbstractViewCanvas.java,v 8.11 2008/02/20 06:32:50 nisinaka Exp $
 */
public abstract class JunAbstractViewCanvas extends StViewCanvas implements JunAbstractView {

	protected boolean _doubleBuffer;
	protected Image _doubleBufferImage;
	protected Graphics _doubleBufferGraphics;

	/**
	 * Create a new instance of JunAbstractViewCanvas.
	 * 
	 * @category Instance creation
	 */
	public JunAbstractViewCanvas() {
		super();
	}

	/**
	 * Create a new instance of JunAbstractViewCanvas.
	 * 
	 * @param newModel jp.co.sra.jun.system.framework.JunApplicationModel
	 * @category Instance creation
	 */
	public JunAbstractViewCanvas(JunApplicationModel newModel) {
		super(newModel);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewCanvas#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		_doubleBuffer = false;
		_doubleBufferImage = null;
		_doubleBufferGraphics = null;
	}

	/**
	 * Release the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StView#release()
	 * @category initialize-release
	 */
	public void release() {
		super.release();
		this._flushDoubleBuffer();
	}

	/**
	 * Set whether the receiver do the double buffering for its painting.
	 * 
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void _doubleBuffer(boolean aBoolean) {
		_doubleBuffer = aBoolean;
	}

	/**
	 * Answer the current image for the double buffering.
	 * 
	 * @return java.awt.Image
	 * @category accessing
	 */
	protected Image _doubleBufferImage() {
		if (_doubleBufferImage == null) {
			Dimension size = this.getSize();
			_doubleBufferImage = this.createImage(size.width, size.height);
		}
		return _doubleBufferImage;
	}

	/**
	 * Answer the current graphics for the double buffering.
	 * 
	 * @return java.awt.Graphics
	 * @category accessing
	 */
	protected Graphics _doubleBufferGraphics() {
		if (_doubleBufferGraphics == null) {
			_doubleBufferGraphics = this._doubleBufferImage().getGraphics();
		}
		return _doubleBufferGraphics;
	}

	/**
	 * Flush the double buffer when resized.
	 * 
	 * @param x int
	 * @param y int
	 * @param width int
	 * @param height int
	 * @see java.awt.Component#setBounds(int, int, int, int)
	 * @category bounds accessing
	 */
	public void setBounds(int x, int y, int width, int height) {
		this._flushDoubleBuffer();
		super.setBounds(x, y, width, height);
	}

	/**
	 * Flush the double buffer.
	 * 
	 * @category flushing
	 */
	protected void _flushDoubleBuffer() {
		if (_doubleBufferImage != null) {
			_doubleBufferImage.flush();
			_doubleBufferImage = null;
		}

		if (_doubleBufferGraphics != null) {
			_doubleBufferGraphics.dispose();
			_doubleBufferGraphics = null;
		}
	}

	/**
	 * Display the receiver on the graphics.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @see jp.co.sra.smalltalk.StDisplayable#displayOn_(java.awt.Graphics)
	 * @category displaying
	 */
	public void displayOn_(Graphics aGraphicsContext) {
		if (this.model() instanceof JunAbstractModel) {
			((JunAbstractModel)this.model()).displayOn_(aGraphicsContext);
		}
	}

	/**
	 * Paints the receiver.
	 * Do the double buffering when specified.
	 * 
	 * @param g java.awt.Graphics
	 * @see java.awt.Component#paint(java.awt.Graphics)
	 * @category displaying
	 */
	public void paint(Graphics g) {
		if (_doubleBuffer) {
			this._doubleBufferGraphics().clearRect(0, 0, this.getWidth(), this.getHeight());
			super.paint(this._doubleBufferGraphics());
			g.drawImage(this._doubleBufferImage(), 0, 0, this);
		} else {
			super.paint(g);
		}
	}

	/**
	 * Update this canvas.
	 * Override the method defined in Canvas to avoid clearing the canvas.
	 * 
	 * @param g java.awt.Graphics
	 * @see java.awt.Component#update(java.awt.Graphics)
	 * @category updating
	 */
	public void update(Graphics g) {
		if (_doubleBuffer) {
			this.paint(g);
		} else {
			super.update(g);
		}
	}

}
