package jp.co.sra.jun.system.framework;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.goodies.misc.JunSampleTriangle;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunAbstractModelTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2008/01/30 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunAbstractModelTestExamples.java,v 8.4 2008/02/20 06:32:50 nisinaka Exp $
 */
public class JunAbstractModelTestExamples extends JunTestExamples {
	/**
	 * Example1.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunAbstractModel aModel = new JunAbstractTestModel();
		aModel.open();

		return true;
	}

	/**
	 * Example2.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunAbstractModel aModel = new JunAbstractTestModel();

		aModel.displayBlock_(new StBlockClosure() {
			public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
				Graphics graphicsContext = (Graphics) obj1;
				StView aView = (StView) obj2;
				// StController aController = (StController) obj3;
				Rectangle viewBounds = aView.toComponent().getBounds();
				viewBounds.setLocation(0, 0);

				graphicsContext.setColor(Color.red);
				Rectangle insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-10, -10);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				graphicsContext.setColor(Color.green);
				insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-20, -20);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				graphicsContext.setColor(Color.blue);
				insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-30, -30);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				graphicsContext.setColor(Color.white);
				insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-40, -40);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				StImage anImage = JunSampleTriangle.Aoki();
				graphicsContext.drawImage(anImage.image(), (viewBounds.width - anImage.width()) / 2, (viewBounds.height - anImage.height()) / 2, null);
				return null;
			}
		});
		aModel.open();

		return true;
	}

	/**
	 * Example3.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunAbstractModel aModel = new JunAbstractTestModel();
		aModel.displayBlock_(new StBlockClosure() {
			public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
				Graphics graphicsContext = (Graphics) obj1;
				StView aView = (StView) obj2;
				// StController aController = (StController) obj3;
				Rectangle viewBounds = aView.toComponent().getBounds();
				viewBounds.setLocation(0, 0);

				graphicsContext.setColor(Color.red);
				Rectangle insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-10, -10);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				graphicsContext.setColor(Color.green);
				insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-20, -20);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				graphicsContext.setColor(Color.blue);
				insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-30, -30);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				graphicsContext.setColor(Color.white);
				insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-40, -40);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				StImage anImage = JunSampleTriangle.Aoki();
				graphicsContext.drawImage(anImage.image(), (viewBounds.width - anImage.width()) / 2, (viewBounds.height - anImage.height()) / 2, null);

				return null;
			}
		});
		aModel.open();

		try {
			Thread.sleep(3000);
		} catch (InterruptedException e) {
		}

		aModel.displayBlock_(new StBlockClosure() {
			public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
				Graphics graphicsContext = (Graphics) obj1;
				StView aView = (StView) obj2;
				// StController aController = (StController) obj3;
				Rectangle viewBounds = aView.toComponent().getBounds();
				viewBounds.setLocation(0, 0);

				graphicsContext.setColor(Color.cyan);
				Rectangle insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-10, -10);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				graphicsContext.setColor(Color.magenta);
				insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-20, -20);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				graphicsContext.setColor(Color.yellow);
				insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-30, -30);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				graphicsContext.setColor(Color.white);
				insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-40, -40);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				StImage anImage = JunSampleTriangle.Mickey();
				graphicsContext.drawImage(anImage.image(), (viewBounds.width - anImage.width()) / 2, (viewBounds.height - anImage.height()) / 2, null);

				return null;
			}
		});

		return true;
	}

	/**
	 * Example4.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunAbstractModel aModel = new JunAbstractTestModel();

		aModel.displayBlock_(new StBlockClosure() {
			public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
				Graphics graphicsContext = (Graphics) obj1;
				StView aView = (StView) obj2;
				// StController aController = (StController) obj3;
				Rectangle viewBounds = aView.toComponent().getBounds();
				viewBounds.setLocation(0, 0);

				graphicsContext.setColor(Color.red);
				Rectangle insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-10, -10);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				graphicsContext.setColor(Color.green);
				insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-20, -20);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				graphicsContext.setColor(Color.blue);
				insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-30, -30);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				graphicsContext.setColor(Color.white);
				insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-40, -40);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				StImage anImage = JunSampleTriangle.Aoki();
				graphicsContext.drawImage(anImage.image(), (viewBounds.width - anImage.width()) / 2, (viewBounds.height - anImage.height()) / 2, null);

				return null;
			}
		});

		Rectangle aBox = new Rectangle(100, 200, 300, 300);
		for (int i = 0; i < 3; i++) {
			aBox.translate(150, 50);
			aModel.openIn_(aBox);
		}

		try {
			Thread.sleep(3000);
		} catch (InterruptedException e) {
		}

		aModel.displayBlock_(new StBlockClosure() {
			public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
				Graphics graphicsContext = (Graphics) obj1;
				StView aView = (StView) obj2;
				// StController aController = (StController) obj3;
				Rectangle viewBounds = aView.toComponent().getBounds();
				viewBounds.setLocation(0, 0);

				graphicsContext.setColor(Color.cyan);
				Rectangle insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-10, -10);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				graphicsContext.setColor(Color.magenta);
				insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-20, -20);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				graphicsContext.setColor(Color.yellow);
				insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-30, -30);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				graphicsContext.setColor(Color.white);
				insetBounds = new Rectangle(viewBounds);
				insetBounds.grow(-40, -40);
				graphicsContext.fillRect(insetBounds.x, insetBounds.y, insetBounds.width, insetBounds.height);

				StImage anImage = JunSampleTriangle.Mickey();
				graphicsContext.drawImage(anImage.image(), (viewBounds.width - anImage.width()) / 2, (viewBounds.height - anImage.height()) / 2, null);

				return null;
			}
		});

		return true;
	}

	/**
	 * Execute the test examples.
	 *
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunAbstractModelTestExamples();
	}

	/**
	 * JunAbstractTestModel class
	 */
	public static class JunAbstractTestModel extends JunAbstractModel {
		/**
		 * Answer the receiver's default view.
		 * 
		 * @return jp.co.sra.smalltalk.StView
		 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
		 * @category defaults
		 */
		public StView defaultView() {
			if (GetDefaultViewMode() == VIEW_AWT) {
				return new JunAbstractViewCanvas(this) {
					protected void buildComponent() {
						this.setSize(new Dimension(300, 300));
					}
				};
			} else {
				return new JunAbstractViewJPanel(this) {
					protected void buildComponent() {
						this.setPreferredSize(new Dimension(300, 300));
					}
				};
			}
		}
	}
}
