package jp.co.sra.jun.system.dialog;

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.WindowSpecLayout;

/**
 * JunTextInputFieldViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2006/10/16 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTextInputFieldViewSwing.java,v 8.11 2008/02/20 06:32:50 nisinaka Exp $
 */
public class JunTextInputFieldViewSwing extends JunPopUpDialogViewSwing implements JunTextInputFieldView {

	protected JTextField textField;

	/**
	 * Create a new instance of JunTextInputFieldViewSwing and initialize it.
	 *
	 * @param aTextInputField jp.co.sra.jun.system.dialog.JunTextInputField
	 * @category Instance creation
	 */
	public JunTextInputFieldViewSwing(JunTextInputField aTextInputField) {
		super(aTextInputField);
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.textField(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, 0));
		this.setPreferredSize(new Dimension(200, 24));
	}

	/**
	 * Answer my model as JunTextInputField.
	 * 
	 * @return jp.co.sra.jun.system.dialog.JunTextInputField
	 * @see jp.co.sra.jun.system.dialog.JunTextInputFieldView#getTextInputField()
	 * @category model accessing
	 */
	public JunTextInputField getTextInputField() {
		return (JunTextInputField) this.model();
	}

	/**
	 * Answer my focused component.
	 * 
	 * @return java.awt.Component
	 * @see jp.co.sra.jun.system.dialog.JunPopUpDialogViewSwing#_focusedComponent()
	 * @category user interface
	 */
	public Component _focusedComponent() {
		return this.textField();
	}

	/**
	 * Answer the text field.
	 * 
	 * @return javax.swing.JTextField
	 * @category user interface
	 */
	protected JTextField textField() {
		if (textField == null) {
			textField = new JTextField();
			textField.setText(this.getTextInputField().string());
			textField.setBorder(new EmptyBorder(0, 0, 0, 0));
			textField.setHorizontalAlignment(JTextField.CENTER);
			textField.selectAll();
			textField.getDocument().addDocumentListener(new DocumentListener() {
				public void changedUpdate(DocumentEvent e) {
					// nothing to do
				}

				public void insertUpdate(DocumentEvent e) {
					getTextInputField().string_(textField.getText());
				}

				public void removeUpdate(DocumentEvent e) {
					getTextInputField().string_(textField.getText());
				}
			});

			this.getTextInputField().textHolder().addDependentListener(new DependentListener() {
				public void update_(DependentEvent evt) {
					String aString = getTextInputField().string();
					if (textField.getText().equals(aString) == false) {
						textField.setText(aString);
					}
				}
			});
		}
		return textField;
	}

}
