package jp.co.sra.jun.system.dialog;

import java.awt.Point;

import jp.co.sra.smalltalk.StRectangle;

import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.utilities.JunSensorUtility;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunPopUpDialogTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/10/16 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPopUpDialogTestExamples.java,v 8.10 2008/02/20 06:32:50 nisinaka Exp $
 */
public class JunPopUpDialogTestExamples extends JunTestExamples {

	/**
	 * Example:
	 * 
	 * @return boolean
	 */
	public static boolean Example() {
		Point aPoint = null;

		JunCursors cursor = new JunCursors(JunCursors.LeftClickMouseCursor());
		try {
			cursor._show();

			aPoint = JunSensorUtility.WaitClickButton();

		} finally {
			cursor._restore();
		}

		StRectangle aBox = new StRectangle(0, 0, 150, 24);
		aBox = aBox.align_with_(aBox.center(), aPoint);

		JunPopUpDialog aDialog = new JunPopUpDialog();
		aDialog.popUpIn_(aBox);

		return true;
	}

	/**
	 * Execute the test examples.
	 *
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunPopUpDialogTestExamples();
	}

}
