package jp.co.sra.jun.system.dialog;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.SwingUtilities;

import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSimpleDialog;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.SystemInterface;

/**
 * JunPopUpDialog class
 * 
 *  @author    nisinaka
 *  @created   2006/10/16 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPopUpDialog.java,v 8.17 2008/02/20 06:32:50 nisinaka Exp $
 */
public class JunPopUpDialog extends StSimpleDialog implements KeyEventDispatcher {

	protected Component _viewComponent;

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StSimpleDialog#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		_viewComponent = null;
	}

	/**
	 * Answer my value.
	 * 
	 * @return java.lang.Object
	 * @category accessing
	 */
	public Object answer() {
		return this;
	}

	/**
	 * Answer my current view component.
	 * 
	 * @return java.awt.Component
	 * @category accessing
	 */
	protected Component _viewComponent() {
		return _viewComponent;
	}

	/**
	 * Popup the receiver.
	 * 
	 * @category interface opening
	 */
	public void popUp() {
		this.popUpIn_((StRectangle) null);
	}

	/**
	 * Popup the receiver for the view.
	 * 
	 * @param aComponent java.awt.Component
	 * @category interface opening
	 */
	public void popUpForView_(Component aComponent) {
		this.popUpIn_forView_((StRectangle) null, aComponent);
	}

	/**
	 * Popup the receiver in the specified size and place.
	 * 
	 * @param aRectangle java.awt.Rectangle
	 * @category interface opening
	 */
	public void popUpIn_(Rectangle aRectangle) {
		StRectangle theRectangle = (aRectangle == null) ? null : new StRectangle(aRectangle);
		this.popUpIn_(theRectangle);
	}

	/**
	 * Popup the receiver in the specified size and place.
	 * 
	 * @param aRectangle jp.co.sra.smalltalk.StRectangle
	 * @category interface opening
	 */
	public void popUpIn_(StRectangle aRectangle) {
		if (aRectangle == null) {
			aRectangle = new StRectangle(this.minimumWindowExtent());
			aRectangle = aRectangle.align_with_(aRectangle.center(), SystemInterface._MousePoint());
		}

		StRectangle displayRectangle = new StRectangle(aRectangle.extent());
		displayRectangle = displayRectangle.merge_(new StRectangle(this.minimumWindowExtent()));
		displayRectangle = displayRectangle.align_with_(displayRectangle.center(), aRectangle.center());

		Dialog aDialog = this.allButOpenDialog((JunPopUpDialogView) this.defaultView());
		aDialog.addWindowListener(new WindowAdapter() {
			public void windowOpened(WindowEvent e) {
				KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(JunPopUpDialog.this);
			}

			public void windowClosed(WindowEvent e) {
				KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(JunPopUpDialog.this);
				synchronized (JunPopUpDialog.this) {
					JunPopUpDialog.this.notifyAll();
				}
			}
		});

		aDialog.setBounds(displayRectangle.toRectangle());
		aDialog.setVisible(true);

		try {
			if (EventQueue.isDispatchThread()) {
				EventQueue theQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
				while (aDialog.isVisible()) {
					AWTEvent event = theQueue.getNextEvent();
					Object src = event.getSource();
					if (event instanceof ActiveEvent) {
						((ActiveEvent) event).dispatch();
					} else if (src instanceof Component) {
						((Component) src).dispatchEvent(event);
					} else if (src instanceof MenuComponent) {
						((MenuComponent) src).dispatchEvent(event);
					} else {
						System.err.println("unable to dispatch event: " + event);
					}
				}
			} else {
				synchronized (this) {
					this.wait();
				}
			}
		} catch (InterruptedException e) {
		}
	}

	/**
	 * Popup the receiver for the view.
	 * 
	 * @param aRectangle java.awt.Rectangle
	 * @param aComponent java.awt.Component
	 * @category interface opening
	 */
	public void popUpIn_forView_(Rectangle aRectangle, Component aComponent) {
		StRectangle theRectangle = (aRectangle == null) ? null : new StRectangle(aRectangle);
		this.popUpIn_forView_(theRectangle, aComponent);
	}

	/**
	 * Popup the receiver for the view.
	 * 
	 * @param aRectangle jp.co.sra.smalltalk.StRectangle
	 * @param aComponent java.awt.Component
	 * @category interface opening
	 */
	public void popUpIn_forView_(StRectangle aRectangle, Component aComponent) {
		if (aComponent == null) {
			this.popUpIn_(aRectangle);
			return;
		}

		_viewComponent = aComponent;

		if (aRectangle == null) {
			aRectangle = new StRectangle(aComponent.getBounds());
		}
		Point aPoint = new Point(0, 0);
		SwingUtilities.convertPointToScreen(aPoint, aComponent);
		aRectangle = aRectangle.translatedBy_(aPoint.x, aPoint.y);

		this.popUpIn_(aRectangle);
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunPopUpDialogViewAwt(this) {
				public Insets getInsets() {
					return new Insets(5, 5, 5, 5);
				}
			};
		} else {
			return new JunPopUpDialogViewSwing(this) {
				public Insets getInsets() {
					return new Insets(5, 5, 5, 5);
				}
			};
		}
	}

	/**
	 * Dispatch the key event.
	 * 
	 * @param e java.awt.event.KeyEvent
	 * @see java.awt.KeyEventDispatcher#dispatchKeyEvent(java.awt.event.KeyEvent)
	 * @category keyboard
	 */
	public boolean dispatchKeyEvent(KeyEvent e) {
		if (e.getID() != KeyEvent.KEY_PRESSED) {
			return false;
		}

		int keyCode = e.getKeyCode();
		if (keyCode == KeyEvent.VK_ESCAPE) {
			this.closeByESC();
			return true;
		} else if (keyCode == KeyEvent.VK_ENTER) {
			this.closeByCR();
			return true;
		} else if (this.checkCharacter_(e.getKeyChar()) == false) {
			return true;
		}

		return false;
	}

	/**
	 * Close the receiver caused by the ESC key.
	 * 
	 * @category private
	 */
	protected void closeByESC() {
		this.actionByESC();
		this.close();
	}

	/**
	 * Action when closing by the ESC key.
	 * 
	 * @category private
	 */
	protected void actionByESC() {
		// nothing to do
	}

	/**
	 * Close the receiver caused by the ENTER key.
	 * 
	 * @category private
	 */
	protected void closeByCR() {
		this.actionByCR();
		this.close();
	}

	/**
	 * Action when closing by the ENTER key.
	 * 
	 * @category private
	 */
	protected void actionByCR() {
		// nothing to do
	}

	/**
	 * Close the receiver caused by the mouse click.
	 * 
	 * @category private
	 */
	protected void closeByClick() {
		this.actionByClick();
		this.close();
	}

	/**
	 * Action when closing by the mouse click.
	 * 
	 * @category private
	 */
	protected void actionByClick() {
		// nothing to do
	}

	/**
	 * Check for the character.
	 * 
	 * @param keyChar char
	 * @return boolean
	 * @category private 
	 */
	protected boolean checkCharacter_(char keyChar) {
		return true;
	}

	/**
	 * Answer the minimum window extent.
	 * 
	 * @return java.awt.Dimension
	 * @category private
	 */
	protected Dimension minimumWindowExtent() {
		return new Dimension(16, 16);
	}

}
