package jp.co.sra.jun.opengl.texture;

import java.awt.Color;
import java.awt.Image;
import java.util.Vector;

import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.SystemResourceSupport;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOpenGLTextureTestExamples class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1998/11/19 (by Hirotsugu Kondo)
 *  @updated   2000/11/13 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on Jun660 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLTextureTestExamples.java,v 8.11 2008/02/20 06:32:50 nisinaka Exp $
 */
public class JunOpenGLTextureTestExamples extends JunTestExamples {

	private static Image _SmalltalkBalloon = null;
	private static Image _Earth = null;
	private static Image _Earth1 = null;
	private static Image _Earth2 = null;
	private static Image _Earth3 = null;

	/**
	 * Example1: Get an image from user and put it on a polygon as a texture.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		StImage anImage = StImage._FromUser();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(0, 0), new Jun2dPoint(1, 0), new Jun2dPoint(1, 1), new Jun2dPoint(0, 1) });
		JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0, -1, 0), new Jun3dPoint(0, 1, 0), new Jun3dPoint(-2, 1, 0), new Jun3dPoint(-2, -1, 0) });
		aPolygon.texture_(aTexture);
		aPolygon.show();

		return true;
	}

	/**
	 * Example2: Get an image from user and put it on a polygon as a texture.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		StImage anImage = StImage._FromUser();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(0, 0), new Jun2dPoint(1, 0), new Jun2dPoint(1, 1), new Jun2dPoint(0, 1) });
		JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0, -1, 0), new Jun3dPoint(0, 1, 0), new Jun3dPoint(-2, 1, 0), new Jun3dPoint(-2, -1, 0) });
		aPolygon.paint_(Color.gray);
		aPolygon.texture_(aTexture);
		aPolygon.show();

		return true;
	}

	/**
	 * Example3: display textured images.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Image anImage = JunOpenGLTextureTestExamples.ImageSmalltalkBalloon();
		JunOpenGLTexture aTexture1 = new JunOpenGLTexture(anImage);
		Jun2dPoint[] coordinates1 = new Jun2dPoint[4];
		coordinates1[0] = new Jun2dPoint(0.0, 0.0);
		coordinates1[1] = new Jun2dPoint(0.0, 1.0);
		coordinates1[2] = new Jun2dPoint(1.0, 1.0);
		coordinates1[3] = new Jun2dPoint(1.0, 0.0);
		aTexture1.coordinates_(coordinates1);

		Jun3dPoint[] vertexes = new Jun3dPoint[4];
		vertexes[0] = new Jun3dPoint(-2.0, -1.0, 0.0);
		vertexes[1] = new Jun3dPoint(-2.0, 1.0, 0.0);
		vertexes[2] = new Jun3dPoint(0.0, 1.0, 0.0);
		vertexes[3] = new Jun3dPoint(0.0, -1.0, 0.0);

		JunOpenGL3dPolygon aPolygon1 = new JunOpenGL3dPolygon(vertexes);
		aPolygon1.texture_(aTexture1);

		JunOpenGLTexture aTexture2 = new JunOpenGLTexture(anImage);
		Jun2dPoint[] coordinates2 = new Jun2dPoint[4];
		coordinates2[0] = new Jun2dPoint(0.0, 0.0);
		coordinates2[1] = new Jun2dPoint(1.0, 0.0);
		coordinates2[2] = new Jun2dPoint(1.0, 1.0);
		coordinates2[3] = new Jun2dPoint(0.0, 1.0);
		aTexture2.coordinates_(coordinates2);

		Jun3dPoint[] vertexes2 = new Jun3dPoint[4];
		vertexes2[0] = new Jun3dPoint(1.0, -1.0, 0.0);
		vertexes2[1] = new Jun3dPoint(1.0, 1.0, 0.0);
		vertexes2[2] = new Jun3dPoint(2.41421, 1.0, -1.41421);
		vertexes2[3] = new Jun3dPoint(2.41421, -1.0, -1.41421);

		JunOpenGL3dPolygon aPolygon2 = new JunOpenGL3dPolygon(vertexes2);
		aPolygon2.texture_(aTexture2);

		JunOpenGL3dCompoundObject dObject = new JunOpenGL3dCompoundObject();
		dObject.add_(aPolygon1);
		dObject.add_(aPolygon2);
		dObject.show();

		return true;
	}

	/**
	 * Example: display textured images.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		Image anImage = JunOpenGLTextureTestExamples.ImageSmalltalkBalloon();
		JunOpenGLTexture aTexture1 = new JunOpenGLTexture(anImage);
		Jun2dPoint[] coordinates1 = new Jun2dPoint[4];
		coordinates1[0] = new Jun2dPoint(0.25, 0.25);
		coordinates1[1] = new Jun2dPoint(0.25, 0.75);
		coordinates1[2] = new Jun2dPoint(0.75, 0.75);
		coordinates1[3] = new Jun2dPoint(0.75, 0.25);
		aTexture1.coordinates_(coordinates1);

		Jun3dPoint[] vertexes = new Jun3dPoint[4];
		vertexes[0] = new Jun3dPoint(-2.0, -1.0, 0.0);
		vertexes[1] = new Jun3dPoint(-2.0, 1.0, 0.0);
		vertexes[2] = new Jun3dPoint(0.0, 1.0, 0.0);
		vertexes[3] = new Jun3dPoint(0.0, -1.0, 0.0);

		JunOpenGL3dPolygon aPolygon1 = new JunOpenGL3dPolygon(vertexes);
		aPolygon1.texture_(aTexture1);

		JunOpenGLTexture aTexture2 = new JunOpenGLTexture(anImage);
		Jun2dPoint[] coordinates2 = new Jun2dPoint[4];
		coordinates2[0] = new Jun2dPoint(0.0, 0.0);
		coordinates2[1] = new Jun2dPoint(1.0, 0.0);
		coordinates2[2] = new Jun2dPoint(1.0, 1.0);
		coordinates2[3] = new Jun2dPoint(0.0, 1.0);
		aTexture2.coordinates_(coordinates2);

		Jun3dPoint[] vertexes2 = new Jun3dPoint[4];
		vertexes2[0] = new Jun3dPoint(1.0, -1.0, 0.0);
		vertexes2[1] = new Jun3dPoint(1.0, 1.0, 0.0);
		vertexes2[2] = new Jun3dPoint(2.41421, 1.0, -1.41421);
		vertexes2[3] = new Jun3dPoint(2.41421, -1.0, -1.41421);

		JunOpenGL3dPolygon aPolygon2 = new JunOpenGL3dPolygon(vertexes2);
		aPolygon2.texture_(aTexture2);

		JunOpenGL3dCompoundObject dObject = new JunOpenGL3dCompoundObject();
		dObject.add_(aPolygon1);
		dObject.add_(aPolygon2);
		dObject.show();

		return true;
	}

	/**
	 * Example: display textured images.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		Image anImage = JunOpenGLTextureTestExamples.ImageEarth();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		Jun2dPoint[] coordinates = new Jun2dPoint[4];
		coordinates[0] = new Jun2dPoint(0.0, 0.0);
		coordinates[1] = new Jun2dPoint(1.0, 0.0);
		coordinates[2] = new Jun2dPoint(1.0, 1.0);
		coordinates[3] = new Jun2dPoint(0.0, 1.0);
		aTexture.coordinates_(coordinates);

		JunOpenGL3dObject anObject = JunOpenGL3dObject.Cube();
		anObject.texture_(aTexture);
		anObject.show();

		return true;
	}

	/**
	 * Example: display textured images.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		Image anImage = JunOpenGLTextureTestExamples.ImageSmalltalkBalloon();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		Jun2dPoint[] xyPoints = new Jun2dPoint[4];
		xyPoints[0] = new Jun2dPoint(0.0, 0.0);
		xyPoints[1] = new Jun2dPoint(1.0, 0.0);
		xyPoints[2] = new Jun2dPoint(1.0, 1.0);
		xyPoints[3] = new Jun2dPoint(0.0, 1.0);
		aTexture.coordinates_(xyPoints);

		JunOpenGL3dObject anObject = JunOpenGL3dObject.Cube();
		anObject.texture_(aTexture);
		anObject.show();

		return true;
	}

	/**
	 * Example: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7() {
		JunOpenGLTexture aTexture = new JunOpenGLTexture(JunOpenGLTextureTestExamples.ImageSmalltalkBalloon());
		aTexture.linear_(true);
		aTexture.repeat_(true);

		JunOpenGL3dObject aCube = JunOpenGL3dObject.Cube();
		aCube.texture_(aTexture);
		aCube.name_("balloon");
		aCube.show();

		return true;
	}

	/**
	 * Example: display textured images.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8() {
		JunOpenGL3dObject anObject = JunOpenGL3dObject.Globe_(10);
		Image anImage = JunOpenGLTextureTestExamples.ImageEarth();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		anObject.texture_(aTexture);
		anObject.show();

		return true;
	}

	/**
	 * Example: display textured images.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example9() {
		Object[] xyPointsAndSphere = JunOpenGL3dObject.XyPointsAndSphere_radius_longitude_latitude_(30, 1, 360, 180);
		Vector points = (Vector) xyPointsAndSphere[0];
		Jun2dPoint[] xyPoints = new Jun2dPoint[points.size()];

		for (int index = 0; index < points.size(); index++) {
			Jun2dPoint aPoint = (Jun2dPoint) points.elementAt(index);
			xyPoints[index] = new Jun2dPoint(aPoint.x(), 1 - aPoint.y());
		}

		JunOpenGL3dCompoundObject anObject = (JunOpenGL3dCompoundObject) xyPointsAndSphere[1];
		Image anImage = JunOpenGLTextureTestExamples.ImageEarth();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		aTexture.coordinates_(xyPoints);
		anObject.texture_(aTexture);
		anObject.show();

		return true;
	}

	/**
	 * Sample image - Earth.
	 * 
	 * @return java.awt.Image
	 * @category Image accessing
	 */
	public static final Image ImageEarth() {
		if (_Earth == null) {
			_Earth = SystemResourceSupport.createImage("/jp/co/sra/jun/opengl/texture/imageEarth.jpg");
		}

		return _Earth;
	}

	/**
	 * Sample image - Earth1.
	 * 
	 * @return java.awt.Image
	 * @category Image accessing
	 */
	public static final Image ImageEarth1() {
		if (_Earth1 == null) {
			_Earth1 = SystemResourceSupport.createImage("/jp/co/sra/jun/opengl/texture/imageEarth1.jpg");
		}

		return _Earth1;
	}

	/**
	 * Sample image - Earth2.
	 * 
	 * @return java.awt.Image
	 * @category Image accessing
	 */
	public static final Image ImageEarth2() {
		if (_Earth2 == null) {
			_Earth2 = SystemResourceSupport.createImage("/jp/co/sra/jun/opengl/texture/imageEarth2.jpg");
		}

		return _Earth2;
	}

	/**
	 * Sample image - Earth3.
	 * 
	 * @return java.awt.Image
	 * @category Image accessing
	 */
	public static final Image ImageEarth3() {
		if (_Earth3 == null) {
			_Earth3 = SystemResourceSupport.createImage("/jp/co/sra/jun/opengl/texture/imageEarth3.jpg");
		}

		return _Earth3;
	}

	/**
	 * Sample image - SmalltalkBalloon.
	 * 
	 * @return java.awt.Image
	 * @category Image accessing
	 */
	public static final Image ImageSmalltalkBalloon() {
		if (_SmalltalkBalloon == null) {
			_SmalltalkBalloon = SystemResourceSupport.createImage("/jp/co/sra/jun/opengl/texture/imageSmalltalkBalloon.jpg");
		}

		return _SmalltalkBalloon;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunOpenGLTextureTestExamples();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample1a() {
		JunOpenGL3dPolygon aPolygon;
		Image anImage;
		JunOpenGLTexture aTexture;

		aPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
		anImage = JunOpenGLTextureTestExamples.ImageSmalltalkBalloon();
		aTexture = new JunOpenGLTexture(anImage);
		aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(0.0, 0.0), new Jun2dPoint(1.0, 0.0), new Jun2dPoint(1.0, 1.0), new Jun2dPoint(0.0, 1.0) });
		aPolygon.texture_(aTexture);
		aPolygon.show();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample1b() {
		JunOpenGL3dPolygon aPolygon;
		Image anImage;
		JunOpenGLTexture aTexture;

		aPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
		anImage = JunOpenGLTextureTestExamples.ImageSmalltalkBalloon();
		aTexture = new JunOpenGLTexture(anImage);
		aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(0.0, 0.0), new Jun2dPoint(2.0, 0.0), new Jun2dPoint(2.0, 2.0), new Jun2dPoint(0.0, 2.0) });
		aTexture.repeat_(true);
		aPolygon.texture_(aTexture);
		aPolygon.show();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample1c() {
		JunOpenGL3dPolygon aPolygon;
		Image anImage;
		JunOpenGLTexture aTexture;

		aPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
		anImage = JunOpenGLTextureTestExamples.ImageSmalltalkBalloon();
		aTexture = new JunOpenGLTexture(anImage);
		aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(0.0, 0.0), new Jun2dPoint(2.0, 0.0), new Jun2dPoint(2.0, 2.0), new Jun2dPoint(0.0, 2.0) });
		aTexture.clamp_(true);
		aPolygon.texture_(aTexture);
		aPolygon.show();

		return true;
	}
}
