package jp.co.sra.jun.opengl.rotation;

import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.goodies.lisp.*;
import jp.co.sra.smalltalk.*;

/**
 * JunOpenGLRotationPolyline class
 * 
 *  @author    nisinaka
 *  @created   1998/12/09 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLRotationPolyline.java,v 8.10 2008/02/20 06:32:49 nisinaka Exp $
 */
public class JunOpenGLRotationPolyline extends StModel {
	/** The collection of vertices. */
	protected Vector vertices = new Vector();

	/** The flag is true if the polyline make a loop. */
	protected boolean loop = false;

	/**
	 * The default constructor.
	 */
	public JunOpenGLRotationPolyline() {
		super();
	}

	/**
	 * Create a new instance of JunOpenGLRotationPolyline and initialize it.
	 * 
	 * @param arrayOfJun2dPoint jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 */
	public JunOpenGLRotationPolyline(Jun2dPoint[] arrayOfJun2dPoint) {
		this();
		this.addAll_(arrayOfJun2dPoint);
	}

	/**
	 * Create a new instance of JunOpenGLRotationPolyline and initialize it.
	 * 
	 * @param arrayOfJun2dPoint jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @param aBoolean boolean
	 */
	public JunOpenGLRotationPolyline(Jun2dPoint[] arrayOfJun2dPoint, boolean aBoolean) {
		this();
		this.addAll_(arrayOfJun2dPoint);
		this.loop_(aBoolean);
	}

	/**
	 * Create a new instance of JunOpenGLRotationPolyline and initialize it
	 * with the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispCons
	 * 
	 * @return jp.co.sra.jun.opengl.rotation.JunOpenGLRotationPolyline
	 */
	public static JunOpenGLRotationPolyline FromLispList_(JunLispCons aList) {
		if (aList.head() != KindName()) {
			throw SmalltalkException.Error("unexpected error");
		}

		JunOpenGLRotationPolyline aPolyline = new JunOpenGLRotationPolyline();
		aPolyline.fromLispList_(aList);

		return aPolyline;
	}

	/**
	 * Answer the string name which represents the kind of this class.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 */
	public static StSymbol KindName() {
		return $("JunOpenGLRotationPolyline");
	}

	/**
	 * Add the vertex to the receiver.
	 * 
	 * @param aJun2dPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 */
	public Jun2dPoint add_(Jun2dPoint aJun2dPoint) {
		this.vertices().addElement(aJun2dPoint);
		this.changed_($("vertices"));

		return aJun2dPoint;
	}

	/**
	 * Add the vertex right before the specified index.
	 * 
	 * @param aJun2dPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param index int
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 */
	public Jun2dPoint add_beforeIndex_(Jun2dPoint aJun2dPoint, int index) {
		this.vertices().insertElementAt(aJun2dPoint, index);
		this.changed_($("vertices"));

		return aJun2dPoint;
	}

	/**
	 * Add all points of arrayOfJun2dPoint.
	 * 
	 * @param arrayOfJun2dPoint jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 */
	public Jun2dPoint[] addAll_(Jun2dPoint[] arrayOfJun2dPoint) {
		for (int i = 0; i < arrayOfJun2dPoint.length; i++) {
			this.vertices().addElement(arrayOfJun2dPoint[i]);
		}

		this.changed_($("vertices"));

		return arrayOfJun2dPoint;
	}

	/**
	 * Answer the Jun2dPoint with the specified index.
	 * 
	 * @param index int
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 */
	public Jun2dPoint at_(int index) {
		return (Jun2dPoint) this.vertices().elementAt(index);
	}

	/**
	 * Put the Jun2dPoint at the index .
	 * 
	 * @param anIndex int
	 * @param aJun2dPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 */
	public void at_put_(int anIndex, Jun2dPoint aJun2dPoint) {
		this.vertices().setElementAt(aJun2dPoint, anIndex);
		this.changed_($("vertices"));
	}

	/**
	 * Enumerate all edges and evaluate the StBlockClosure.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * 
	 * @return java.lang.Object
	 */
	public Object edgesDo_(StBlockClosure aBlock) {
		return this.edgesDo_flag_(aBlock, 0);
	}

	/**
	 * Answer the first vertex of the receiver.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 */
	public Jun2dPoint first() {
		return this.at_(0);
	}

	/**
	 * Initialize the attributes of the receiver with the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispCons
	 */
	public void fromLispList_(JunLispCons aList) {
		if (aList.head() != this.kindName()) {
			throw SmalltalkException.Error("unexpected error");
		}

		final JunOpenGLRotationPolyline self = this;
		((JunLispList) aList.tail()).do_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunLispCons each = (JunLispCons) anObject;

				if (each.head() == $("loop")) {
					self.loop_(((Boolean) each.tail()).booleanValue());
				}

				if (each.head() == $("points")) {
					((JunLispList) each.tail()).do_(new StBlockClosure() {
						public Object value_(Object point) {
							self.add_((Jun2dPoint) point);

							return null;
						}
					});
				}

				return null;
			}
		});
	}

	/**
	 * Answer the string name which represents the kind of the object.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 */
	public StSymbol kindName() {
		return KindName();
	}

	/**
	 * Answer the last vertex of the receiver.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 */
	public Jun2dPoint last() {
		return this.at_(this.size() - 1);
	}

	/**
	 * Answer true if the receiver makes a loop, otherwise false.
	 * 
	 * @return boolean
	 */
	public boolean loop() {
		return loop;
	}

	/**
	 * Set the flag whether the receiver makes a loop or not.
	 * 
	 * @param aBoolean boolean
	 */
	public void loop_(boolean aBoolean) {
		loop = aBoolean;
		this.changed_($("loop"));
	}

	/**
	 * Convert the flag loop to a JunLispList.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 */
	public JunLispList loopToLispList() {
		return new JunLispCons($("loop"), new Boolean(this.loop()));
	}

	/**
	 * Remove the vertex at the specified index.
	 * 
	 * @param anIndex int
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 */
	public Jun2dPoint removeAtIndex_(int anIndex) {
		Jun2dPoint aVertex = (Jun2dPoint) this.vertices().elementAt(anIndex);
		this.vertices().removeElementAt(anIndex);
		this.changed_($("vertices"));

		return aVertex;
	}

	/**
	 * Reverse the order of vertices.
	 * 
	 * @return java.util.Vector
	 */
	public Vector reverseVertices() {
		Vector oldVertices = this.vertices();
		int size = oldVertices.size();
		vertices = new Vector(size);

		for (int i = 0; i < size; i++) {
			vertices.addElement(oldVertices.elementAt(size - i - 1));
		}

		this.changed_($("vertices"));

		return oldVertices;
	}

	/**
	 * Answer the number of vertices.
	 * 
	 * @return int
	 */
	public int size() {
		return this.vertices().size();
	}

	/**
	 * Answer the list representation of the JunOpenGLRotationPolyline.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 */
	public JunLispList toLispList() {
		JunLispCons list = JunLispCons.Cell();
		list.head_(this.kindName());
		list.add_(this.loopToLispList());
		list.add_(this.verticesToLispList());

		return list;
	}

	/**
	 * Answer the Vector of vertices.
	 * 
	 * @return java.util.Vector
	 */
	public Vector vertices() {
		return vertices;
	}

	/**
	 * Enumerate all vertices and evaluate the StBlockClosure.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * 
	 * @return java.lang.Object
	 */
	public Object verticesDo_(StBlockClosure aBlock) {
		Jun2dPoint[] anArray = this._verticesAsArray();

		for (int i = 0; i < anArray.length; i++) {
			Object result = aBlock.value_(anArray[i]);

			if (result != null) {
				return result;
			}
		}

		return null;
	}

	/**
	 * Convert the vertices to a JunLispList.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 */
	public JunLispList verticesToLispList() {
		return new JunLispCons($("points"), JunLispCons.List_(this.vertices()));
	}

	/**
	 * Convert the vertices as an array of Jun2dPoint.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 */
	protected Jun2dPoint[] _verticesAsArray() {
		int size = this.size();
		Jun2dPoint[] anArray = new Jun2dPoint[size];
		vertices.copyInto(anArray);

		return anArray;
	}

	/**
	 * Enumerate all edges and evaluate the StBlockClosure.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param aFlag int
	 * 
	 * @return java.lang.Object
	 */
	protected Object edgesDo_flag_(StBlockClosure aBlock, int aFlag) {
		int size = this.size();

		if (size > 0) {
			Jun2dPoint firstPoint = this.first();
			Jun2dPoint lastPoint = this.last();
			Object result = null;

			if (this.loop()) {
				if (aFlag == 1) {
					result = aBlock.value_(new Jun2dLine((Jun2dPoint) firstPoint.plus_(lastPoint).dividedBy_(2), firstPoint));
				} else if (aFlag == 2) {
					result = aBlock.value_(new Jun2dLine(lastPoint, firstPoint));
				}

				if (result != null) {
					return result;
				}
			} else {
				if (aFlag == 2) {
					result = aBlock.value_(new Jun2dLine(new Jun2dPoint(lastPoint.x(), 0), new Jun2dPoint(firstPoint.x(), 0)));

					if (result != null) {
						return result;
					}
				}

				result = aBlock.value_(new Jun2dLine(new Jun2dPoint(firstPoint.x(), 0), firstPoint));

				if (result != null) {
					return result;
				}
			}

			for (int i = 0; i < (size - 1); i++) {
				result = aBlock.value_(new Jun2dLine(this.at_(i), this.at_(i + 1)));

				if (result != null) {
					return result;
				}
			}

			if (this.loop()) {
				if (aFlag == 1) {
					result = aBlock.value_(new Jun2dLine(lastPoint, (Jun2dPoint) firstPoint.plus_(lastPoint).dividedBy_(2)));
				} else {
					result = aBlock.value_(new Jun2dLine(lastPoint, firstPoint));
				}

				if (result != null) {
					return result;
				}
			} else {
				result = aBlock.value_(new Jun2dLine(lastPoint, new Jun2dPoint(lastPoint.x(), 0)));

				if (result != null) {
					return result;
				}

				if (aFlag == 2) {
					result = aBlock.value_(new Jun2dLine(new Jun2dPoint(lastPoint.x(), 0), new Jun2dPoint(firstPoint.x(), 0)));

					if (result != null) {
						return result;
					}
				}
			}
		}

		return null;
	}
}
