package jp.co.sra.jun.opengl.picking;

import java.awt.Graphics;
import java.awt.Point;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.gl4jun.GLjRenderingMode;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.opengl.support.JunGLImage;
import jp.co.sra.jun.opengl.support.JunGLInterface;
import jp.co.sra.jun.opengl.support.JunOpenGLDrawable;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderer;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;

/**
 * JunOpenGLObjectPicker class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/11/12 (by MATSUDA Ryouichi)
 *  @updated   2007/08/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLObjectPicker.java,v 8.12 2008/02/20 06:32:48 nisinaka Exp $
 */
public class JunOpenGLObjectPicker extends JunGLImage {

	/**
	 * Select the 3dObject which 2dPoint shows through Projection among a set of 3dObject.
	 * 
	 * @param a2dPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aCollectionOfJunOpenGLDisplayObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject[]
	 * @param aJunOpenGLProjection jp.co.sra.jun.opengl.projection.JunOpenGLProjection
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Utilities
	 */
	public static JunOpenGL3dObject PickObjectAt_from_projection_(Jun2dPoint a2dPoint, JunOpenGL3dObject[] aCollectionOfJunOpenGLDisplayObject, JunOpenGLProjection aJunOpenGLProjection) {
		return new JunOpenGLObjectPicker().pickObjectAt_from_projection_(a2dPoint, aCollectionOfJunOpenGLDisplayObject, aJunOpenGLProjection);
	}

	/**
	 * Select the 3dObject which 2dPoint shows through Projection among a set of 3dObject.
	 * 
	 * @param a2dPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aJunOpenGL3dCompoundDisplayObject jp.co.sra.jun.opengl.objects.JunOpenGLPickingObjects
	 * @param aJunOpenGLProjection jp.co.sra.jun.opengl.projection.JunOpenGLProjection
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Utilities
	 */
	public static JunOpenGL3dObject PickObjectAt_fromCompound_projection_(Jun2dPoint a2dPoint, JunOpenGLPickingObjects aJunOpenGL3dCompoundDisplayObject, JunOpenGLProjection aJunOpenGLProjection) {
		return new JunOpenGLObjectPicker().pickObjectAt_fromCompound_projection_(a2dPoint, aJunOpenGL3dCompoundDisplayObject, aJunOpenGLProjection);
	}

	/**
	 * Create a new instance of JunOpenGLObjectPicker and initialize it.
	 *
	 * @category Instance creation
	 */
	public JunOpenGLObjectPicker() {
		super(1, 1);
	}

	/**
	 * Answer the picking object from 3dObjects on Projection.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aCollectionOfJunOpenGLDisplayObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject[]
	 * @param aJunOpenGLProjection jp.co.sra.jun.opengl.projection.JunOpenGLProjection
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category accessing
	 */
	public JunOpenGL3dObject pickObjectAt_from_projection_(Jun2dPoint aPoint, JunOpenGL3dObject[] aCollectionOfJunOpenGLDisplayObject, JunOpenGLProjection aJunOpenGLProjection) {
		return this.pickObjectFrom_projection_(aCollectionOfJunOpenGLDisplayObject, aJunOpenGLProjection.asPickingProjectionAt_(aPoint));
	}

	/**
	 * Answer the picking object from 3dCompoundObject on Projection.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aJunOpenGL3dCompoundDisplayObject jp.co.sra.jun.opengl.picking.JunOpenGLPickingObjects
	 * @param aJunOpenGLProjection jp.co.sra.jun.opengl.projection.JunOpenGLProjection
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category accessing
	 */
	public JunOpenGL3dObject pickObjectAt_fromCompound_projection_(Jun2dPoint aPoint, JunOpenGLPickingObjects aJunOpenGL3dCompoundDisplayObject, JunOpenGLProjection aJunOpenGLProjection) {
		return this.pickObjectFromCompound_projection_(aJunOpenGL3dCompoundDisplayObject, aJunOpenGLProjection.asPickingProjectionAt_(aPoint));
	}

	/**
	 * Answer the picked object.
	 * 
	 * @param aCollectionOfJunOpenGL3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject[]
	 * @param aJunOpenGLProjection jp.co.sra.jun.opengl.projection.JunOpenGLProjection
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category accessing
	 */
	public JunOpenGL3dObject pickObjectFrom_projection_(JunOpenGL3dObject[] aCollectionOfJunOpenGL3dObject, final JunOpenGLProjection aJunOpenGLProjection) {
		final JunOpenGL3dObject[] objects = aCollectionOfJunOpenGL3dObject;

		final int[] pickedIndex = new int[1];
		this.setRenderer(new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				final JunOpenGLPickingRenderingContext pickingRenderingContext = (JunOpenGLPickingRenderingContext) renderingContext;
				pickingRenderingContext.selectionBufferSize_(objects.length * 4);
				pickingRenderingContext.projection_(aJunOpenGLProjection);
				pickedIndex[0] = pickingRenderingContext.selectNearestObjectWhile_(new StBlockClosure() {
					public Object value() {
						for (int index = 0; index < objects.length; index++) {
							pickingRenderingContext.setId_(index);
							objects[index].renderOn_(pickingRenderingContext);
						}
						return null;
					}
				});
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
			}
		});
		return (pickedIndex[0] >= 0) ? objects[pickedIndex[0]] : null;
	}

	/**
	 * Answer the picked object.
	 * 
	 * @param aJunOpenGL3dCompoundObject jp.co.sra.jun.opengl.picking.JunOpenGLPickingObjects
	 * @param aJunOpenGLProjection jp.co.sra.jun.opengl.projection.JunOpenGLProjection
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category accessing
	 */
	public JunOpenGL3dObject pickObjectFromCompound_projection_(final JunOpenGLPickingObjects aJunOpenGL3dCompoundObject, final JunOpenGLProjection aJunOpenGLProjection) {
		final JunOpenGL3dObject[] objects = aJunOpenGL3dCompoundObject.components();

		final int[] pickedIndex = new int[1];
		this.setRenderer(new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				final JunOpenGLPickingRenderingContext pickingRenderingContext = (JunOpenGLPickingRenderingContext) renderingContext;
				pickingRenderingContext.selectionBufferSize_(objects.length * 4);
				pickingRenderingContext.projection_(aJunOpenGLProjection);
				pickingRenderingContext.productTransformation_while_(aJunOpenGL3dCompoundObject.transformation(), new StBlockClosure() {
					public Object value() {
						pickedIndex[0] = pickingRenderingContext.selectNearestObjectWhile_(new StBlockClosure() {
							public Object value() {
								for (int index = 0; index < objects.length; index++) {
									pickingRenderingContext.setId_(index);
									objects[index].renderOn_(pickingRenderingContext);
								}
								return null;
							}
						});
						return null;
					}
				});
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
			}
		});
		return (pickedIndex[0] >= 0) ? objects[pickedIndex[0]] : null;
	}

	/**
	 * Display the receiver on the graphics at the specified point.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @param aPoint java.awt.Point
	 * @see jp.co.sra.smalltalk.StImage#displayOn_at_(java.awt.Graphics, java.awt.Point)
	 * @category displaying
	 */
	public void displayOn_at_(Graphics aGraphics, Point aPoint) {
		synchronized (JunGLInterface.Current) {
			int handle = -1;
			try {
				handle = JunGLInterface.Current.gljCreateContext(null, this.width(), this.height(), GLjRenderingMode.IMAGE);
				JunGLInterface.Current.gljMakeCurrent(handle);

				JunOpenGLRenderingContext renderingContext = new JunOpenGLPickingRenderingContext(this);
				this.renderOn_(renderingContext);

			} finally {
				if (handle >= 0) {
					JunGLInterface.Current.gljFlushBuffer(handle);
					JunGLInterface.Current.gljDeleteContext(handle, false);
				}
			}
		}
	}

}
