package jp.co.sra.jun.opengl.parameterizedbody;

import java.awt.event.ActionEvent;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.goodies.parameter.JunParameter;
import jp.co.sra.jun.goodies.parameter.JunParametersModel;
import jp.co.sra.jun.opengl.display.JunOpenGLEmbeddedDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunParameterizedBodyModel class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/12/08 (by MATSUDA Ryouichi)
 *  @updated   2000/01/19 (by MATSUDA Ryouichi)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun471 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunParameterizedBodyModel.java,v 8.10 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunParameterizedBodyModel extends JunApplicationModel {

	/** The parameterizedBody of the object. */
	protected JunParameterizedBody parameterizedBody;

	/** The displayModel of the object. */
	protected JunOpenGLEmbeddedDisplayModel displayModel;

	/** The parametersModel of the object. */
	protected JunParametersModel parametersModel;

	/** The interlockHolder of the object. */
	protected StValueHolder interlockHolder;

	/**
	 * Answer a class of default OpenGLDisplayModel.
	 * 
	 * @return java.lang.Class
	 */
	public static Class DefaultOpenGLDisplayModelClass() {
		return JunOpenGLEmbeddedDisplayModel.class;
	}

	/**
	 * Answer a class of default ParametersModel.
	 * 
	 * @return java.lang.Class
	 */
	public static Class DefaultParametersModelClass() {
		return JunParametersModel.class;
	}

	/**
	 * Open a new instance of JunParameterizedBodyModel with
	 * aParameterizedBody.
	 * 
	 * @param aParameterizedBody
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBodyModel
	 */
	public static JunParameterizedBodyModel OpenOnParameterizedBody_(JunParameterizedBody aParameterizedBody) {
		JunParameterizedBodyModel anApplicationModel;

		anApplicationModel = ParameterizedBody_(aParameterizedBody);
		anApplicationModel.open();

		return anApplicationModel;
	}

	/**
	 * Create a new instance of JunParameterizedBodyModel and set
	 * aParameterizedBody.
	 * 
	 * @param aParameterizedBody
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBodyModel
	 */
	public static JunParameterizedBodyModel ParameterizedBody_(JunParameterizedBody aParameterizedBody) {
		JunParameterizedBodyModel anApplicationModel;

		anApplicationModel = new JunParameterizedBodyModel();
		anApplicationModel.parameterizedBody_(aParameterizedBody);

		return anApplicationModel;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param e DOCUMENT ME!
	 */
	public void actionPerformed(ActionEvent e) {
		return;
	}

	/**
	 * Answer all parameters.
	 * 
	 * @return jp.co.sra.jun.goodies.parameterJunParameter[]
	 */
	public JunParameter[] allParameters() {
		if (this.parameterizedBody() == null) {
			return new JunParameter[] {
			};
		}

		return this.parameterizedBody().allParameters();
	}

	/**
	 * Create a Body and show it.
	 */
	public void createBody() {
		if (this.parameterizedBody() != null) {
			this.parameterizedBody().asJunOpenGL3dObject().show();
		}
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunParameterizedBodyViewAwt(this);
		} else {
			return new JunParameterizedBodyViewSwing(this);
		}
	}

	/**
	 * Answer the displayModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLEmbeddedDisplayModel
	 */
	public JunOpenGLEmbeddedDisplayModel displayModel() {
		if (displayModel == null) {
			displayModel = new JunOpenGLEmbeddedDisplayModel();
		}

		return displayModel;
	}

	/**
	 * Answer a now interlock.
	 * 
	 * @return boolean
	 */
	public boolean interlock() {
		return ((Boolean) this.interlockHolder().value()).booleanValue();
	}

	/**
	 * Answer the interlockHolder.
	 * 
	 * @return jp.co.sra.smalltalk.StValueHolder
	 */
	public StValueHolder interlockHolder() {
		if (interlockHolder == null) {
			interlockHolder = new StValueHolder(Boolean.TRUE);
			interlockHolder.addDependent_(this);
		}

		return interlockHolder;
	}

	/**
	 * Answer the parameterizedBody.
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public JunParameterizedBody parameterizedBody() {
		return parameterizedBody;
	}

	/**
	 * Set the parameterizedBody.
	 * 
	 * @param aParameterizedBody
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public void parameterizedBody_(JunParameterizedBody aParameterizedBody) {
		if (parameterizedBody != null) {
			parameterizedBody.removeDependent_(this);
		}

		parameterizedBody = aParameterizedBody;

		if (parameterizedBody != null) {
			parameterizedBody.addDependent_(this);
		}

		this.updateDisplayObject();
	}

	/**
	 * Answer the parametersModel.
	 * 
	 * @return jp.co.sra.jun.goodies.parameter.JunParametersModel
	 */
	public JunParametersModel parametersModel() {
		if (parametersModel == null) {
			parametersModel = new JunParametersModel(this.allParameters());
		}

		return parametersModel;
	}

	/**
	 * Set parameters.
	 */
	public void setParameters() {
		this.updateDisplayObject();
	}

	/**
	 * Action for the update notification.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (this.interlock()) {
			this.updateDisplayObject();
		}
	}

	/**
	 * Update the displayObject.
	 */
	public void updateDisplayObject() {
		JunOpenGL3dObject displayObject;

		if (this.parameterizedBody() != null) {
			displayObject = this.parameterizedBody().asJunOpenGL3dObject();
			this.displayModel().setDisplayObject_(displayObject);
		}
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 */
	protected String windowTitle() {
		return JunSystem.$String("Parameterized Body");
	}

}
